import * as React from "react";
import {
  CoreText,
  Display,
  Layout,
  Pill,
  PillType,
  StyledLayout,
} from "twitch-core-ui";

export const SearchKeyHints = () => {
  return (
    <StyledLayout padding={{ x: 2 }} fullWidth>
      <Layout display={Display.Flex}>
        <CoreText>
          Use <Pill label="↓" /> <Pill label="↑" /> to navigate results.
        </CoreText>
        <Layout flexGrow={1} margin={{ left: 1 }}>
          <CoreText>
            <Pill type={PillType.Overlay} label="enter" /> to select.
          </CoreText>
        </Layout>
        <CoreText>
          <Pill type={PillType.Overlay} label="esc" /> to clear search.
        </CoreText>
      </Layout>
    </StyledLayout>
  );
};
