import * as React from "react";
import {
  BorderRadius,
  Color,
  CoreText,
  FontSize,
  FontWeight,
  Interactable,
  InteractableType,
  Layout,
} from "twitch-core-ui";
import { FuseMatch } from "../utils/search-utils";
import "./styles.scss";

const EXCERPT_CHAR_LIMIT = 100;

interface Props {
  item: FuseMatch;
  index: number;
  isFocused?: boolean;
  onClick?: (index: number) => void;
  onMouseEnter?: (index: number) => void;
}

class SearchResultComponent extends React.Component<Props> {
  constructor(props: Props) {
    super(props);
  }

  public render() {
    return (
      <Interactable
        type={InteractableType.Alpha}
        borderRadius={BorderRadius.Medium}
        onClick={this.onClick}
        onMouseEnter={this.onMouseEnter}
        hover={this.props.isFocused}
        tabIndex={-1}
      >
        <Layout padding={{ x: 1, y: 0.5 }}>
          <CoreText fontSize={FontSize.Size5} fontWeight={FontWeight.SemiBold}>
            {this.props.item.item.title || "[NO TITLE]"}
          </CoreText>
          <CoreText fontSize={FontSize.Size6} color={Color.Alt}>
            {this.props.item.item.path}
          </CoreText>
          {this.props.item.item.excerpt &&
            this.props.item.item.excerpt.length > 0 && (
              <Layout margin={{ top: 1 }}>
                <CoreText>
                  {this.truncateExcerpt(
                    this.props.item.item.excerpt,
                    EXCERPT_CHAR_LIMIT,
                  )}
                </CoreText>
              </Layout>
            )}
        </Layout>
      </Interactable>
    );
  }

  private truncateExcerpt = (excerpt: string, maxCharLength: number) => {
    return excerpt.substring(0, maxCharLength) + "...";
  };

  private onMouseEnter = () => {
    if (this.props.onMouseEnter) {
      this.props.onMouseEnter(this.props.index);
    }
  };

  private onClick = () => {
    if (this.props.onClick) {
      this.props.onClick(this.props.index);
    }
  };
}

export const SearchResult = SearchResultComponent;
