import { LocationContext } from "@reach/router";
import { mount } from "enzyme";
import * as React from "react";
import { FileConnection } from "src/graphql-types";
import {
  VerticalNavigationItem,
  VerticalNavigationStateProvider,
} from "twitch-core-ui";
import { pagesQueryData } from "../../tests/data/PagesQueryData";
import { setupShallowTest } from "../../tests/helpers";
import { SidebarMenuComponent, SidebarMenuProps } from "./component";

const testLocationContext = {
  location: {
    pathname: "/user-interface/getting-started",
  },
};

function getRequiredProps(): SidebarMenuProps {
  return {
    data: {
      pages: pagesQueryData.data.pages as FileConnection,
    },
    ...(testLocationContext as LocationContext),
  };
}

const setupShallow = setupShallowTest(SidebarMenuComponent, getRequiredProps);

describe("sidebar menu component", () => {
  it("renders sidebar menu component with location and data props", () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it("renders a navigation group open by default", () => {
    const { wrapper } = setupShallow({
      location: { pathname: "/user-interface/primitives/form/checkbox" },
    } as LocationContext);

    expect(
      wrapper.find(VerticalNavigationStateProvider).props().defaultOpenGroupIDs,
    ).toEqual(["/user-interface/primitives/form"]);
  });

  it("renders selected prop to be undefined when not current route and true when current", () => {
    const wrapper = mount(<SidebarMenuComponent {...getRequiredProps()} />);

    wrapper
      .find(VerticalNavigationItem)
      .filterWhere(
        item => item.prop("linkTo") === testLocationContext.location.pathname,
      )
      .forEach(item => expect(item.prop("selected")).toBe(true));

    // Because of the way `VerticalNavigation` component is built, the hover
    // behavior is tied to the selected prop so that setting selected to
    // be false also disables the hover styles. To ensure this doesn't happen
    // until the `VerticalNavigation` is updated.
    wrapper
      .find(VerticalNavigationItem)
      .filterWhere(
        item => item.prop("linkTo") !== testLocationContext.location.pathname,
      )
      .forEach(item => expect(item.prop("selected")).toBeUndefined());
  });
});
