import { FileConnection } from "../../../graphql-types";
import { getDisplayTitle } from "../../../utils/display-titles";
import { sortByRelativePath } from "../../../utils/sort-by-relative-path";
import { MenuDataList } from "../component";

export function getMenuData(
  pages: FileConnection,
  currentPathSegment?: string,
): MenuDataList {
  let menuList: MenuDataList = [];

  if (!pages.edges) {
    return menuList;
  }

  let currentSection = pages.edges.find(
    page =>
      (page.node &&
        page.node.fields &&
        page.node.fields.segments &&
        page.node.fields.segments[0] &&
        page.node.fields.segments[0].slug === currentPathSegment &&
        page.node.fields.segments.length === 1) ||
      false,
  );

  let currentSectionPages = pages.edges.filter(
    page =>
      currentSection &&
      currentSection.node &&
      currentSection.node.fields &&
      currentSection.node.fields.segments &&
      page.node &&
      page.node.fields &&
      page.node.fields.segments &&
      page.node.fields.segments[0] &&
      page.node.fields.segments[0].slug ===
        currentSection.node.fields.segments[0].slug &&
      page.node.fields.segments.length > 1,
  );

  if (
    currentSection &&
    currentSection.node &&
    currentSection.node.fields &&
    currentSection.node.fields.segments &&
    currentSection.node.fields.title
  ) {
    let subsection = currentSectionPages.filter(
      section =>
        section.node &&
        section.node.fields &&
        section.node.fields.segments &&
        section.node.fields.segments.length === 2,
    );

    subsection.forEach((section, index) => {
      if (!section.node || !section.node.fields || !section.node.fields.title) {
        return;
      }

      let subsectionPages = currentSectionPages.filter(
        page =>
          page.node &&
          page.node.fields &&
          page.node.fields.segments &&
          page.node.fields.segments[1] &&
          section.node &&
          section.node.fields &&
          section.node.fields.segments &&
          section.node.fields.segments[1] &&
          page.node.fields.segments[1].slug ===
            section.node.fields.segments[1].slug &&
          page.node.fields.segments.length === 3,
      );

      // If this is the only page, return a link.
      if (subsectionPages.length === 0) {
        menuList.push({
          label: getDisplayTitle(section.node),
          linkTo: section.node.fields.path || "",
          subsectionIndex: index,
        });
        return;
      }

      // Otherwise, continue through the pages within this "subsection".
      // Add a subsection title.
      menuList.push(getDisplayTitle(section.node));

      subsectionPages.forEach((page, n) => {
        // Get the children of the subsection.
        let children = sortByRelativePath(currentSectionPages).filter(
          child =>
            page.node &&
            page.node.fields &&
            page.node.fields.segments &&
            page.node.fields.segments[1] &&
            page.node.fields.segments[2] &&
            child.node &&
            child.node.fields &&
            child.node.fields.segments &&
            child.node.fields.segments[1] &&
            child.node.fields.segments[2] &&
            child.node.fields.segments[1].slug ===
              page.node.fields.segments[1].slug &&
            child.node.fields.segments[2].slug ===
              page.node.fields.segments[2].slug &&
            child.node.fields.segments.length > 3,
        );

        if (children.length > 0) {
          menuList.push({
            label: (page.node && getDisplayTitle(page.node)) || "",
            linkTo:
              (page.node && page.node.fields && page.node.fields.path) || "",
            subsectionIndex: index,
            subsectionPageIndex: n,
            items: children.map(child => {
              return {
                label: (child.node && getDisplayTitle(child.node)) || "",
                linkTo:
                  (child.node && child.node.fields && child.node.fields.path) ||
                  "",
                subsectionIndex: index,
              };
            }),
          });
        } else {
          menuList.push({
            label: (page.node && getDisplayTitle(page.node)) || "",
            linkTo:
              (page.node && page.node.fields && page.node.fields.path) || "",
            subsectionIndex: index,
            subsectionPageIndex: n,
          });
        }
      });
    });
  }

  return menuList;
}
