import {
  formatPathname,
  getGroupPathname,
  getPathnameSegments,
  isCurrentPath,
} from "./path-helpers";

describe("sidebar-menu path-helpers utils", () => {
  it("formatPathname correctly formats the pathname", () => {
    (global as any).__PATH_PREFIX__ = "test";

    const expected = "/user-interface/primitives/pagination/pagination-control";

    expect(formatPathname(expected)).toEqual(expected);
    expect(formatPathname(`/test${expected}`)).toEqual(expected);
    expect(formatPathname(`test${expected}`)).toEqual(expected);
    expect(formatPathname(`${expected}/`)).toEqual(expected);
  });

  it("getPathSegments returns an array of path segments", () => {
    const pathname = "/user-interface/primitives/pagination/pagination-control";
    const expected = [
      "user-interface",
      "primitives",
      "pagination",
      "pagination-control",
    ];

    expect(getPathnameSegments(pathname)).toEqual(expected);
  });

  it("getGroupPathname returns the correct pathname for the group", () => {
    const pathname = "/user-interface/primitives/pagination/pagination-control";
    const expected = "/user-interface/primitives/pagination";

    expect(getGroupPathname(pathname)).toEqual(expected);
  });

  it("getCurrentPath matches pathnames as expected", () => {
    const itemPath = "/user-interface/patterns/transition";

    expect(isCurrentPath(itemPath, itemPath)).toBe(true);
    expect(isCurrentPath(`${itemPath}/`, itemPath)).toBe(true);
    expect(isCurrentPath(`${itemPath}-group`, itemPath)).toBe(false);
  });
});
