import { withPrefix } from "gatsby";

/**
 * Returns the current location pathname and removes the gatsby pathPrefix for
 * easier comparing.
 */
export function formatPathname(pathname: string) {
  return `/${pathname.replace(withPrefix(""), "").replace(/(^\/|\/$)/g, "")}`;
}

/**
 * Splits a pathname into an array of segments. For example,
 * `/user-interface/primitives/form/checkbox` will return
 * `["user-interface", "primitives", "form", "checkbox"]`.
 */
export function getPathnameSegments(pathname: string) {
  return formatPathname(pathname)
    .replace(/^\//, "")
    .split("/");
}

/**
 * Returns the current "group" by removing the last segment of a pathname.
 * For example, `/user-interface/primitives/form/checkbox` will return
 * `/user-interface/primitives/form`.
 */
export function getGroupPathname(pathanme: string) {
  let segments = getPathnameSegments(pathanme);
  segments.pop();
  return `/${segments.join("/")}`;
}

/**
 * Determines whether the provided location matches the items pathname
 * (with or without a trailing slash).
 */
export function isCurrentPath(currentPath: string, itemPath: string) {
  const exp = new RegExp("^" + itemPath + "(/)?$");
  return !!currentPath.match(exp);
}
