import { graphql, Link, StaticQuery } from "gatsby";
import * as React from "react";
import {
  AlignItems,
  AnimatedGlitchLogo,
  ButtonIcon,
  Color,
  Display,
  FlexDirection,
  InjectStyledLayout,
  JustifyContent,
  Layout,
  SVGAsset,
} from "twitch-core-ui";

import { renderLink } from "../../utils/render-link";
import { ThemeSwitcher } from "../theme-switcher";
import "./styles.scss";

interface SidebarPublicProps {}

interface GraphqlProps {
  data: {
    projectVersions: {
      currentProjectVersion: string;
    };
  };
}

type Props = SidebarPublicProps & GraphqlProps;

class SidebarComponent extends React.Component<Props, {}> {
  constructor(props: Props) {
    super(props);
  }

  public render() {
    return (
      <Layout
        className="sidebar"
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        alignItems={AlignItems.Center}
        flexShrink={0}
        fullHeight
      >
        <Layout
          display={Display.Flex}
          alignItems={AlignItems.Start}
          justifyContent={JustifyContent.Center}
          flexGrow={0}
          padding={0.5}
          fullWidth
          className="sidebar__heading-bar"
        >
          <InjectStyledLayout
            display={Display.Flex}
            alignItems={AlignItems.Center}
            color={Color.Overlay}
            className="sidebar__brand"
          >
            <Link to="/">
              <AnimatedGlitchLogo
                width={30}
                height={30}
                padding={{ x: 1, y: 0.5 }}
              />
            </Link>
          </InjectStyledLayout>
        </Layout>
        <Layout flexGrow={1} flexShrink={1} padding={{ top: 0.5 }}>
          <ButtonIcon
            renderLink={renderLink}
            linkTo="/"
            icon={SVGAsset.NavSearch}
            ariaLabel="Search"
            overlay
          />
        </Layout>
        <Layout padding={{ bottom: 0.5 }}>
          <ThemeSwitcher />
        </Layout>
        <Layout padding={{ top: 0.5, bottom: 1 }}>
          <ButtonIcon
            linkTo="https://git-aws.internal.justin.tv/core-ui/core-ui"
            icon={SVGAsset.Github}
            ariaLabel="Link to Core UI Github Repo"
            overlay
          />
        </Layout>
      </Layout>
    );
  }
}

export const Sidebar = (props: SidebarPublicProps) => (
  <StaticQuery
    render={data => <SidebarComponent data={data} {...props} />}
    query={graphql`
      query {
        projectVersions: consumerProjectVersionsFile {
          id
          currentProjectVersion
        }
      }
    `}
  />
);
