import { withPrefix } from "gatsby";
import * as GithubSlugger from "github-slugger";
import * as React from "react";
import {
  BorderRadius,
  CoreText,
  FontSize,
  InjectLayout,
  Interactable,
  InteractableType,
  Layout,
} from "twitch-core-ui";
import { MarkdownHeading } from "../../graphql-types";
import { renderLink } from "../../utils/render-link";

interface Props {
  headings: MarkdownHeading[];
  basePath?: string;
}

export const TableOfContents = (props: Props) => {
  const slugger = new GithubSlugger();

  return (
    <ul>
      {props.headings.map((heading, index) => {
        if (heading.depth && heading.depth < 4) {
          return (
            <InjectLayout
              padding={{ left: heading.depth > 2 ? 1 : 0 }}
              margin={{ top: heading.depth < 3 ? 0.5 : 0 }}
              key={index}
            >
              <li>
                <Interactable
                  linkTo={`${props.basePath &&
                    props.basePath.replace(withPrefix(""), "")}#${slugger.slug(
                    heading.value,
                  )}`}
                  type={InteractableType.Alpha}
                  borderRadius={BorderRadius.Medium}
                  blurAfterClick
                  renderLink={renderLink}
                >
                  <Layout padding={{ x: 1, y: 0.5 }}>
                    <CoreText fontSize={FontSize.Size5}>
                      {heading.value}
                    </CoreText>
                  </Layout>
                </Interactable>
              </li>
            </InjectLayout>
          );
        }
      })}
    </ul>
  );
};
