import * as React from "react";
import { ButtonIcon, Display, Layout, SVGAsset } from "twitch-core-ui";

interface Props {
  onThemeSwitch?: (theme: string) => void;
}

interface State {
  currentValue: string;
}

export class ThemeSwitcher extends React.Component<Props, State> {
  public state = {
    currentValue: "",
  };

  public render() {
    return (
      <Layout display={Display.Flex}>
        <ButtonIcon
          icon={
            this.state.currentValue === "tw-root--theme-dark"
              ? SVGAsset.Moon
              : SVGAsset.Moon
          }
          ariaLabel="Switch Theme"
          onClick={this.onButtonClick}
        />
      </Layout>
    );
  }

  public componentDidMount() {
    const previousTheme = localStorage.getItem("currentThemeValue");

    if (previousTheme) {
      this.setCurrentTheme(previousTheme);
      return;
    }

    this.setCurrentTheme("tw-root--theme-light");
  }

  private onButtonClick = (_: React.MouseEvent<HTMLElement>) => {
    const nextValue =
      this.state.currentValue === "tw-root--theme-light"
        ? "tw-root--theme-dark"
        : "tw-root--theme-light";
    this.setCurrentTheme(nextValue);
    localStorage.setItem("currentThemeValue", nextValue);

    if (this.props.onThemeSwitch) {
      this.props.onThemeSwitch(nextValue);
    }
  };

  private setCurrentTheme = (name: string) => {
    const wrapper = document.querySelector("html");

    if (wrapper) {
      wrapper.classList.remove("tw-root--theme-light");
      wrapper.classList.remove("tw-root--theme-dark");
      wrapper.classList.add(name);
    }

    this.setState({
      currentValue: name,
    });
  };
}
