export interface Query {
  allSitePage: SitePageConnection | null;
  allSitePlugin: SitePluginConnection | null;
  allTypeDoc: TypeDocConnection | null;
  allProjectUsageReportFile: projectUsageReportFileConnection | null;
  allGithubVersionRelease: GithubVersionReleaseConnection | null;
  allGithubCommits: GithubCommitsConnection | null;
  allConsumerProjectVersionsFile: consumerProjectVersionsFileConnection | null;
  allDirectory: DirectoryConnection | null;
  allFile: FileConnection | null;
  allMarkdownRemark: MarkdownRemarkConnection | null;
  sitePage: SitePage | null;
  sitePlugin: SitePlugin | null;
  site: Site | null;
  typeDoc: TypeDoc | null;
  projectUsageReportFile: projectUsageReportFile | null;
  githubVersionRelease: GithubVersionRelease | null;
  githubCommits: GithubCommits | null;
  consumerProjectVersionsFile: consumerProjectVersionsFile | null;
  directory: Directory | null;
  file: File | null;
  markdownRemark: MarkdownRemark | null;
}

export interface AllSitePageQueryArgs {
  skip: number | null;
  limit: number | null;
  sort: sitePageConnectionSort | null;
  filter: filterSitePage | null;
}

export interface AllSitePluginQueryArgs {
  skip: number | null;
  limit: number | null;
  sort: sitePluginConnectionSort | null;
  filter: filterSitePlugin | null;
}

export interface AllTypeDocQueryArgs {
  skip: number | null;
  limit: number | null;
  sort: typeDocConnectionSort | null;
  filter: filterTypeDoc | null;
}

export interface AllProjectUsageReportFileQueryArgs {
  skip: number | null;
  limit: number | null;
  sort: projectUsageReportFileConnectionSort | null;
  filter: filterProjectUsageReportFile | null;
}

export interface AllGithubVersionReleaseQueryArgs {
  skip: number | null;
  limit: number | null;
  sort: githubVersionReleaseConnectionSort | null;
  filter: filterGithubVersionRelease | null;
}

export interface AllGithubCommitsQueryArgs {
  skip: number | null;
  limit: number | null;
  sort: githubCommitsConnectionSort | null;
  filter: filterGithubCommits | null;
}

export interface AllConsumerProjectVersionsFileQueryArgs {
  skip: number | null;
  limit: number | null;
  sort: consumerProjectVersionsFileConnectionSort | null;
  filter: filterConsumerProjectVersionsFile | null;
}

export interface AllDirectoryQueryArgs {
  skip: number | null;
  limit: number | null;
  sort: directoryConnectionSort | null;
  filter: filterDirectory | null;
}

export interface AllFileQueryArgs {
  skip: number | null;
  limit: number | null;
  sort: fileConnectionSort | null;
  filter: filterFile | null;
}

export interface AllMarkdownRemarkQueryArgs {
  skip: number | null;
  limit: number | null;
  sort: markdownRemarkConnectionSort | null;
  filter: filterMarkdownRemark | null;
}

export interface SitePageQueryArgs {
  jsonName: sitePageJsonNameQueryString | null;
  internalComponentName: sitePageInternalComponentNameQueryString | null;
  path: sitePagePathQueryString_2 | null;
  component: sitePageComponentQueryString | null;
  componentChunkName: sitePageComponentChunkNameQueryString | null;
  context: sitePageContextInputObject | null;
  pluginCreator: sitePagePluginCreatorInputObject | null;
  pluginCreatorId: sitePagePluginCreatorIdQueryString_2 | null;
  componentPath: sitePageComponentPathQueryString | null;
  id: sitePageIdQueryString_2 | null;
  internal: sitePageInternalInputObject_2 | null;
}

export interface SitePluginQueryArgs {
  resolve: sitePluginResolveQueryString_2 | null;
  id: sitePluginIdQueryString_2 | null;
  name: sitePluginNameQueryString_2 | null;
  version: sitePluginVersionQueryString_2 | null;
  pluginOptions: sitePluginPluginOptionsInputObject_2 | null;
  nodeAPIs: sitePluginNodeApIsQueryList_2 | null;
  browserAPIs: sitePluginBrowserApIsQueryList_2 | null;
  ssrAPIs: sitePluginSsrApIsQueryList_2 | null;
  pluginFilepath: sitePluginPluginFilepathQueryString_2 | null;
  packageJson: sitePluginPackageJsonInputObject_2 | null;
  internal: sitePluginInternalInputObject_2 | null;
}

export interface SiteQueryArgs {
  siteMetadata: siteSiteMetadataInputObject_2 | null;
  port: sitePortQueryString_2 | null;
  host: siteHostQueryString_2 | null;
  polyfill: sitePolyfillQueryBoolean_2 | null;
  buildTime: siteBuildTimeQueryString_2 | null;
  id: siteIdQueryString_2 | null;
  internal: siteInternalInputObject_2 | null;
}

export interface TypeDocQueryArgs {
  component: typeDocComponentQueryString_2 | null;
  name: typeDocNameQueryString_2 | null;
  comment: typeDocCommentInputObject_2 | null;
  properties: typeDocPropertiesQueryList_2 | null;
  id: typeDocIdQueryString_2 | null;
  internal: typeDocInternalInputObject_2 | null;
}

export interface ProjectUsageReportFileQueryArgs {
  id: projectUsageReportFileIdQueryString_2 | null;
  data: projectUsageReportFileDataInputObject_2 | null;
  internal: projectUsageReportFileInternalInputObject_2 | null;
}

export interface GithubVersionReleaseQueryArgs {
  data: githubVersionReleaseDataInputObject_2 | null;
  id: githubVersionReleaseIdQueryString_2 | null;
  internal: githubVersionReleaseInternalInputObject_2 | null;
}

export interface GithubCommitsQueryArgs {
  component: githubCommitsComponentQueryString_2 | null;
  items: githubCommitsItemsQueryList_2 | null;
  id: githubCommitsIdQueryString_2 | null;
  internal: githubCommitsInternalInputObject_2 | null;
}

export interface ConsumerProjectVersionsFileQueryArgs {
  id: consumerProjectVersionsFileIdQueryString_2 | null;
  currentProjectVersion: consumerProjectVersionsFileCurrentProjectVersionQueryString_2 | null;
  internal: consumerProjectVersionsFileInternalInputObject_2 | null;
}

export interface DirectoryQueryArgs {
  id: directoryIdQueryString_2 | null;
  internal: directoryInternalInputObject_2 | null;
  sourceInstanceName: directorySourceInstanceNameQueryString_2 | null;
  absolutePath: directoryAbsolutePathQueryString_2 | null;
  relativePath: directoryRelativePathQueryString_2 | null;
  extension: directoryExtensionQueryString_2 | null;
  size: directorySizeQueryInteger_2 | null;
  prettySize: directoryPrettySizeQueryString_2 | null;
  modifiedTime: directoryModifiedTimeQueryString_2 | null;
  accessTime: directoryAccessTimeQueryString_2 | null;
  changeTime: directoryChangeTimeQueryString_2 | null;
  birthTime: directoryBirthTimeQueryString_2 | null;
  root: directoryRootQueryString_2 | null;
  dir: directoryDirQueryString_2 | null;
  base: directoryBaseQueryString_2 | null;
  ext: directoryExtQueryString_2 | null;
  name: directoryNameQueryString_2 | null;
  relativeDirectory: directoryRelativeDirectoryQueryString_2 | null;
  dev: directoryDevQueryInteger_2 | null;
  mode: directoryModeQueryInteger_2 | null;
  nlink: directoryNlinkQueryInteger_2 | null;
  uid: directoryUidQueryInteger_2 | null;
  gid: directoryGidQueryInteger_2 | null;
  rdev: directoryRdevQueryInteger_2 | null;
  blksize: directoryBlksizeQueryInteger_2 | null;
  ino: directoryInoQueryInteger_2 | null;
  blocks: directoryBlocksQueryInteger_2 | null;
  atimeMs: directoryAtimeMsQueryFloat_2 | null;
  mtimeMs: directoryMtimeMsQueryFloat_2 | null;
  ctimeMs: directoryCtimeMsQueryFloat_2 | null;
  birthtimeMs: directoryBirthtimeMsQueryFloat_2 | null;
  atime: directoryAtimeQueryString_2 | null;
  mtime: directoryMtimeQueryString_2 | null;
  ctime: directoryCtimeQueryString_2 | null;
  birthtime: directoryBirthtimeQueryString_2 | null;
}

export interface FileQueryArgs {
  id: fileIdQueryString_2 | null;
  internal: fileInternalInputObject_2 | null;
  sourceInstanceName: fileSourceInstanceNameQueryString_2 | null;
  absolutePath: fileAbsolutePathQueryString_2 | null;
  relativePath: fileRelativePathQueryString_2 | null;
  extension: fileExtensionQueryString_2 | null;
  size: fileSizeQueryInteger_2 | null;
  prettySize: filePrettySizeQueryString_2 | null;
  modifiedTime: fileModifiedTimeQueryString_2 | null;
  accessTime: fileAccessTimeQueryString_2 | null;
  changeTime: fileChangeTimeQueryString_2 | null;
  birthTime: fileBirthTimeQueryString_2 | null;
  root: fileRootQueryString_2 | null;
  dir: fileDirQueryString_2 | null;
  base: fileBaseQueryString_2 | null;
  ext: fileExtQueryString_2 | null;
  name: fileNameQueryString_2 | null;
  relativeDirectory: fileRelativeDirectoryQueryString_2 | null;
  dev: fileDevQueryInteger_2 | null;
  mode: fileModeQueryInteger_2 | null;
  nlink: fileNlinkQueryInteger_2 | null;
  uid: fileUidQueryInteger_2 | null;
  gid: fileGidQueryInteger_2 | null;
  rdev: fileRdevQueryInteger_2 | null;
  blksize: fileBlksizeQueryInteger_2 | null;
  ino: fileInoQueryInteger_2 | null;
  blocks: fileBlocksQueryInteger_2 | null;
  atimeMs: fileAtimeMsQueryFloat_2 | null;
  mtimeMs: fileMtimeMsQueryFloat_2 | null;
  ctimeMs: fileCtimeMsQueryFloat_2 | null;
  birthtimeMs: fileBirthtimeMsQueryFloat_2 | null;
  atime: fileAtimeQueryString_2 | null;
  mtime: fileMtimeQueryString_2 | null;
  ctime: fileCtimeQueryString_2 | null;
  birthtime: fileBirthtimeQueryString_2 | null;
  fields: fileFieldsInputObject_2 | null;
  publicURL: publicUrlQueryString_3 | null;
}

export interface MarkdownRemarkQueryArgs {
  id: markdownRemarkIdQueryString_2 | null;
  internal: markdownRemarkInternalInputObject_2 | null;
  frontmatter: markdownRemarkFrontmatterInputObject_2 | null;
  excerpt: excerptQueryString_3 | null;
  rawMarkdownBody: markdownRemarkRawMarkdownBodyQueryString_2 | null;
  fileAbsolutePath: markdownRemarkFileAbsolutePathQueryString_2 | null;
  html: htmlQueryString_3 | null;
  headings: headingsQueryList_3 | null;
  timeToRead: timeToReadQueryInt_3 | null;
  tableOfContents: tableOfContentsQueryString_3 | null;
  wordCount: wordCountTypeName_3 | null;
}

export interface sitePageConnectionSort {
  fields: Array<SitePageConnectionSortByFieldsEnum>;
  order: sitePageConnectionSortOrderValues | null;
}

export type SitePageConnectionSortByFieldsEnum =
  | "jsonName"
  | "internalComponentName"
  | "path"
  | "component"
  | "componentChunkName"
  | "context___pagePath"
  | "context___componentId"
  | "context___tab"
  | "context___title"
  | "context___showSidebarMenu"
  | "pluginCreator___NODE"
  | "pluginCreatorId"
  | "componentPath"
  | "id"
  | "parent"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___description"
  | "internal___owner";

export type sitePageConnectionSortOrderValues = "ASC" | "DESC";

export interface filterSitePage {
  jsonName: sitePageConnectionJsonNameQueryString | null;
  internalComponentName: sitePageConnectionInternalComponentNameQueryString | null;
  path: sitePageConnectionPathQueryString_2 | null;
  component: sitePageConnectionComponentQueryString | null;
  componentChunkName: sitePageConnectionComponentChunkNameQueryString | null;
  context: sitePageConnectionContextInputObject | null;
  pluginCreator: sitePageConnectionPluginCreatorInputObject | null;
  pluginCreatorId: sitePageConnectionPluginCreatorIdQueryString_2 | null;
  componentPath: sitePageConnectionComponentPathQueryString | null;
  id: sitePageConnectionIdQueryString_2 | null;
  internal: sitePageConnectionInternalInputObject_2 | null;
}

export interface sitePageConnectionJsonNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionInternalComponentNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionComponentQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionComponentChunkNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionContextInputObject {
  pagePath: sitePageConnectionContextPagePathQueryString | null;
  componentId: sitePageConnectionContextComponentIdQueryString | null;
  tab: sitePageConnectionContextTabQueryString | null;
  title: sitePageConnectionContextTitleQueryString | null;
  showSidebarMenu: sitePageConnectionContextShowSidebarMenuQueryBoolean | null;
}

export interface sitePageConnectionContextPagePathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionContextComponentIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionContextTabQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionContextTitleQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionContextShowSidebarMenuQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePageConnectionPluginCreatorInputObject {
  resolve: sitePageConnectionPluginCreatorResolveQueryString | null;
  id: sitePageConnectionPluginCreatorIdQueryString | null;
  name: sitePageConnectionPluginCreatorNameQueryString | null;
  version: sitePageConnectionPluginCreatorVersionQueryString | null;
  pluginOptions: sitePageConnectionPluginCreatorPluginOptionsInputObject | null;
  nodeAPIs: sitePageConnectionPluginCreatorNodeApIsQueryList | null;
  browserAPIs: sitePageConnectionPluginCreatorBrowserApIsQueryList | null;
  ssrAPIs: sitePageConnectionPluginCreatorSsrApIsQueryList | null;
  pluginFilepath: sitePageConnectionPluginCreatorPluginFilepathQueryString | null;
  packageJson: sitePageConnectionPluginCreatorPackageJsonInputObject | null;
  parent: sitePageConnectionPluginCreatorParentQueryString | null;
  internal: sitePageConnectionPluginCreatorInternalInputObject | null;
}

export interface sitePageConnectionPluginCreatorResolveQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsInputObject {
  plugins: sitePageConnectionPluginCreatorPluginOptionsPluginsQueryList | null;
  trackingId: sitePageConnectionPluginCreatorPluginOptionsTrackingIdQueryString | null;
  head: sitePageConnectionPluginCreatorPluginOptionsHeadQueryBoolean | null;
  anonymize: sitePageConnectionPluginCreatorPluginOptionsAnonymizeQueryBoolean | null;
  respectDNT: sitePageConnectionPluginCreatorPluginOptionsRespectDntQueryBoolean | null;
  baseDir: sitePageConnectionPluginCreatorPluginOptionsBaseDirQueryString | null;
  user: sitePageConnectionPluginCreatorPluginOptionsUserQueryString | null;
  repository: sitePageConnectionPluginCreatorPluginOptionsRepositoryQueryString | null;
  token: sitePageConnectionPluginCreatorPluginOptionsTokenQueryString | null;
  rootURL: sitePageConnectionPluginCreatorPluginOptionsRootUrlQueryString | null;
  name: sitePageConnectionPluginCreatorPluginOptionsNameQueryString | null;
  path: sitePageConnectionPluginCreatorPluginOptionsPathQueryString | null;
  maxWidth: sitePageConnectionPluginCreatorPluginOptionsMaxWidthQueryInteger | null;
  backgroundColor: sitePageConnectionPluginCreatorPluginOptionsBackgroundColorQueryString | null;
  includePaths: sitePageConnectionPluginCreatorPluginOptionsIncludePathsQueryList | null;
  sourceMaps: sitePageConnectionPluginCreatorPluginOptionsSourceMapsQueryBoolean | null;
  pathCheck: sitePageConnectionPluginCreatorPluginOptionsPathCheckQueryBoolean | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsQueryList {
  elemMatch: sitePageConnectionPluginCreatorPluginOptionsPluginsInputObject | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsInputObject {
  resolve: sitePageConnectionPluginCreatorPluginOptionsPluginsResolveQueryString | null;
  id: sitePageConnectionPluginCreatorPluginOptionsPluginsIdQueryString | null;
  name: sitePageConnectionPluginCreatorPluginOptionsPluginsNameQueryString | null;
  version: sitePageConnectionPluginCreatorPluginOptionsPluginsVersionQueryString | null;
  pluginOptions: sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsInputObject | null;
  browserAPIs: sitePageConnectionPluginCreatorPluginOptionsPluginsBrowserApIsQueryList | null;
  ssrAPIs: sitePageConnectionPluginCreatorPluginOptionsPluginsSsrApIsQueryList | null;
  pluginFilepath: sitePageConnectionPluginCreatorPluginOptionsPluginsPluginFilepathQueryString | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsResolveQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsInputObject {
  maxWidth: sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger | null;
  backgroundColor: sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsBackgroundColorQueryString | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsPluginOptionsBackgroundColorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsBrowserApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsSsrApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPluginsPluginFilepathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsTrackingIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsHeadQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsAnonymizeQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsRespectDntQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsBaseDirQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsUserQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsRepositoryQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsTokenQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsRootUrlQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsMaxWidthQueryInteger {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsBackgroundColorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsIncludePathsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsSourceMapsQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePageConnectionPluginCreatorPluginOptionsPathCheckQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePageConnectionPluginCreatorNodeApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorBrowserApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorSsrApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPluginFilepathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonInputObject {
  name: sitePageConnectionPluginCreatorPackageJsonNameQueryString | null;
  description: sitePageConnectionPluginCreatorPackageJsonDescriptionQueryString | null;
  version: sitePageConnectionPluginCreatorPackageJsonVersionQueryString | null;
  main: sitePageConnectionPluginCreatorPackageJsonMainQueryString | null;
  author: sitePageConnectionPluginCreatorPackageJsonAuthorQueryString | null;
  license: sitePageConnectionPluginCreatorPackageJsonLicenseQueryString | null;
  dependencies: sitePageConnectionPluginCreatorPackageJsonDependenciesQueryList | null;
  devDependencies: sitePageConnectionPluginCreatorPackageJsonDevDependenciesQueryList | null;
  peerDependencies: sitePageConnectionPluginCreatorPackageJsonPeerDependenciesQueryList | null;
  keywords: sitePageConnectionPluginCreatorPackageJsonKeywordsQueryList | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDescriptionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonMainQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonAuthorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonLicenseQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDependenciesQueryList {
  elemMatch: sitePageConnectionPluginCreatorPackageJsonDependenciesInputObject | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDependenciesInputObject {
  name: sitePageConnectionPluginCreatorPackageJsonDependenciesNameQueryString | null;
  version: sitePageConnectionPluginCreatorPackageJsonDependenciesVersionQueryString | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDevDependenciesQueryList {
  elemMatch: sitePageConnectionPluginCreatorPackageJsonDevDependenciesInputObject | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDevDependenciesInputObject {
  name: sitePageConnectionPluginCreatorPackageJsonDevDependenciesNameQueryString | null;
  version: sitePageConnectionPluginCreatorPackageJsonDevDependenciesVersionQueryString | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDevDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonDevDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonPeerDependenciesQueryList {
  elemMatch: sitePageConnectionPluginCreatorPackageJsonPeerDependenciesInputObject | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonPeerDependenciesInputObject {
  name: sitePageConnectionPluginCreatorPackageJsonPeerDependenciesNameQueryString | null;
  version: sitePageConnectionPluginCreatorPackageJsonPeerDependenciesVersionQueryString | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonPeerDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonPeerDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorPackageJsonKeywordsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorParentQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorInternalInputObject {
  contentDigest: sitePageConnectionPluginCreatorInternalContentDigestQueryString | null;
  type: sitePageConnectionPluginCreatorInternalTypeQueryString | null;
  owner: sitePageConnectionPluginCreatorInternalOwnerQueryString | null;
}

export interface sitePageConnectionPluginCreatorInternalContentDigestQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorInternalTypeQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorInternalOwnerQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionPluginCreatorIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionComponentPathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionInternalInputObject_2 {
  type: sitePageConnectionInternalTypeQueryString_2 | null;
  contentDigest: sitePageConnectionInternalContentDigestQueryString_2 | null;
  description: sitePageConnectionInternalDescriptionQueryString | null;
  owner: sitePageConnectionInternalOwnerQueryString_2 | null;
}

export interface sitePageConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionInternalDescriptionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface SitePageConnection {
  pageInfo: PageInfo;
  edges: Array<SitePageEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<sitePageGroupConnectionConnection> | null;
}

export interface DistinctSitePageConnectionArgs {
  field: sitePageDistinctEnum | null;
}

export interface GroupSitePageConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: sitePageGroupEnum | null;
}

export interface PageInfo {
  hasNextPage: boolean;
}

export interface SitePageEdge {
  node: SitePage | null;
  next: SitePage | null;
  previous: SitePage | null;
}

export interface SitePage extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  jsonName: string | null;
  internalComponentName: string | null;
  path: string | null;
  component: string | null;
  componentChunkName: string | null;
  context: context | null;
  pluginCreator: SitePlugin | null;
  pluginCreatorId: string | null;
  componentPath: string | null;
  internal: internal_12 | null;
}

export interface Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
}

export interface context {
  pagePath: string | null;
  componentId: string | null;
  tab: string | null;
  title: string | null;
  showSidebarMenu: boolean | null;
}

export interface SitePlugin extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  resolve: string | null;
  name: string | null;
  version: string | null;
  pluginOptions: pluginOptions_3 | null;
  nodeAPIs: Array<string> | null;
  browserAPIs: Array<string> | null;
  ssrAPIs: Array<string> | null;
  pluginFilepath: string | null;
  packageJson: packageJson_2 | null;
  internal: internal_13 | null;
}

export interface pluginOptions_3 {
  plugins: Array<plugins_2> | null;
  trackingId: string | null;
  head: boolean | null;
  anonymize: boolean | null;
  respectDNT: boolean | null;
  baseDir: string | null;
  user: string | null;
  repository: string | null;
  token: string | null;
  rootURL: string | null;
  name: string | null;
  path: string | null;
  maxWidth: number | null;
  backgroundColor: string | null;
  includePaths: Array<string> | null;
  sourceMaps: boolean | null;
  pathCheck: boolean | null;
}

export interface plugins_2 {
  resolve: string | null;
  id: string | null;
  name: string | null;
  version: string | null;
  pluginOptions: pluginOptions_4 | null;
  browserAPIs: Array<string> | null;
  ssrAPIs: Array<string> | null;
  pluginFilepath: string | null;
}

export interface pluginOptions_4 {
  maxWidth: number | null;
  backgroundColor: string | null;
}

export interface packageJson_2 {
  name: string | null;
  description: string | null;
  version: string | null;
  main: string | null;
  author: string | null;
  license: string | null;
  dependencies: Array<dependencies_2> | null;
  devDependencies: Array<devDependencies_2> | null;
  peerDependencies: Array<peerDependencies_2> | null;
  keywords: Array<string> | null;
}

export interface dependencies_2 {
  name: string | null;
  version: string | null;
}

export interface devDependencies_2 {
  name: string | null;
  version: string | null;
}

export interface peerDependencies_2 {
  name: string | null;
  version: string | null;
}

export interface internal_13 {
  contentDigest: string | null;
  type: string | null;
  owner: string | null;
}

export interface internal_12 {
  type: string | null;
  contentDigest: string | null;
  description: string | null;
  owner: string | null;
}

export type sitePageDistinctEnum =
  | "jsonName"
  | "internalComponentName"
  | "path"
  | "component"
  | "componentChunkName"
  | "context___pagePath"
  | "context___componentId"
  | "context___tab"
  | "context___title"
  | "context___showSidebarMenu"
  | "pluginCreator___NODE"
  | "pluginCreatorId"
  | "componentPath"
  | "id"
  | "parent"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___description"
  | "internal___owner";

export type sitePageGroupEnum =
  | "jsonName"
  | "internalComponentName"
  | "path"
  | "component"
  | "componentChunkName"
  | "context___pagePath"
  | "context___componentId"
  | "context___tab"
  | "context___title"
  | "context___showSidebarMenu"
  | "pluginCreator___NODE"
  | "pluginCreatorId"
  | "componentPath"
  | "id"
  | "parent"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___description"
  | "internal___owner";

export interface sitePageGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<sitePageGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface sitePageGroupConnectionEdge {
  node: SitePage | null;
  next: SitePage | null;
  previous: SitePage | null;
}

export interface sitePluginConnectionSort {
  fields: Array<SitePluginConnectionSortByFieldsEnum>;
  order: sitePluginConnectionSortOrderValues | null;
}

export type SitePluginConnectionSortByFieldsEnum =
  | "resolve"
  | "id"
  | "name"
  | "version"
  | "pluginOptions___plugins"
  | "pluginOptions___trackingId"
  | "pluginOptions___head"
  | "pluginOptions___anonymize"
  | "pluginOptions___respectDNT"
  | "pluginOptions___baseDir"
  | "pluginOptions___user"
  | "pluginOptions___repository"
  | "pluginOptions___token"
  | "pluginOptions___rootURL"
  | "pluginOptions___name"
  | "pluginOptions___path"
  | "pluginOptions___maxWidth"
  | "pluginOptions___backgroundColor"
  | "pluginOptions___includePaths"
  | "pluginOptions___sourceMaps"
  | "pluginOptions___postCssPlugins"
  | "pluginOptions___pathCheck"
  | "nodeAPIs"
  | "browserAPIs"
  | "ssrAPIs"
  | "pluginFilepath"
  | "packageJson___name"
  | "packageJson___description"
  | "packageJson___version"
  | "packageJson___main"
  | "packageJson___author"
  | "packageJson___license"
  | "packageJson___dependencies"
  | "packageJson___devDependencies"
  | "packageJson___peerDependencies"
  | "packageJson___keywords"
  | "parent"
  | "internal___contentDigest"
  | "internal___type"
  | "internal___owner";

export type sitePluginConnectionSortOrderValues = "ASC" | "DESC";

export interface filterSitePlugin {
  resolve: sitePluginConnectionResolveQueryString_2 | null;
  id: sitePluginConnectionIdQueryString_2 | null;
  name: sitePluginConnectionNameQueryString_2 | null;
  version: sitePluginConnectionVersionQueryString_2 | null;
  pluginOptions: sitePluginConnectionPluginOptionsInputObject_2 | null;
  nodeAPIs: sitePluginConnectionNodeApIsQueryList_2 | null;
  browserAPIs: sitePluginConnectionBrowserApIsQueryList_2 | null;
  ssrAPIs: sitePluginConnectionSsrApIsQueryList_2 | null;
  pluginFilepath: sitePluginConnectionPluginFilepathQueryString_2 | null;
  packageJson: sitePluginConnectionPackageJsonInputObject_2 | null;
  internal: sitePluginConnectionInternalInputObject_2 | null;
}

export interface sitePluginConnectionResolveQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsInputObject_2 {
  plugins: sitePluginConnectionPluginOptionsPluginsQueryList_2 | null;
  trackingId: sitePluginConnectionPluginOptionsTrackingIdQueryString_2 | null;
  head: sitePluginConnectionPluginOptionsHeadQueryBoolean_2 | null;
  anonymize: sitePluginConnectionPluginOptionsAnonymizeQueryBoolean_2 | null;
  respectDNT: sitePluginConnectionPluginOptionsRespectDntQueryBoolean_2 | null;
  baseDir: sitePluginConnectionPluginOptionsBaseDirQueryString_2 | null;
  user: sitePluginConnectionPluginOptionsUserQueryString_2 | null;
  repository: sitePluginConnectionPluginOptionsRepositoryQueryString_2 | null;
  token: sitePluginConnectionPluginOptionsTokenQueryString_2 | null;
  rootURL: sitePluginConnectionPluginOptionsRootUrlQueryString_2 | null;
  name: sitePluginConnectionPluginOptionsNameQueryString_2 | null;
  path: sitePluginConnectionPluginOptionsPathQueryString_2 | null;
  maxWidth: sitePluginConnectionPluginOptionsMaxWidthQueryInteger_2 | null;
  backgroundColor: sitePluginConnectionPluginOptionsBackgroundColorQueryString_2 | null;
  includePaths: sitePluginConnectionPluginOptionsIncludePathsQueryList_2 | null;
  sourceMaps: sitePluginConnectionPluginOptionsSourceMapsQueryBoolean_2 | null;
  pathCheck: sitePluginConnectionPluginOptionsPathCheckQueryBoolean_2 | null;
}

export interface sitePluginConnectionPluginOptionsPluginsQueryList_2 {
  elemMatch: sitePluginConnectionPluginOptionsPluginsInputObject_2 | null;
}

export interface sitePluginConnectionPluginOptionsPluginsInputObject_2 {
  resolve: sitePluginConnectionPluginOptionsPluginsResolveQueryString_2 | null;
  id: sitePluginConnectionPluginOptionsPluginsIdQueryString_2 | null;
  name: sitePluginConnectionPluginOptionsPluginsNameQueryString_2 | null;
  version: sitePluginConnectionPluginOptionsPluginsVersionQueryString_2 | null;
  pluginOptions: sitePluginConnectionPluginOptionsPluginsPluginOptionsInputObject_2 | null;
  browserAPIs: sitePluginConnectionPluginOptionsPluginsBrowserApIsQueryList_2 | null;
  ssrAPIs: sitePluginConnectionPluginOptionsPluginsSsrApIsQueryList_2 | null;
  pluginFilepath: sitePluginConnectionPluginOptionsPluginsPluginFilepathQueryString_2 | null;
}

export interface sitePluginConnectionPluginOptionsPluginsResolveQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsPluginOptionsInputObject_2 {
  maxWidth: sitePluginConnectionPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger_2 | null;
  backgroundColor: sitePluginConnectionPluginOptionsPluginsPluginOptionsBackgroundColorQueryString_2 | null;
}

export interface sitePluginConnectionPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsPluginOptionsBackgroundColorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsBrowserApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsSsrApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsPluginsPluginFilepathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsTrackingIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsHeadQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePluginConnectionPluginOptionsAnonymizeQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePluginConnectionPluginOptionsRespectDntQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePluginConnectionPluginOptionsBaseDirQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsUserQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsRepositoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsTokenQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsRootUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsMaxWidthQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface sitePluginConnectionPluginOptionsBackgroundColorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsIncludePathsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginOptionsSourceMapsQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePluginConnectionPluginOptionsPathCheckQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePluginConnectionNodeApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionBrowserApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionSsrApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPluginFilepathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonInputObject_2 {
  name: sitePluginConnectionPackageJsonNameQueryString_2 | null;
  description: sitePluginConnectionPackageJsonDescriptionQueryString_2 | null;
  version: sitePluginConnectionPackageJsonVersionQueryString_2 | null;
  main: sitePluginConnectionPackageJsonMainQueryString_2 | null;
  author: sitePluginConnectionPackageJsonAuthorQueryString_2 | null;
  license: sitePluginConnectionPackageJsonLicenseQueryString_2 | null;
  dependencies: sitePluginConnectionPackageJsonDependenciesQueryList_2 | null;
  devDependencies: sitePluginConnectionPackageJsonDevDependenciesQueryList_2 | null;
  peerDependencies: sitePluginConnectionPackageJsonPeerDependenciesQueryList_2 | null;
  keywords: sitePluginConnectionPackageJsonKeywordsQueryList_2 | null;
}

export interface sitePluginConnectionPackageJsonNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonMainQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonAuthorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonLicenseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonDependenciesQueryList_2 {
  elemMatch: sitePluginConnectionPackageJsonDependenciesInputObject_2 | null;
}

export interface sitePluginConnectionPackageJsonDependenciesInputObject_2 {
  name: sitePluginConnectionPackageJsonDependenciesNameQueryString_2 | null;
  version: sitePluginConnectionPackageJsonDependenciesVersionQueryString_2 | null;
}

export interface sitePluginConnectionPackageJsonDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonDevDependenciesQueryList_2 {
  elemMatch: sitePluginConnectionPackageJsonDevDependenciesInputObject_2 | null;
}

export interface sitePluginConnectionPackageJsonDevDependenciesInputObject_2 {
  name: sitePluginConnectionPackageJsonDevDependenciesNameQueryString_2 | null;
  version: sitePluginConnectionPackageJsonDevDependenciesVersionQueryString_2 | null;
}

export interface sitePluginConnectionPackageJsonDevDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonDevDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonPeerDependenciesQueryList_2 {
  elemMatch: sitePluginConnectionPackageJsonPeerDependenciesInputObject_2 | null;
}

export interface sitePluginConnectionPackageJsonPeerDependenciesInputObject_2 {
  name: sitePluginConnectionPackageJsonPeerDependenciesNameQueryString_2 | null;
  version: sitePluginConnectionPackageJsonPeerDependenciesVersionQueryString_2 | null;
}

export interface sitePluginConnectionPackageJsonPeerDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonPeerDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionPackageJsonKeywordsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionInternalInputObject_2 {
  contentDigest: sitePluginConnectionInternalContentDigestQueryString_2 | null;
  type: sitePluginConnectionInternalTypeQueryString_2 | null;
  owner: sitePluginConnectionInternalOwnerQueryString_2 | null;
}

export interface sitePluginConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface SitePluginConnection {
  pageInfo: PageInfo;
  edges: Array<SitePluginEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<sitePluginGroupConnectionConnection> | null;
}

export interface DistinctSitePluginConnectionArgs {
  field: sitePluginDistinctEnum | null;
}

export interface GroupSitePluginConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: sitePluginGroupEnum | null;
}

export interface SitePluginEdge {
  node: SitePlugin | null;
  next: SitePlugin | null;
  previous: SitePlugin | null;
}

export type sitePluginDistinctEnum =
  | "resolve"
  | "id"
  | "name"
  | "version"
  | "pluginOptions___plugins"
  | "pluginOptions___trackingId"
  | "pluginOptions___head"
  | "pluginOptions___anonymize"
  | "pluginOptions___respectDNT"
  | "pluginOptions___baseDir"
  | "pluginOptions___user"
  | "pluginOptions___repository"
  | "pluginOptions___token"
  | "pluginOptions___rootURL"
  | "pluginOptions___name"
  | "pluginOptions___path"
  | "pluginOptions___maxWidth"
  | "pluginOptions___backgroundColor"
  | "pluginOptions___includePaths"
  | "pluginOptions___sourceMaps"
  | "pluginOptions___postCssPlugins"
  | "pluginOptions___pathCheck"
  | "nodeAPIs"
  | "browserAPIs"
  | "ssrAPIs"
  | "pluginFilepath"
  | "packageJson___name"
  | "packageJson___description"
  | "packageJson___version"
  | "packageJson___main"
  | "packageJson___author"
  | "packageJson___license"
  | "packageJson___dependencies"
  | "packageJson___devDependencies"
  | "packageJson___peerDependencies"
  | "packageJson___keywords"
  | "parent"
  | "internal___contentDigest"
  | "internal___type"
  | "internal___owner";

export type sitePluginGroupEnum =
  | "resolve"
  | "id"
  | "name"
  | "version"
  | "pluginOptions___plugins"
  | "pluginOptions___trackingId"
  | "pluginOptions___head"
  | "pluginOptions___anonymize"
  | "pluginOptions___respectDNT"
  | "pluginOptions___baseDir"
  | "pluginOptions___user"
  | "pluginOptions___repository"
  | "pluginOptions___token"
  | "pluginOptions___rootURL"
  | "pluginOptions___name"
  | "pluginOptions___path"
  | "pluginOptions___maxWidth"
  | "pluginOptions___backgroundColor"
  | "pluginOptions___includePaths"
  | "pluginOptions___sourceMaps"
  | "pluginOptions___postCssPlugins"
  | "pluginOptions___pathCheck"
  | "nodeAPIs"
  | "browserAPIs"
  | "ssrAPIs"
  | "pluginFilepath"
  | "packageJson___name"
  | "packageJson___description"
  | "packageJson___version"
  | "packageJson___main"
  | "packageJson___author"
  | "packageJson___license"
  | "packageJson___dependencies"
  | "packageJson___devDependencies"
  | "packageJson___peerDependencies"
  | "packageJson___keywords"
  | "parent"
  | "internal___contentDigest"
  | "internal___type"
  | "internal___owner";

export interface sitePluginGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<sitePluginGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface sitePluginGroupConnectionEdge {
  node: SitePlugin | null;
  next: SitePlugin | null;
  previous: SitePlugin | null;
}

export interface typeDocConnectionSort {
  fields: Array<TypeDocConnectionSortByFieldsEnum>;
  order: typeDocConnectionSortOrderValues | null;
}

export type TypeDocConnectionSortByFieldsEnum =
  | "component"
  | "name"
  | "comment___shortText"
  | "comment___tags"
  | "properties"
  | "id"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export type typeDocConnectionSortOrderValues = "ASC" | "DESC";

export interface filterTypeDoc {
  component: typeDocConnectionComponentQueryString_2 | null;
  name: typeDocConnectionNameQueryString_2 | null;
  comment: typeDocConnectionCommentInputObject_2 | null;
  properties: typeDocConnectionPropertiesQueryList_2 | null;
  id: typeDocConnectionIdQueryString_2 | null;
  internal: typeDocConnectionInternalInputObject_2 | null;
}

export interface typeDocConnectionComponentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionCommentInputObject_2 {
  shortText: typeDocConnectionCommentShortTextQueryString_2 | null;
  tags: typeDocConnectionCommentTagsQueryList_2 | null;
}

export interface typeDocConnectionCommentShortTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionCommentTagsQueryList_2 {
  elemMatch: typeDocConnectionCommentTagsInputObject_2 | null;
}

export interface typeDocConnectionCommentTagsInputObject_2 {
  tag: typeDocConnectionCommentTagsTagQueryString_2 | null;
  text: typeDocConnectionCommentTagsTextQueryString_2 | null;
}

export interface typeDocConnectionCommentTagsTagQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionCommentTagsTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesQueryList_2 {
  elemMatch: typeDocConnectionPropertiesInputObject_2 | null;
}

export interface typeDocConnectionPropertiesInputObject_2 {
  name: typeDocConnectionPropertiesNameQueryString_2 | null;
  availableValues: typeDocConnectionPropertiesAvailableValuesQueryList_2 | null;
  flags: typeDocConnectionPropertiesFlagsInputObject_2 | null;
  comment: typeDocConnectionPropertiesCommentInputObject_2 | null;
  breakpointCompatible: typeDocConnectionPropertiesBreakpointCompatibleQueryBoolean_2 | null;
  type: typeDocConnectionPropertiesTypeQueryString_2 | null;
  sourceSrc: typeDocConnectionPropertiesSourceSrcQueryString_2 | null;
}

export interface typeDocConnectionPropertiesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesAvailableValuesQueryList_2 {
  elemMatch: typeDocConnectionPropertiesAvailableValuesInputObject_2 | null;
}

export interface typeDocConnectionPropertiesAvailableValuesInputObject_2 {
  name: typeDocConnectionPropertiesAvailableValuesNameQueryString_2 | null;
  sourceSrc: typeDocConnectionPropertiesAvailableValuesSourceSrcQueryString_2 | null;
  values: typeDocConnectionPropertiesAvailableValuesValuesQueryList_2 | null;
  properties: typeDocConnectionPropertiesAvailableValuesPropertiesQueryList_2 | null;
}

export interface typeDocConnectionPropertiesAvailableValuesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesAvailableValuesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesAvailableValuesValuesQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesAvailableValuesPropertiesQueryList_2 {
  elemMatch: typeDocConnectionPropertiesAvailableValuesPropertiesInputObject_2 | null;
}

export interface typeDocConnectionPropertiesAvailableValuesPropertiesInputObject_2 {
  name: typeDocConnectionPropertiesAvailableValuesPropertiesNameQueryString_2 | null;
  value: typeDocConnectionPropertiesAvailableValuesPropertiesValueQueryString_2 | null;
  isOptional: typeDocConnectionPropertiesAvailableValuesPropertiesIsOptionalQueryBoolean_2 | null;
  sourceSrc: typeDocConnectionPropertiesAvailableValuesPropertiesSourceSrcQueryString_2 | null;
}

export interface typeDocConnectionPropertiesAvailableValuesPropertiesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesAvailableValuesPropertiesValueQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesAvailableValuesPropertiesIsOptionalQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface typeDocConnectionPropertiesAvailableValuesPropertiesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesFlagsInputObject_2 {
  isExported: typeDocConnectionPropertiesFlagsIsExportedQueryBoolean_2 | null;
  isOptional: typeDocConnectionPropertiesFlagsIsOptionalQueryBoolean_2 | null;
}

export interface typeDocConnectionPropertiesFlagsIsExportedQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface typeDocConnectionPropertiesFlagsIsOptionalQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface typeDocConnectionPropertiesCommentInputObject_2 {
  tags: typeDocConnectionPropertiesCommentTagsQueryList_2 | null;
  shortText: typeDocConnectionPropertiesCommentShortTextQueryString_2 | null;
  text: typeDocConnectionPropertiesCommentTextQueryString_2 | null;
}

export interface typeDocConnectionPropertiesCommentTagsQueryList_2 {
  elemMatch: typeDocConnectionPropertiesCommentTagsInputObject_2 | null;
}

export interface typeDocConnectionPropertiesCommentTagsInputObject_2 {
  tag: typeDocConnectionPropertiesCommentTagsTagQueryString_2 | null;
  text: typeDocConnectionPropertiesCommentTagsTextQueryString_2 | null;
  param: typeDocConnectionPropertiesCommentTagsParamQueryString_2 | null;
}

export interface typeDocConnectionPropertiesCommentTagsTagQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesCommentTagsTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesCommentTagsParamQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesCommentShortTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesCommentTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesBreakpointCompatibleQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface typeDocConnectionPropertiesTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionPropertiesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionInternalInputObject_2 {
  type: typeDocConnectionInternalTypeQueryString_2 | null;
  contentDigest: typeDocConnectionInternalContentDigestQueryString_2 | null;
  owner: typeDocConnectionInternalOwnerQueryString_2 | null;
}

export interface typeDocConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface TypeDocConnection {
  pageInfo: PageInfo;
  edges: Array<TypeDocEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<typeDocGroupConnectionConnection> | null;
}

export interface DistinctTypeDocConnectionArgs {
  field: typeDocDistinctEnum | null;
}

export interface GroupTypeDocConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: typeDocGroupEnum | null;
}

export interface TypeDocEdge {
  node: TypeDoc | null;
  next: TypeDoc | null;
  previous: TypeDoc | null;
}

export interface TypeDoc extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  component: string | null;
  name: string | null;
  comment: comment_3 | null;
  properties: Array<properties_3> | null;
  internal: internal_14 | null;
}

export interface comment_3 {
  shortText: string | null;
  tags: Array<tags_3> | null;
}

export interface tags_3 {
  tag: string | null;
  text: string | null;
}

export interface properties_3 {
  name: string | null;
  availableValues: Array<availableValues_2> | null;
  flags: flags_2 | null;
  comment: comment_4 | null;
  breakpointCompatible: boolean | null;
  type: string | null;
  sourceSrc: string | null;
}

export interface availableValues_2 {
  name: string | null;
  type: string | null;
  sourceSrc: string | null;
  values: Array<string> | null;
  properties: Array<properties_4> | null;
}

export interface properties_4 {
  name: string | null;
  value: string | null;
  isOptional: boolean | null;
  sourceSrc: string | null;
}

export interface flags_2 {
  isExported: boolean | null;
  isOptional: boolean | null;
}

export interface comment_4 {
  tags: Array<tags_4> | null;
  shortText: string | null;
  text: string | null;
}

export interface tags_4 {
  tag: string | null;
  text: string | null;
  param: string | null;
}

export interface internal_14 {
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export type typeDocDistinctEnum =
  | "component"
  | "name"
  | "comment___shortText"
  | "comment___tags"
  | "properties"
  | "id"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export type typeDocGroupEnum =
  | "component"
  | "name"
  | "comment___shortText"
  | "comment___tags"
  | "properties"
  | "id"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export interface typeDocGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<typeDocGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface typeDocGroupConnectionEdge {
  node: TypeDoc | null;
  next: TypeDoc | null;
  previous: TypeDoc | null;
}

export interface projectUsageReportFileConnectionSort {
  fields: Array<projectUsageReportFileConnectionSortByFieldsEnum>;
  order: projectUsageReportFileConnectionSortOrderValues | null;
}

export type projectUsageReportFileConnectionSortByFieldsEnum =
  | "id"
  | "data___project___name"
  | "data___project___repoHTTP"
  | "data___project___repoSSH"
  | "data___project___description"
  | "data___project___ownerType"
  | "data___coreUIVersion"
  | "data___commitHash"
  | "data___commitTimestamp"
  | "data___components"
  | "data___totalComponentReferences"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export type projectUsageReportFileConnectionSortOrderValues = "ASC" | "DESC";

export interface filterProjectUsageReportFile {
  id: projectUsageReportFileConnectionIdQueryString_2 | null;
  data: projectUsageReportFileConnectionDataInputObject_2 | null;
  internal: projectUsageReportFileConnectionInternalInputObject_2 | null;
}

export interface projectUsageReportFileConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataInputObject_2 {
  project: projectUsageReportFileConnectionDataProjectInputObject_2 | null;
  coreUIVersion: projectUsageReportFileConnectionDataCoreUiVersionQueryString_2 | null;
  commitHash: projectUsageReportFileConnectionDataCommitHashQueryString_2 | null;
  commitTimestamp: projectUsageReportFileConnectionDataCommitTimestampQueryString_2 | null;
  components: projectUsageReportFileConnectionDataComponentsQueryList_2 | null;
  totalComponentReferences: projectUsageReportFileConnectionDataTotalComponentReferencesQueryInteger_2 | null;
}

export interface projectUsageReportFileConnectionDataProjectInputObject_2 {
  name: projectUsageReportFileConnectionDataProjectNameQueryString_2 | null;
  repoHTTP: projectUsageReportFileConnectionDataProjectRepoHttpQueryString_2 | null;
  repoSSH: projectUsageReportFileConnectionDataProjectRepoSshQueryString_2 | null;
  description: projectUsageReportFileConnectionDataProjectDescriptionQueryString_2 | null;
  ownerType: projectUsageReportFileConnectionDataProjectOwnerTypeQueryString_2 | null;
}

export interface projectUsageReportFileConnectionDataProjectNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataProjectRepoHttpQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataProjectRepoSshQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataProjectDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataProjectOwnerTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataCoreUiVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataCommitHashQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataCommitTimestampQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataComponentsQueryList_2 {
  elemMatch: projectUsageReportFileConnectionDataComponentsInputObject_2 | null;
}

export interface projectUsageReportFileConnectionDataComponentsInputObject_2 {
  name: projectUsageReportFileConnectionDataComponentsNameQueryString_2 | null;
  totalComponentUsages: projectUsageReportFileConnectionDataComponentsTotalComponentUsagesQueryInteger_2 | null;
  filesUsingComponent: projectUsageReportFileConnectionDataComponentsFilesUsingComponentQueryInteger_2 | null;
  usages: projectUsageReportFileConnectionDataComponentsUsagesQueryList_2 | null;
}

export interface projectUsageReportFileConnectionDataComponentsNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataComponentsTotalComponentUsagesQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface projectUsageReportFileConnectionDataComponentsFilesUsingComponentQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface projectUsageReportFileConnectionDataComponentsUsagesQueryList_2 {
  elemMatch: projectUsageReportFileConnectionDataComponentsUsagesInputObject_2 | null;
}

export interface projectUsageReportFileConnectionDataComponentsUsagesInputObject_2 {
  name: projectUsageReportFileConnectionDataComponentsUsagesNameQueryString_2 | null;
  file: projectUsageReportFileConnectionDataComponentsUsagesFileQueryString_2 | null;
  line: projectUsageReportFileConnectionDataComponentsUsagesLineQueryInteger_2 | null;
  attributes: projectUsageReportFileConnectionDataComponentsUsagesAttributesQueryList_2 | null;
  githubUrl: projectUsageReportFileConnectionDataComponentsUsagesGithubUrlQueryString_2 | null;
}

export interface projectUsageReportFileConnectionDataComponentsUsagesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataComponentsUsagesFileQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataComponentsUsagesLineQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface projectUsageReportFileConnectionDataComponentsUsagesAttributesQueryList_2 {
  elemMatch: projectUsageReportFileConnectionDataComponentsUsagesAttributesInputObject_2 | null;
}

export interface projectUsageReportFileConnectionDataComponentsUsagesAttributesInputObject_2 {
  name: projectUsageReportFileConnectionDataComponentsUsagesAttributesNameQueryString_2 | null;
  value: projectUsageReportFileConnectionDataComponentsUsagesAttributesValueQueryString_2 | null;
}

export interface projectUsageReportFileConnectionDataComponentsUsagesAttributesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataComponentsUsagesAttributesValueQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataComponentsUsagesGithubUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionDataTotalComponentReferencesQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface projectUsageReportFileConnectionInternalInputObject_2 {
  type: projectUsageReportFileConnectionInternalTypeQueryString_2 | null;
  contentDigest: projectUsageReportFileConnectionInternalContentDigestQueryString_2 | null;
  owner: projectUsageReportFileConnectionInternalOwnerQueryString_2 | null;
}

export interface projectUsageReportFileConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileConnection {
  pageInfo: PageInfo;
  edges: Array<projectUsageReportFileEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<projectUsageReportFileGroupConnectionConnection> | null;
}

export interface DistinctprojectUsageReportFileConnectionArgs {
  field: projectUsageReportFileDistinctEnum | null;
}

export interface GroupprojectUsageReportFileConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: projectUsageReportFileGroupEnum | null;
}

export interface projectUsageReportFileEdge {
  node: projectUsageReportFile | null;
  next: projectUsageReportFile | null;
  previous: projectUsageReportFile | null;
}

export interface projectUsageReportFile extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  data: data_3 | null;
  internal: internal_15 | null;
}

export interface data_3 {
  project: project_2 | null;
  coreUIVersion: string | null;
  commitHash: string | null;
  commitTimestamp: string | null;
  components: Array<components_2> | null;
  totalComponentReferences: number | null;
}

export interface project_2 {
  name: string | null;
  repoHTTP: string | null;
  repoSSH: string | null;
  description: string | null;
  ownerType: string | null;
}

export interface components_2 {
  name: string | null;
  totalComponentUsages: number | null;
  filesUsingComponent: number | null;
  usages: Array<usages_2> | null;
}

export interface usages_2 {
  name: string | null;
  file: string | null;
  line: number | null;
  attributes: Array<attributes_2> | null;
  githubUrl: string | null;
}

export interface attributes_2 {
  name: string | null;
  value: string | null;
}

export interface internal_15 {
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export type projectUsageReportFileDistinctEnum =
  | "id"
  | "data___project___name"
  | "data___project___repoHTTP"
  | "data___project___repoSSH"
  | "data___project___description"
  | "data___project___ownerType"
  | "data___coreUIVersion"
  | "data___commitHash"
  | "data___commitTimestamp"
  | "data___components"
  | "data___totalComponentReferences"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export type projectUsageReportFileGroupEnum =
  | "id"
  | "data___project___name"
  | "data___project___repoHTTP"
  | "data___project___repoSSH"
  | "data___project___description"
  | "data___project___ownerType"
  | "data___coreUIVersion"
  | "data___commitHash"
  | "data___commitTimestamp"
  | "data___components"
  | "data___totalComponentReferences"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export interface projectUsageReportFileGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<projectUsageReportFileGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface projectUsageReportFileGroupConnectionEdge {
  node: projectUsageReportFile | null;
  next: projectUsageReportFile | null;
  previous: projectUsageReportFile | null;
}

export interface githubVersionReleaseConnectionSort {
  fields: Array<GithubVersionReleaseConnectionSortByFieldsEnum>;
  order: githubVersionReleaseConnectionSortOrderValues | null;
}

export type GithubVersionReleaseConnectionSortByFieldsEnum =
  | "data___url"
  | "data___assetsUrl"
  | "data___html"
  | "data___htmlUrl"
  | "data___id"
  | "data___nodeId"
  | "data___tagName"
  | "data___targetCommitish"
  | "data___name"
  | "data___draft"
  | "data___author___login"
  | "data___author___id"
  | "data___author___nodeId"
  | "data___author___avatar"
  | "data___author___avatarUrl"
  | "data___author___gravatarId"
  | "data___author___url"
  | "data___author___html"
  | "data___author___htmlUrl"
  | "data___author___followers"
  | "data___author___followersUrl"
  | "data___author___subscriptions"
  | "data___author___subscriptionsUrl"
  | "data___author___organizations"
  | "data___author___organizationsUrl"
  | "data___author___repos"
  | "data___author___reposUrl"
  | "data___author___receivedEvents"
  | "data___author___receivedEventsUrl"
  | "data___author___type"
  | "data___author___siteAdmin"
  | "data___author___ldapDn"
  | "data___prerelease"
  | "data___createdAt"
  | "data___publishedAt"
  | "data___tarball"
  | "data___tarballUrl"
  | "data___zipball"
  | "data___zipballUrl"
  | "data___body"
  | "id"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export type githubVersionReleaseConnectionSortOrderValues = "ASC" | "DESC";

export interface filterGithubVersionRelease {
  data: githubVersionReleaseConnectionDataInputObject_2 | null;
  id: githubVersionReleaseConnectionIdQueryString_2 | null;
  internal: githubVersionReleaseConnectionInternalInputObject_2 | null;
}

export interface githubVersionReleaseConnectionDataInputObject_2 {
  url: githubVersionReleaseConnectionDataUrlQueryString_2 | null;
  assetsUrl: githubVersionReleaseConnectionDataAssetsUrlQueryString_2 | null;
  htmlUrl: githubVersionReleaseConnectionDataHtmlUrlQueryString_2 | null;
  id: githubVersionReleaseConnectionDataIdQueryInteger_2 | null;
  nodeId: githubVersionReleaseConnectionDataNodeIdQueryString_2 | null;
  tagName: githubVersionReleaseConnectionDataTagNameQueryString_2 | null;
  targetCommitish: githubVersionReleaseConnectionDataTargetCommitishQueryString_2 | null;
  name: githubVersionReleaseConnectionDataNameQueryString_2 | null;
  draft: githubVersionReleaseConnectionDataDraftQueryBoolean_2 | null;
  author: githubVersionReleaseConnectionDataAuthorInputObject_2 | null;
  prerelease: githubVersionReleaseConnectionDataPrereleaseQueryBoolean_2 | null;
  createdAt: githubVersionReleaseConnectionDataCreatedAtQueryString_2 | null;
  publishedAt: githubVersionReleaseConnectionDataPublishedAtQueryString_2 | null;
  tarballUrl: githubVersionReleaseConnectionDataTarballUrlQueryString_2 | null;
  zipballUrl: githubVersionReleaseConnectionDataZipballUrlQueryString_2 | null;
  body: githubVersionReleaseConnectionDataBodyQueryString_2 | null;
}

export interface githubVersionReleaseConnectionDataUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAssetsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface githubVersionReleaseConnectionDataNodeIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataTagNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataTargetCommitishQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataDraftQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubVersionReleaseConnectionDataAuthorInputObject_2 {
  login: githubVersionReleaseConnectionDataAuthorLoginQueryString_2 | null;
  id: githubVersionReleaseConnectionDataAuthorIdQueryInteger_2 | null;
  nodeId: githubVersionReleaseConnectionDataAuthorNodeIdQueryString_2 | null;
  avatarUrl: githubVersionReleaseConnectionDataAuthorAvatarUrlQueryString_2 | null;
  gravatarId: githubVersionReleaseConnectionDataAuthorGravatarIdQueryString_2 | null;
  url: githubVersionReleaseConnectionDataAuthorUrlQueryString_2 | null;
  htmlUrl: githubVersionReleaseConnectionDataAuthorHtmlUrlQueryString_2 | null;
  followersUrl: githubVersionReleaseConnectionDataAuthorFollowersUrlQueryString_2 | null;
  subscriptionsUrl: githubVersionReleaseConnectionDataAuthorSubscriptionsUrlQueryString_2 | null;
  organizationsUrl: githubVersionReleaseConnectionDataAuthorOrganizationsUrlQueryString_2 | null;
  reposUrl: githubVersionReleaseConnectionDataAuthorReposUrlQueryString_2 | null;
  receivedEventsUrl: githubVersionReleaseConnectionDataAuthorReceivedEventsUrlQueryString_2 | null;
  type: githubVersionReleaseConnectionDataAuthorTypeQueryString_2 | null;
  siteAdmin: githubVersionReleaseConnectionDataAuthorSiteAdminQueryBoolean_2 | null;
  ldapDn: githubVersionReleaseConnectionDataAuthorLdapDnQueryString_2 | null;
}

export interface githubVersionReleaseConnectionDataAuthorLoginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface githubVersionReleaseConnectionDataAuthorNodeIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorAvatarUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorGravatarIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorFollowersUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorSubscriptionsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorOrganizationsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorReposUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorReceivedEventsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataAuthorSiteAdminQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubVersionReleaseConnectionDataAuthorLdapDnQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataPrereleaseQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubVersionReleaseConnectionDataCreatedAtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataPublishedAtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataTarballUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataZipballUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionDataBodyQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionInternalInputObject_2 {
  type: githubVersionReleaseConnectionInternalTypeQueryString_2 | null;
  contentDigest: githubVersionReleaseConnectionInternalContentDigestQueryString_2 | null;
  owner: githubVersionReleaseConnectionInternalOwnerQueryString_2 | null;
}

export interface githubVersionReleaseConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface GithubVersionReleaseConnection {
  pageInfo: PageInfo;
  edges: Array<GithubVersionReleaseEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<githubVersionReleaseGroupConnectionConnection> | null;
}

export interface DistinctGithubVersionReleaseConnectionArgs {
  field: githubVersionReleaseDistinctEnum | null;
}

export interface GroupGithubVersionReleaseConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: githubVersionReleaseGroupEnum | null;
}

export interface GithubVersionReleaseEdge {
  node: GithubVersionRelease | null;
  next: GithubVersionRelease | null;
  previous: GithubVersionRelease | null;
}

export interface GithubVersionRelease extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  data: data_4 | null;
  internal: internal_16 | null;
}

export interface data_4 {
  url: string | null;
  assetsUrl: string | null;
  htmlUrl: string | null;
  id: number | null;
  nodeId: string | null;
  tagName: string | null;
  targetCommitish: string | null;
  name: string | null;
  draft: boolean | null;
  author: author_4 | null;
  prerelease: boolean | null;
  createdAt: Date | null;
  publishedAt: Date | null;
  tarballUrl: string | null;
  zipballUrl: string | null;
  body: string | null;
}

export interface CreatedAtdata_4Args {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface PublishedAtdata_4Args {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface author_4 {
  login: string | null;
  id: number | null;
  nodeId: string | null;
  avatarUrl: string | null;
  gravatarId: string | null;
  url: string | null;
  htmlUrl: string | null;
  followersUrl: string | null;
  subscriptionsUrl: string | null;
  organizationsUrl: string | null;
  reposUrl: string | null;
  receivedEventsUrl: string | null;
  type: string | null;
  siteAdmin: boolean | null;
  ldapDn: string | null;
}

export type Date = any;

export interface internal_16 {
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export type githubVersionReleaseDistinctEnum =
  | "data___url"
  | "data___assetsUrl"
  | "data___html"
  | "data___htmlUrl"
  | "data___id"
  | "data___nodeId"
  | "data___tagName"
  | "data___targetCommitish"
  | "data___name"
  | "data___draft"
  | "data___author___login"
  | "data___author___id"
  | "data___author___nodeId"
  | "data___author___avatar"
  | "data___author___avatarUrl"
  | "data___author___gravatarId"
  | "data___author___url"
  | "data___author___html"
  | "data___author___htmlUrl"
  | "data___author___followers"
  | "data___author___followersUrl"
  | "data___author___subscriptions"
  | "data___author___subscriptionsUrl"
  | "data___author___organizations"
  | "data___author___organizationsUrl"
  | "data___author___repos"
  | "data___author___reposUrl"
  | "data___author___receivedEvents"
  | "data___author___receivedEventsUrl"
  | "data___author___type"
  | "data___author___siteAdmin"
  | "data___author___ldapDn"
  | "data___prerelease"
  | "data___createdAt"
  | "data___publishedAt"
  | "data___tarball"
  | "data___tarballUrl"
  | "data___zipball"
  | "data___zipballUrl"
  | "data___body"
  | "id"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export type githubVersionReleaseGroupEnum =
  | "data___url"
  | "data___assetsUrl"
  | "data___html"
  | "data___htmlUrl"
  | "data___id"
  | "data___nodeId"
  | "data___tagName"
  | "data___targetCommitish"
  | "data___name"
  | "data___draft"
  | "data___author___login"
  | "data___author___id"
  | "data___author___nodeId"
  | "data___author___avatar"
  | "data___author___avatarUrl"
  | "data___author___gravatarId"
  | "data___author___url"
  | "data___author___html"
  | "data___author___htmlUrl"
  | "data___author___followers"
  | "data___author___followersUrl"
  | "data___author___subscriptions"
  | "data___author___subscriptionsUrl"
  | "data___author___organizations"
  | "data___author___organizationsUrl"
  | "data___author___repos"
  | "data___author___reposUrl"
  | "data___author___receivedEvents"
  | "data___author___receivedEventsUrl"
  | "data___author___type"
  | "data___author___siteAdmin"
  | "data___author___ldapDn"
  | "data___prerelease"
  | "data___createdAt"
  | "data___publishedAt"
  | "data___tarball"
  | "data___tarballUrl"
  | "data___zipball"
  | "data___zipballUrl"
  | "data___body"
  | "id"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export interface githubVersionReleaseGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<githubVersionReleaseGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface githubVersionReleaseGroupConnectionEdge {
  node: GithubVersionRelease | null;
  next: GithubVersionRelease | null;
  previous: GithubVersionRelease | null;
}

export interface githubCommitsConnectionSort {
  fields: Array<GithubCommitsConnectionSortByFieldsEnum>;
  order: githubCommitsConnectionSortOrderValues | null;
}

export type GithubCommitsConnectionSortByFieldsEnum =
  | "component"
  | "items"
  | "id"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export type githubCommitsConnectionSortOrderValues = "ASC" | "DESC";

export interface filterGithubCommits {
  component: githubCommitsConnectionComponentQueryString_2 | null;
  items: githubCommitsConnectionItemsQueryList_2 | null;
  id: githubCommitsConnectionIdQueryString_2 | null;
  internal: githubCommitsConnectionInternalInputObject_2 | null;
}

export interface githubCommitsConnectionComponentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsQueryList_2 {
  elemMatch: githubCommitsConnectionItemsInputObject_2 | null;
}

export interface githubCommitsConnectionItemsInputObject_2 {
  sha: githubCommitsConnectionItemsShaQueryString_2 | null;
  nodeId: githubCommitsConnectionItemsNodeIdQueryString_2 | null;
  commit: githubCommitsConnectionItemsCommitInputObject_2 | null;
  url: githubCommitsConnectionItemsUrlQueryString_2 | null;
  htmlUrl: githubCommitsConnectionItemsHtmlUrlQueryString_2 | null;
  commentsUrl: githubCommitsConnectionItemsCommentsUrlQueryString_2 | null;
  author: githubCommitsConnectionItemsAuthorInputObject_2 | null;
  committer: githubCommitsConnectionItemsCommitterInputObject_2 | null;
  parents: githubCommitsConnectionItemsParentsQueryList_2 | null;
}

export interface githubCommitsConnectionItemsShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsNodeIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitInputObject_2 {
  author: githubCommitsConnectionItemsCommitAuthorInputObject_2 | null;
  committer: githubCommitsConnectionItemsCommitCommitterInputObject_2 | null;
  message: githubCommitsConnectionItemsCommitMessageQueryString_2 | null;
  tree: githubCommitsConnectionItemsCommitTreeInputObject_2 | null;
  url: githubCommitsConnectionItemsCommitUrlQueryString_2 | null;
  commentCount: githubCommitsConnectionItemsCommitCommentCountQueryInteger_2 | null;
  verification: githubCommitsConnectionItemsCommitVerificationInputObject_2 | null;
}

export interface githubCommitsConnectionItemsCommitAuthorInputObject_2 {
  name: githubCommitsConnectionItemsCommitAuthorNameQueryString_2 | null;
  email: githubCommitsConnectionItemsCommitAuthorEmailQueryString_2 | null;
  date: githubCommitsConnectionItemsCommitAuthorDateQueryString_2 | null;
}

export interface githubCommitsConnectionItemsCommitAuthorNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitAuthorEmailQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitAuthorDateQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitCommitterInputObject_2 {
  name: githubCommitsConnectionItemsCommitCommitterNameQueryString_2 | null;
  email: githubCommitsConnectionItemsCommitCommitterEmailQueryString_2 | null;
  date: githubCommitsConnectionItemsCommitCommitterDateQueryString_2 | null;
}

export interface githubCommitsConnectionItemsCommitCommitterNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitCommitterEmailQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitCommitterDateQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitMessageQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitTreeInputObject_2 {
  sha: githubCommitsConnectionItemsCommitTreeShaQueryString_2 | null;
  url: githubCommitsConnectionItemsCommitTreeUrlQueryString_2 | null;
}

export interface githubCommitsConnectionItemsCommitTreeShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitTreeUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitCommentCountQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface githubCommitsConnectionItemsCommitVerificationInputObject_2 {
  verified: githubCommitsConnectionItemsCommitVerificationVerifiedQueryBoolean_2 | null;
  reason: githubCommitsConnectionItemsCommitVerificationReasonQueryString_2 | null;
  signature: githubCommitsConnectionItemsCommitVerificationSignatureQueryString_2 | null;
  payload: githubCommitsConnectionItemsCommitVerificationPayloadQueryString_2 | null;
}

export interface githubCommitsConnectionItemsCommitVerificationVerifiedQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubCommitsConnectionItemsCommitVerificationReasonQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitVerificationSignatureQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitVerificationPayloadQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommentsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorInputObject_2 {
  login: githubCommitsConnectionItemsAuthorLoginQueryString_2 | null;
  id: githubCommitsConnectionItemsAuthorIdQueryInteger_2 | null;
  nodeId: githubCommitsConnectionItemsAuthorNodeIdQueryString_2 | null;
  avatarUrl: githubCommitsConnectionItemsAuthorAvatarUrlQueryString_2 | null;
  gravatarId: githubCommitsConnectionItemsAuthorGravatarIdQueryString_2 | null;
  url: githubCommitsConnectionItemsAuthorUrlQueryString_2 | null;
  htmlUrl: githubCommitsConnectionItemsAuthorHtmlUrlQueryString_2 | null;
  followersUrl: githubCommitsConnectionItemsAuthorFollowersUrlQueryString_2 | null;
  subscriptionsUrl: githubCommitsConnectionItemsAuthorSubscriptionsUrlQueryString_2 | null;
  organizationsUrl: githubCommitsConnectionItemsAuthorOrganizationsUrlQueryString_2 | null;
  reposUrl: githubCommitsConnectionItemsAuthorReposUrlQueryString_2 | null;
  receivedEventsUrl: githubCommitsConnectionItemsAuthorReceivedEventsUrlQueryString_2 | null;
  type: githubCommitsConnectionItemsAuthorTypeQueryString_2 | null;
  siteAdmin: githubCommitsConnectionItemsAuthorSiteAdminQueryBoolean_2 | null;
  ldapDn: githubCommitsConnectionItemsAuthorLdapDnQueryString_2 | null;
}

export interface githubCommitsConnectionItemsAuthorLoginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface githubCommitsConnectionItemsAuthorNodeIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorAvatarUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorGravatarIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorFollowersUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorSubscriptionsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorOrganizationsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorReposUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorReceivedEventsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsAuthorSiteAdminQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubCommitsConnectionItemsAuthorLdapDnQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterInputObject_2 {
  login: githubCommitsConnectionItemsCommitterLoginQueryString_2 | null;
  id: githubCommitsConnectionItemsCommitterIdQueryInteger_2 | null;
  nodeId: githubCommitsConnectionItemsCommitterNodeIdQueryString_2 | null;
  avatarUrl: githubCommitsConnectionItemsCommitterAvatarUrlQueryString_2 | null;
  gravatarId: githubCommitsConnectionItemsCommitterGravatarIdQueryString_2 | null;
  url: githubCommitsConnectionItemsCommitterUrlQueryString_2 | null;
  htmlUrl: githubCommitsConnectionItemsCommitterHtmlUrlQueryString_2 | null;
  followersUrl: githubCommitsConnectionItemsCommitterFollowersUrlQueryString_2 | null;
  subscriptionsUrl: githubCommitsConnectionItemsCommitterSubscriptionsUrlQueryString_2 | null;
  organizationsUrl: githubCommitsConnectionItemsCommitterOrganizationsUrlQueryString_2 | null;
  reposUrl: githubCommitsConnectionItemsCommitterReposUrlQueryString_2 | null;
  receivedEventsUrl: githubCommitsConnectionItemsCommitterReceivedEventsUrlQueryString_2 | null;
  type: githubCommitsConnectionItemsCommitterTypeQueryString_2 | null;
  siteAdmin: githubCommitsConnectionItemsCommitterSiteAdminQueryBoolean_2 | null;
  ldapDn: githubCommitsConnectionItemsCommitterLdapDnQueryString_2 | null;
}

export interface githubCommitsConnectionItemsCommitterLoginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface githubCommitsConnectionItemsCommitterNodeIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterAvatarUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterGravatarIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterFollowersUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterSubscriptionsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterOrganizationsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterReposUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterReceivedEventsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsCommitterSiteAdminQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubCommitsConnectionItemsCommitterLdapDnQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsParentsQueryList_2 {
  elemMatch: githubCommitsConnectionItemsParentsInputObject_2 | null;
}

export interface githubCommitsConnectionItemsParentsInputObject_2 {
  sha: githubCommitsConnectionItemsParentsShaQueryString_2 | null;
  url: githubCommitsConnectionItemsParentsUrlQueryString_2 | null;
  htmlUrl: githubCommitsConnectionItemsParentsHtmlUrlQueryString_2 | null;
}

export interface githubCommitsConnectionItemsParentsShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsParentsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionItemsParentsHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionInternalInputObject_2 {
  type: githubCommitsConnectionInternalTypeQueryString_2 | null;
  contentDigest: githubCommitsConnectionInternalContentDigestQueryString_2 | null;
  owner: githubCommitsConnectionInternalOwnerQueryString_2 | null;
}

export interface githubCommitsConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface GithubCommitsConnection {
  pageInfo: PageInfo;
  edges: Array<GithubCommitsEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<githubCommitsGroupConnectionConnection> | null;
}

export interface DistinctGithubCommitsConnectionArgs {
  field: githubCommitsDistinctEnum | null;
}

export interface GroupGithubCommitsConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: githubCommitsGroupEnum | null;
}

export interface GithubCommitsEdge {
  node: GithubCommits | null;
  next: GithubCommits | null;
  previous: GithubCommits | null;
}

export interface GithubCommits extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  component: string | null;
  items: Array<items_2> | null;
  internal: internal_17 | null;
}

export interface items_2 {
  sha: string | null;
  nodeId: string | null;
  commit: commit_2 | null;
  url: string | null;
  htmlUrl: string | null;
  commentsUrl: string | null;
  author: author_6 | null;
  committer: committer_4 | null;
  parents: Array<parents_2> | null;
}

export interface commit_2 {
  author: author_5 | null;
  committer: committer_3 | null;
  message: string | null;
  tree: tree_2 | null;
  url: string | null;
  commentCount: number | null;
  verification: verification_2 | null;
}

export interface author_5 {
  name: string | null;
  email: string | null;
  date: Date | null;
}

export interface Dateauthor_5Args {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface committer_3 {
  name: string | null;
  email: string | null;
  date: Date | null;
}

export interface Datecommitter_3Args {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface tree_2 {
  sha: string | null;
  url: string | null;
}

export interface verification_2 {
  verified: boolean | null;
  reason: string | null;
  signature: string | null;
  payload: string | null;
}

export interface author_6 {
  login: string | null;
  id: number | null;
  nodeId: string | null;
  avatarUrl: string | null;
  gravatarId: string | null;
  url: string | null;
  htmlUrl: string | null;
  followersUrl: string | null;
  subscriptionsUrl: string | null;
  organizationsUrl: string | null;
  reposUrl: string | null;
  receivedEventsUrl: string | null;
  type: string | null;
  siteAdmin: boolean | null;
  ldapDn: string | null;
}

export interface committer_4 {
  login: string | null;
  id: number | null;
  nodeId: string | null;
  avatarUrl: string | null;
  gravatarId: string | null;
  url: string | null;
  htmlUrl: string | null;
  followersUrl: string | null;
  subscriptionsUrl: string | null;
  organizationsUrl: string | null;
  reposUrl: string | null;
  receivedEventsUrl: string | null;
  type: string | null;
  siteAdmin: boolean | null;
  ldapDn: string | null;
}

export interface parents_2 {
  sha: string | null;
  url: string | null;
  htmlUrl: string | null;
}

export interface internal_17 {
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export type githubCommitsDistinctEnum =
  | "component"
  | "items"
  | "id"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export type githubCommitsGroupEnum =
  | "component"
  | "items"
  | "id"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export interface githubCommitsGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<githubCommitsGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface githubCommitsGroupConnectionEdge {
  node: GithubCommits | null;
  next: GithubCommits | null;
  previous: GithubCommits | null;
}

export interface consumerProjectVersionsFileConnectionSort {
  fields: Array<consumerProjectVersionsFileConnectionSortByFieldsEnum>;
  order: consumerProjectVersionsFileConnectionSortOrderValues | null;
}

export type consumerProjectVersionsFileConnectionSortByFieldsEnum =
  | "id"
  | "currentProjectVersion"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export type consumerProjectVersionsFileConnectionSortOrderValues =
  | "ASC"
  | "DESC";

export interface filterConsumerProjectVersionsFile {
  id: consumerProjectVersionsFileConnectionIdQueryString_2 | null;
  currentProjectVersion: consumerProjectVersionsFileConnectionCurrentProjectVersionQueryString_2 | null;
  internal: consumerProjectVersionsFileConnectionInternalInputObject_2 | null;
}

export interface consumerProjectVersionsFileConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface consumerProjectVersionsFileConnectionCurrentProjectVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface consumerProjectVersionsFileConnectionInternalInputObject_2 {
  type: consumerProjectVersionsFileConnectionInternalTypeQueryString_2 | null;
  contentDigest: consumerProjectVersionsFileConnectionInternalContentDigestQueryString_2 | null;
  owner: consumerProjectVersionsFileConnectionInternalOwnerQueryString_2 | null;
}

export interface consumerProjectVersionsFileConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface consumerProjectVersionsFileConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface consumerProjectVersionsFileConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface consumerProjectVersionsFileConnection {
  pageInfo: PageInfo;
  edges: Array<consumerProjectVersionsFileEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<consumerProjectVersionsFileGroupConnectionConnection> | null;
}

export interface DistinctconsumerProjectVersionsFileConnectionArgs {
  field: consumerProjectVersionsFileDistinctEnum | null;
}

export interface GroupconsumerProjectVersionsFileConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: consumerProjectVersionsFileGroupEnum | null;
}

export interface consumerProjectVersionsFileEdge {
  node: consumerProjectVersionsFile | null;
  next: consumerProjectVersionsFile | null;
  previous: consumerProjectVersionsFile | null;
}

export interface consumerProjectVersionsFile extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  currentProjectVersion: string | null;
  internal: internal_18 | null;
}

export interface internal_18 {
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export type consumerProjectVersionsFileDistinctEnum =
  | "id"
  | "currentProjectVersion"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export type consumerProjectVersionsFileGroupEnum =
  | "id"
  | "currentProjectVersion"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner";

export interface consumerProjectVersionsFileGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<consumerProjectVersionsFileGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface consumerProjectVersionsFileGroupConnectionEdge {
  node: consumerProjectVersionsFile | null;
  next: consumerProjectVersionsFile | null;
  previous: consumerProjectVersionsFile | null;
}

export interface directoryConnectionSort {
  fields: Array<DirectoryConnectionSortByFieldsEnum>;
  order: directoryConnectionSortOrderValues | null;
}

export type DirectoryConnectionSortByFieldsEnum =
  | "id"
  | "parent"
  | "internal___contentDigest"
  | "internal___type"
  | "internal___description"
  | "internal___owner"
  | "sourceInstanceName"
  | "absolutePath"
  | "relativePath"
  | "extension"
  | "size"
  | "prettySize"
  | "modifiedTime"
  | "accessTime"
  | "changeTime"
  | "birthTime"
  | "root"
  | "dir"
  | "base"
  | "ext"
  | "name"
  | "relativeDirectory"
  | "dev"
  | "mode"
  | "nlink"
  | "uid"
  | "gid"
  | "rdev"
  | "blksize"
  | "ino"
  | "blocks"
  | "atimeMs"
  | "mtimeMs"
  | "ctimeMs"
  | "birthtimeMs"
  | "atime"
  | "mtime"
  | "ctime"
  | "birthtime";

export type directoryConnectionSortOrderValues = "ASC" | "DESC";

export interface filterDirectory {
  id: directoryConnectionIdQueryString_2 | null;
  internal: directoryConnectionInternalInputObject_2 | null;
  sourceInstanceName: directoryConnectionSourceInstanceNameQueryString_2 | null;
  absolutePath: directoryConnectionAbsolutePathQueryString_2 | null;
  relativePath: directoryConnectionRelativePathQueryString_2 | null;
  extension: directoryConnectionExtensionQueryString_2 | null;
  size: directoryConnectionSizeQueryInteger_2 | null;
  prettySize: directoryConnectionPrettySizeQueryString_2 | null;
  modifiedTime: directoryConnectionModifiedTimeQueryString_2 | null;
  accessTime: directoryConnectionAccessTimeQueryString_2 | null;
  changeTime: directoryConnectionChangeTimeQueryString_2 | null;
  birthTime: directoryConnectionBirthTimeQueryString_2 | null;
  root: directoryConnectionRootQueryString_2 | null;
  dir: directoryConnectionDirQueryString_2 | null;
  base: directoryConnectionBaseQueryString_2 | null;
  ext: directoryConnectionExtQueryString_2 | null;
  name: directoryConnectionNameQueryString_2 | null;
  relativeDirectory: directoryConnectionRelativeDirectoryQueryString_2 | null;
  dev: directoryConnectionDevQueryInteger_2 | null;
  mode: directoryConnectionModeQueryInteger_2 | null;
  nlink: directoryConnectionNlinkQueryInteger_2 | null;
  uid: directoryConnectionUidQueryInteger_2 | null;
  gid: directoryConnectionGidQueryInteger_2 | null;
  rdev: directoryConnectionRdevQueryInteger_2 | null;
  blksize: directoryConnectionBlksizeQueryInteger_2 | null;
  ino: directoryConnectionInoQueryInteger_2 | null;
  blocks: directoryConnectionBlocksQueryInteger_2 | null;
  atimeMs: directoryConnectionAtimeMsQueryFloat_2 | null;
  mtimeMs: directoryConnectionMtimeMsQueryFloat_2 | null;
  ctimeMs: directoryConnectionCtimeMsQueryFloat_2 | null;
  birthtimeMs: directoryConnectionBirthtimeMsQueryFloat_2 | null;
  atime: directoryConnectionAtimeQueryString_2 | null;
  mtime: directoryConnectionMtimeQueryString_2 | null;
  ctime: directoryConnectionCtimeQueryString_2 | null;
  birthtime: directoryConnectionBirthtimeQueryString_2 | null;
}

export interface directoryConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionInternalInputObject_2 {
  contentDigest: directoryConnectionInternalContentDigestQueryString_2 | null;
  type: directoryConnectionInternalTypeQueryString_2 | null;
  description: directoryConnectionInternalDescriptionQueryString_2 | null;
  owner: directoryConnectionInternalOwnerQueryString_2 | null;
}

export interface directoryConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionInternalDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionSourceInstanceNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionRelativePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionExtensionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionSizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionPrettySizeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionModifiedTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionAccessTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionChangeTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionBirthTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionRootQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionDirQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionBaseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionExtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionRelativeDirectoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionDevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionModeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionNlinkQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionUidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionGidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionRdevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionBlksizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionInoQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionBlocksQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionAtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionMtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionCtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionBirthtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryConnectionAtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionMtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionCtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryConnectionBirthtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface DirectoryConnection {
  pageInfo: PageInfo;
  edges: Array<DirectoryEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<directoryGroupConnectionConnection> | null;
}

export interface DistinctDirectoryConnectionArgs {
  field: directoryDistinctEnum | null;
}

export interface GroupDirectoryConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: directoryGroupEnum | null;
}

export interface DirectoryEdge {
  node: Directory | null;
  next: Directory | null;
  previous: Directory | null;
}

export interface Directory extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  internal: internal_19 | null;
  sourceInstanceName: string | null;
  absolutePath: string | null;
  relativePath: string | null;
  extension: string | null;
  size: number | null;
  prettySize: string | null;
  modifiedTime: Date | null;
  accessTime: Date | null;
  changeTime: Date | null;
  birthTime: Date | null;
  root: string | null;
  dir: string | null;
  base: string | null;
  ext: string | null;
  name: string | null;
  relativeDirectory: string | null;
  dev: number | null;
  mode: number | null;
  nlink: number | null;
  uid: number | null;
  gid: number | null;
  rdev: number | null;
  blksize: number | null;
  ino: number | null;
  blocks: number | null;
  atimeMs: number | null;
  mtimeMs: number | null;
  ctimeMs: number | null;
  birthtimeMs: number | null;
  atime: Date | null;
  mtime: Date | null;
  ctime: Date | null;
  birthtime: Date | null;
}

export interface ModifiedTimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface AccessTimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface ChangeTimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface BirthTimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface AtimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface MtimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface CtimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface BirthtimeDirectoryArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface internal_19 {
  contentDigest: string | null;
  type: string | null;
  description: string | null;
  owner: string | null;
}

export type directoryDistinctEnum =
  | "id"
  | "parent"
  | "internal___contentDigest"
  | "internal___type"
  | "internal___description"
  | "internal___owner"
  | "sourceInstanceName"
  | "absolutePath"
  | "relativePath"
  | "extension"
  | "size"
  | "prettySize"
  | "modifiedTime"
  | "accessTime"
  | "changeTime"
  | "birthTime"
  | "root"
  | "dir"
  | "base"
  | "ext"
  | "name"
  | "relativeDirectory"
  | "dev"
  | "mode"
  | "nlink"
  | "uid"
  | "gid"
  | "rdev"
  | "blksize"
  | "ino"
  | "blocks"
  | "atimeMs"
  | "mtimeMs"
  | "ctimeMs"
  | "birthtimeMs"
  | "atime"
  | "mtime"
  | "ctime"
  | "birthtime";

export type directoryGroupEnum =
  | "id"
  | "parent"
  | "internal___contentDigest"
  | "internal___type"
  | "internal___description"
  | "internal___owner"
  | "sourceInstanceName"
  | "absolutePath"
  | "relativePath"
  | "extension"
  | "size"
  | "prettySize"
  | "modifiedTime"
  | "accessTime"
  | "changeTime"
  | "birthTime"
  | "root"
  | "dir"
  | "base"
  | "ext"
  | "name"
  | "relativeDirectory"
  | "dev"
  | "mode"
  | "nlink"
  | "uid"
  | "gid"
  | "rdev"
  | "blksize"
  | "ino"
  | "blocks"
  | "atimeMs"
  | "mtimeMs"
  | "ctimeMs"
  | "birthtimeMs"
  | "atime"
  | "mtime"
  | "ctime"
  | "birthtime";

export interface directoryGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<directoryGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface directoryGroupConnectionEdge {
  node: Directory | null;
  next: Directory | null;
  previous: Directory | null;
}

export interface fileConnectionSort {
  fields: Array<FileConnectionSortByFieldsEnum>;
  order: fileConnectionSortOrderValues | null;
}

export type FileConnectionSortByFieldsEnum =
  | "id"
  | "children"
  | "parent"
  | "internal___contentDigest"
  | "internal___mediaType"
  | "internal___type"
  | "internal___description"
  | "internal___owner"
  | "internal___fieldOwners___segments"
  | "internal___fieldOwners___title"
  | "internal___fieldOwners___slug"
  | "internal___fieldOwners___path"
  | "internal___fieldOwners___tab"
  | "internal___fieldOwners___tabPath"
  | "sourceInstanceName"
  | "absolutePath"
  | "relativePath"
  | "extension"
  | "size"
  | "prettySize"
  | "modifiedTime"
  | "accessTime"
  | "changeTime"
  | "birthTime"
  | "root"
  | "dir"
  | "base"
  | "ext"
  | "name"
  | "relativeDirectory"
  | "dev"
  | "mode"
  | "nlink"
  | "uid"
  | "gid"
  | "rdev"
  | "blksize"
  | "ino"
  | "blocks"
  | "atimeMs"
  | "mtimeMs"
  | "ctimeMs"
  | "birthtimeMs"
  | "atime"
  | "mtime"
  | "ctime"
  | "birthtime"
  | "fields___segments"
  | "fields___title"
  | "fields___slug"
  | "fields___path"
  | "fields___tab___slug"
  | "fields___tab___title"
  | "fields___tabPath"
  | "publicURL";

export type fileConnectionSortOrderValues = "ASC" | "DESC";

export interface filterFile {
  id: fileConnectionIdQueryString_2 | null;
  internal: fileConnectionInternalInputObject_2 | null;
  sourceInstanceName: fileConnectionSourceInstanceNameQueryString_2 | null;
  absolutePath: fileConnectionAbsolutePathQueryString_2 | null;
  relativePath: fileConnectionRelativePathQueryString_2 | null;
  extension: fileConnectionExtensionQueryString_2 | null;
  size: fileConnectionSizeQueryInteger_2 | null;
  prettySize: fileConnectionPrettySizeQueryString_2 | null;
  modifiedTime: fileConnectionModifiedTimeQueryString_2 | null;
  accessTime: fileConnectionAccessTimeQueryString_2 | null;
  changeTime: fileConnectionChangeTimeQueryString_2 | null;
  birthTime: fileConnectionBirthTimeQueryString_2 | null;
  root: fileConnectionRootQueryString_2 | null;
  dir: fileConnectionDirQueryString_2 | null;
  base: fileConnectionBaseQueryString_2 | null;
  ext: fileConnectionExtQueryString_2 | null;
  name: fileConnectionNameQueryString_2 | null;
  relativeDirectory: fileConnectionRelativeDirectoryQueryString_2 | null;
  dev: fileConnectionDevQueryInteger_2 | null;
  mode: fileConnectionModeQueryInteger_2 | null;
  nlink: fileConnectionNlinkQueryInteger_2 | null;
  uid: fileConnectionUidQueryInteger_2 | null;
  gid: fileConnectionGidQueryInteger_2 | null;
  rdev: fileConnectionRdevQueryInteger_2 | null;
  blksize: fileConnectionBlksizeQueryInteger_2 | null;
  ino: fileConnectionInoQueryInteger_2 | null;
  blocks: fileConnectionBlocksQueryInteger_2 | null;
  atimeMs: fileConnectionAtimeMsQueryFloat_2 | null;
  mtimeMs: fileConnectionMtimeMsQueryFloat_2 | null;
  ctimeMs: fileConnectionCtimeMsQueryFloat_2 | null;
  birthtimeMs: fileConnectionBirthtimeMsQueryFloat_2 | null;
  atime: fileConnectionAtimeQueryString_2 | null;
  mtime: fileConnectionMtimeQueryString_2 | null;
  ctime: fileConnectionCtimeQueryString_2 | null;
  birthtime: fileConnectionBirthtimeQueryString_2 | null;
  fields: fileConnectionFieldsInputObject_2 | null;
  publicURL: publicUrlQueryString_4 | null;
}

export interface fileConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalInputObject_2 {
  contentDigest: fileConnectionInternalContentDigestQueryString_2 | null;
  mediaType: fileConnectionInternalMediaTypeQueryString_2 | null;
  type: fileConnectionInternalTypeQueryString_2 | null;
  description: fileConnectionInternalDescriptionQueryString_2 | null;
  owner: fileConnectionInternalOwnerQueryString_2 | null;
  fieldOwners: fileConnectionInternalFieldOwnersInputObject_2 | null;
}

export interface fileConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalMediaTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalFieldOwnersInputObject_2 {
  segments: fileConnectionInternalFieldOwnersSegmentsQueryString_2 | null;
  title: fileConnectionInternalFieldOwnersTitleQueryString_2 | null;
  slug: fileConnectionInternalFieldOwnersSlugQueryString_2 | null;
  path: fileConnectionInternalFieldOwnersPathQueryString_2 | null;
  tab: fileConnectionInternalFieldOwnersTabQueryString_2 | null;
  tabPath: fileConnectionInternalFieldOwnersTabPathQueryString_2 | null;
}

export interface fileConnectionInternalFieldOwnersSegmentsQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalFieldOwnersTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalFieldOwnersSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalFieldOwnersPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalFieldOwnersTabQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionInternalFieldOwnersTabPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionSourceInstanceNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionRelativePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionExtensionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionSizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionPrettySizeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionModifiedTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionAccessTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionChangeTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionBirthTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionRootQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionDirQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionBaseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionExtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionRelativeDirectoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionDevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionModeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionNlinkQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionUidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionGidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionRdevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionBlksizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionInoQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionBlocksQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionAtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionMtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionCtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionBirthtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileConnectionAtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionMtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionCtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionBirthtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionFieldsInputObject_2 {
  segments: fileConnectionFieldsSegmentsQueryList_2 | null;
  title: fileConnectionFieldsTitleQueryString_2 | null;
  slug: fileConnectionFieldsSlugQueryString_2 | null;
  path: fileConnectionFieldsPathQueryString_2 | null;
  tab: fileConnectionFieldsTabInputObject_2 | null;
  tabPath: fileConnectionFieldsTabPathQueryString_2 | null;
}

export interface fileConnectionFieldsSegmentsQueryList_2 {
  elemMatch: fileConnectionFieldsSegmentsInputObject_2 | null;
}

export interface fileConnectionFieldsSegmentsInputObject_2 {
  slug: fileConnectionFieldsSegmentsSlugQueryString_2 | null;
  title: fileConnectionFieldsSegmentsTitleQueryString_2 | null;
}

export interface fileConnectionFieldsSegmentsSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionFieldsSegmentsTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionFieldsTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionFieldsSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionFieldsPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionFieldsTabInputObject_2 {
  slug: fileConnectionFieldsTabSlugQueryString_2 | null;
  title: fileConnectionFieldsTabTitleQueryString_2 | null;
}

export interface fileConnectionFieldsTabSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionFieldsTabTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileConnectionFieldsTabPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface publicUrlQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface FileConnection {
  pageInfo: PageInfo;
  edges: Array<FileEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<fileGroupConnectionConnection> | null;
}

export interface DistinctFileConnectionArgs {
  field: fileDistinctEnum | null;
}

export interface GroupFileConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: fileGroupEnum | null;
}

export interface FileEdge {
  node: File | null;
  next: File | null;
  previous: File | null;
}

export interface File extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  childMarkdownRemark: MarkdownRemark | null;
  internal: internal_20 | null;
  sourceInstanceName: string | null;
  absolutePath: string | null;
  relativePath: string | null;
  extension: string | null;
  size: number | null;
  prettySize: string | null;
  modifiedTime: Date | null;
  accessTime: Date | null;
  changeTime: Date | null;
  birthTime: Date | null;
  root: string | null;
  dir: string | null;
  base: string | null;
  ext: string | null;
  name: string | null;
  relativeDirectory: string | null;
  dev: number | null;
  mode: number | null;
  nlink: number | null;
  uid: number | null;
  gid: number | null;
  rdev: number | null;
  blksize: number | null;
  ino: number | null;
  blocks: number | null;
  atimeMs: number | null;
  mtimeMs: number | null;
  ctimeMs: number | null;
  birthtimeMs: number | null;
  atime: Date | null;
  mtime: Date | null;
  ctime: Date | null;
  birthtime: Date | null;
  fields: fields_2 | null;
  publicURL: string | null;
}

export interface ModifiedTimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface AccessTimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface ChangeTimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface BirthTimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface AtimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface MtimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface CtimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface BirthtimeFileArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface MarkdownRemark extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  internal: internal_21 | null;
  frontmatter: frontmatter_2 | null;
  rawMarkdownBody: string | null;
  fileAbsolutePath: string | null;
  html: string | null;
  htmlAst: JSON | null;
  excerpt: string | null;
  headings: Array<MarkdownHeading> | null;
  timeToRead: number | null;
  tableOfContents: string | null;
  wordCount: wordCount | null;
}

export interface ExcerptMarkdownRemarkArgs {
  pruneLength: number | null;
}

export interface HeadingsMarkdownRemarkArgs {
  depth: HeadingLevels | null;
}

export interface internal_21 {
  content: string | null;
  type: string | null;
  contentDigest: string | null;
  owner: string | null;
}

export interface frontmatter_2 {
  title: string | null;
  redirect: string | null;
  _PARENT: string | null;
  parent: string | null;
  description: string | null;
  component: component_2 | null;
}

export interface component_2 {
  id: string | null;
  disablePlayground: boolean | null;
}

export type JSON = any;

export type HeadingLevels = "h1" | "h2" | "h3" | "h4" | "h5" | "h6";

export interface MarkdownHeading {
  value: string | null;
  depth: number | null;
}

export interface wordCount {
  paragraphs: number | null;
  sentences: number | null;
  words: number | null;
}

export interface internal_20 {
  contentDigest: string | null;
  mediaType: string | null;
  type: string | null;
  description: string | null;
  owner: string | null;
  fieldOwners: fieldOwners_2 | null;
}

export interface fieldOwners_2 {
  segments: string | null;
  title: string | null;
  slug: string | null;
  path: string | null;
  tab: string | null;
  tabPath: string | null;
}

export interface fields_2 {
  segments: Array<segments_2> | null;
  title: string | null;
  slug: string | null;
  path: string | null;
  tab: tab_2 | null;
  tabPath: string | null;
}

export interface segments_2 {
  slug: string | null;
  title: string | null;
}

export interface tab_2 {
  slug: string | null;
  title: string | null;
}

export type fileDistinctEnum =
  | "id"
  | "children"
  | "parent"
  | "internal___contentDigest"
  | "internal___mediaType"
  | "internal___type"
  | "internal___description"
  | "internal___owner"
  | "internal___fieldOwners___segments"
  | "internal___fieldOwners___title"
  | "internal___fieldOwners___slug"
  | "internal___fieldOwners___path"
  | "internal___fieldOwners___tab"
  | "internal___fieldOwners___tabPath"
  | "sourceInstanceName"
  | "absolutePath"
  | "relativePath"
  | "extension"
  | "size"
  | "prettySize"
  | "modifiedTime"
  | "accessTime"
  | "changeTime"
  | "birthTime"
  | "root"
  | "dir"
  | "base"
  | "ext"
  | "name"
  | "relativeDirectory"
  | "dev"
  | "mode"
  | "nlink"
  | "uid"
  | "gid"
  | "rdev"
  | "blksize"
  | "ino"
  | "blocks"
  | "atimeMs"
  | "mtimeMs"
  | "ctimeMs"
  | "birthtimeMs"
  | "atime"
  | "mtime"
  | "ctime"
  | "birthtime"
  | "fields___segments"
  | "fields___title"
  | "fields___slug"
  | "fields___path"
  | "fields___tab___slug"
  | "fields___tab___title"
  | "fields___tabPath";

export type fileGroupEnum =
  | "id"
  | "children"
  | "parent"
  | "internal___contentDigest"
  | "internal___mediaType"
  | "internal___type"
  | "internal___description"
  | "internal___owner"
  | "internal___fieldOwners___segments"
  | "internal___fieldOwners___title"
  | "internal___fieldOwners___slug"
  | "internal___fieldOwners___path"
  | "internal___fieldOwners___tab"
  | "internal___fieldOwners___tabPath"
  | "sourceInstanceName"
  | "absolutePath"
  | "relativePath"
  | "extension"
  | "size"
  | "prettySize"
  | "modifiedTime"
  | "accessTime"
  | "changeTime"
  | "birthTime"
  | "root"
  | "dir"
  | "base"
  | "ext"
  | "name"
  | "relativeDirectory"
  | "dev"
  | "mode"
  | "nlink"
  | "uid"
  | "gid"
  | "rdev"
  | "blksize"
  | "ino"
  | "blocks"
  | "atimeMs"
  | "mtimeMs"
  | "ctimeMs"
  | "birthtimeMs"
  | "atime"
  | "mtime"
  | "ctime"
  | "birthtime"
  | "fields___segments"
  | "fields___title"
  | "fields___slug"
  | "fields___path"
  | "fields___tab___slug"
  | "fields___tab___title"
  | "fields___tabPath";

export interface fileGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<fileGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface fileGroupConnectionEdge {
  node: File | null;
  next: File | null;
  previous: File | null;
}

export interface markdownRemarkConnectionSort {
  fields: Array<MarkdownRemarkConnectionSortByFieldsEnum>;
  order: markdownRemarkConnectionSortOrderValues | null;
}

export type MarkdownRemarkConnectionSortByFieldsEnum =
  | "id"
  | "parent"
  | "internal___content"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner"
  | "frontmatter___title"
  | "frontmatter___redirect"
  | "frontmatter____PARENT"
  | "frontmatter___parent"
  | "frontmatter___description"
  | "frontmatter___component___id"
  | "frontmatter___component___disablePlayground"
  | "excerpt"
  | "rawMarkdownBody"
  | "fileAbsolutePath"
  | "html"
  | "headings"
  | "timeToRead"
  | "tableOfContents"
  | "wordCount___paragraphs"
  | "wordCount___sentences"
  | "wordCount___words";

export type markdownRemarkConnectionSortOrderValues = "ASC" | "DESC";

export interface filterMarkdownRemark {
  id: markdownRemarkConnectionIdQueryString_2 | null;
  internal: markdownRemarkConnectionInternalInputObject_2 | null;
  frontmatter: markdownRemarkConnectionFrontmatterInputObject_2 | null;
  excerpt: excerptQueryString_4 | null;
  rawMarkdownBody: markdownRemarkConnectionRawMarkdownBodyQueryString_2 | null;
  fileAbsolutePath: markdownRemarkConnectionFileAbsolutePathQueryString_2 | null;
  html: htmlQueryString_4 | null;
  headings: headingsQueryList_4 | null;
  timeToRead: timeToReadQueryInt_4 | null;
  tableOfContents: tableOfContentsQueryString_4 | null;
  wordCount: wordCountTypeName_4 | null;
}

export interface markdownRemarkConnectionIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionInternalInputObject_2 {
  content: markdownRemarkConnectionInternalContentQueryString_2 | null;
  type: markdownRemarkConnectionInternalTypeQueryString_2 | null;
  contentDigest: markdownRemarkConnectionInternalContentDigestQueryString_2 | null;
  owner: markdownRemarkConnectionInternalOwnerQueryString_2 | null;
}

export interface markdownRemarkConnectionInternalContentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionFrontmatterInputObject_2 {
  title: markdownRemarkConnectionFrontmatterTitleQueryString_2 | null;
  redirect: markdownRemarkConnectionFrontmatterRedirectQueryString_2 | null;
  _PARENT: markdownRemarkConnectionFrontmatterParentQueryString_3 | null;
  parent: markdownRemarkConnectionFrontmatterParentQueryString_4 | null;
  description: markdownRemarkConnectionFrontmatterDescriptionQueryString_2 | null;
  component: markdownRemarkConnectionFrontmatterComponentInputObject_2 | null;
}

export interface markdownRemarkConnectionFrontmatterTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionFrontmatterRedirectQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionFrontmatterParentQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionFrontmatterParentQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionFrontmatterDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionFrontmatterComponentInputObject_2 {
  id: markdownRemarkConnectionFrontmatterComponentIdQueryString_2 | null;
  disablePlayground: markdownRemarkConnectionFrontmatterComponentDisablePlaygroundQueryBoolean_2 | null;
}

export interface markdownRemarkConnectionFrontmatterComponentIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionFrontmatterComponentDisablePlaygroundQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface excerptQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionRawMarkdownBodyQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkConnectionFileAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface htmlQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface headingsQueryList_4 {
  elemMatch: headingsListElemTypeName_4 | null;
}

export interface headingsListElemTypeName_4 {
  value: headingsListElemValueQueryString_4 | null;
  depth: headingsListElemDepthQueryInt_4 | null;
}

export interface headingsListElemValueQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface headingsListElemDepthQueryInt_4 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface timeToReadQueryInt_4 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface tableOfContentsQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface wordCountTypeName_4 {
  paragraphs: wordCountParagraphsQueryInt_4 | null;
  sentences: wordCountSentencesQueryInt_4 | null;
  words: wordCountWordsQueryInt_4 | null;
}

export interface wordCountParagraphsQueryInt_4 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface wordCountSentencesQueryInt_4 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface wordCountWordsQueryInt_4 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface MarkdownRemarkConnection {
  pageInfo: PageInfo;
  edges: Array<MarkdownRemarkEdge> | null;
  totalCount: number | null;
  distinct: Array<string> | null;
  group: Array<markdownRemarkGroupConnectionConnection> | null;
}

export interface DistinctMarkdownRemarkConnectionArgs {
  field: markdownRemarkDistinctEnum | null;
}

export interface GroupMarkdownRemarkConnectionArgs {
  skip: number | null;
  limit: number | null;
  field: markdownRemarkGroupEnum | null;
}

export interface MarkdownRemarkEdge {
  node: MarkdownRemark | null;
  next: MarkdownRemark | null;
  previous: MarkdownRemark | null;
}

export type markdownRemarkDistinctEnum =
  | "id"
  | "parent"
  | "internal___content"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner"
  | "frontmatter___title"
  | "frontmatter___redirect"
  | "frontmatter____PARENT"
  | "frontmatter___parent"
  | "frontmatter___description"
  | "frontmatter___component___id"
  | "frontmatter___component___disablePlayground"
  | "excerpt"
  | "rawMarkdownBody"
  | "fileAbsolutePath";

export type markdownRemarkGroupEnum =
  | "id"
  | "parent"
  | "internal___content"
  | "internal___type"
  | "internal___contentDigest"
  | "internal___owner"
  | "frontmatter___title"
  | "frontmatter___redirect"
  | "frontmatter____PARENT"
  | "frontmatter___parent"
  | "frontmatter___description"
  | "frontmatter___component___id"
  | "frontmatter___component___disablePlayground"
  | "excerpt"
  | "rawMarkdownBody"
  | "fileAbsolutePath";

export interface markdownRemarkGroupConnectionConnection {
  pageInfo: PageInfo;
  edges: Array<markdownRemarkGroupConnectionEdge> | null;
  field: string | null;
  fieldValue: string | null;
  totalCount: number | null;
}

export interface markdownRemarkGroupConnectionEdge {
  node: MarkdownRemark | null;
  next: MarkdownRemark | null;
  previous: MarkdownRemark | null;
}

export interface sitePageJsonNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageInternalComponentNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageComponentQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageComponentChunkNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageContextInputObject {
  pagePath: sitePageContextPagePathQueryString | null;
  componentId: sitePageContextComponentIdQueryString | null;
  tab: sitePageContextTabQueryString | null;
  title: sitePageContextTitleQueryString | null;
  showSidebarMenu: sitePageContextShowSidebarMenuQueryBoolean | null;
}

export interface sitePageContextPagePathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageContextComponentIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageContextTabQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageContextTitleQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageContextShowSidebarMenuQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePagePluginCreatorInputObject {
  resolve: sitePagePluginCreatorResolveQueryString | null;
  id: sitePagePluginCreatorIdQueryString | null;
  name: sitePagePluginCreatorNameQueryString | null;
  version: sitePagePluginCreatorVersionQueryString | null;
  pluginOptions: sitePagePluginCreatorPluginOptionsInputObject | null;
  nodeAPIs: sitePagePluginCreatorNodeApIsQueryList | null;
  browserAPIs: sitePagePluginCreatorBrowserApIsQueryList | null;
  ssrAPIs: sitePagePluginCreatorSsrApIsQueryList | null;
  pluginFilepath: sitePagePluginCreatorPluginFilepathQueryString | null;
  packageJson: sitePagePluginCreatorPackageJsonInputObject | null;
  parent: sitePagePluginCreatorParentQueryString | null;
  internal: sitePagePluginCreatorInternalInputObject | null;
}

export interface sitePagePluginCreatorResolveQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsInputObject {
  plugins: sitePagePluginCreatorPluginOptionsPluginsQueryList | null;
  trackingId: sitePagePluginCreatorPluginOptionsTrackingIdQueryString | null;
  head: sitePagePluginCreatorPluginOptionsHeadQueryBoolean | null;
  anonymize: sitePagePluginCreatorPluginOptionsAnonymizeQueryBoolean | null;
  respectDNT: sitePagePluginCreatorPluginOptionsRespectDntQueryBoolean | null;
  baseDir: sitePagePluginCreatorPluginOptionsBaseDirQueryString | null;
  user: sitePagePluginCreatorPluginOptionsUserQueryString | null;
  repository: sitePagePluginCreatorPluginOptionsRepositoryQueryString | null;
  token: sitePagePluginCreatorPluginOptionsTokenQueryString | null;
  rootURL: sitePagePluginCreatorPluginOptionsRootUrlQueryString | null;
  name: sitePagePluginCreatorPluginOptionsNameQueryString | null;
  path: sitePagePluginCreatorPluginOptionsPathQueryString | null;
  maxWidth: sitePagePluginCreatorPluginOptionsMaxWidthQueryInteger | null;
  backgroundColor: sitePagePluginCreatorPluginOptionsBackgroundColorQueryString | null;
  includePaths: sitePagePluginCreatorPluginOptionsIncludePathsQueryList | null;
  sourceMaps: sitePagePluginCreatorPluginOptionsSourceMapsQueryBoolean | null;
  pathCheck: sitePagePluginCreatorPluginOptionsPathCheckQueryBoolean | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsQueryList {
  elemMatch: sitePagePluginCreatorPluginOptionsPluginsInputObject | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsInputObject {
  resolve: sitePagePluginCreatorPluginOptionsPluginsResolveQueryString | null;
  id: sitePagePluginCreatorPluginOptionsPluginsIdQueryString | null;
  name: sitePagePluginCreatorPluginOptionsPluginsNameQueryString | null;
  version: sitePagePluginCreatorPluginOptionsPluginsVersionQueryString | null;
  pluginOptions: sitePagePluginCreatorPluginOptionsPluginsPluginOptionsInputObject | null;
  browserAPIs: sitePagePluginCreatorPluginOptionsPluginsBrowserApIsQueryList | null;
  ssrAPIs: sitePagePluginCreatorPluginOptionsPluginsSsrApIsQueryList | null;
  pluginFilepath: sitePagePluginCreatorPluginOptionsPluginsPluginFilepathQueryString | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsResolveQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsPluginOptionsInputObject {
  maxWidth: sitePagePluginCreatorPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger | null;
  backgroundColor: sitePagePluginCreatorPluginOptionsPluginsPluginOptionsBackgroundColorQueryString | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsPluginOptionsBackgroundColorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsBrowserApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsSsrApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsPluginsPluginFilepathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsTrackingIdQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsHeadQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePagePluginCreatorPluginOptionsAnonymizeQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePagePluginCreatorPluginOptionsRespectDntQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePagePluginCreatorPluginOptionsBaseDirQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsUserQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsRepositoryQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsTokenQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsRootUrlQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsPathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsMaxWidthQueryInteger {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface sitePagePluginCreatorPluginOptionsBackgroundColorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsIncludePathsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginOptionsSourceMapsQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePagePluginCreatorPluginOptionsPathCheckQueryBoolean {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePagePluginCreatorNodeApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorBrowserApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorSsrApIsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPluginFilepathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonInputObject {
  name: sitePagePluginCreatorPackageJsonNameQueryString | null;
  description: sitePagePluginCreatorPackageJsonDescriptionQueryString | null;
  version: sitePagePluginCreatorPackageJsonVersionQueryString | null;
  main: sitePagePluginCreatorPackageJsonMainQueryString | null;
  author: sitePagePluginCreatorPackageJsonAuthorQueryString | null;
  license: sitePagePluginCreatorPackageJsonLicenseQueryString | null;
  dependencies: sitePagePluginCreatorPackageJsonDependenciesQueryList | null;
  devDependencies: sitePagePluginCreatorPackageJsonDevDependenciesQueryList | null;
  peerDependencies: sitePagePluginCreatorPackageJsonPeerDependenciesQueryList | null;
  keywords: sitePagePluginCreatorPackageJsonKeywordsQueryList | null;
}

export interface sitePagePluginCreatorPackageJsonNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonDescriptionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonMainQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonAuthorQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonLicenseQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonDependenciesQueryList {
  elemMatch: sitePagePluginCreatorPackageJsonDependenciesInputObject | null;
}

export interface sitePagePluginCreatorPackageJsonDependenciesInputObject {
  name: sitePagePluginCreatorPackageJsonDependenciesNameQueryString | null;
  version: sitePagePluginCreatorPackageJsonDependenciesVersionQueryString | null;
}

export interface sitePagePluginCreatorPackageJsonDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonDevDependenciesQueryList {
  elemMatch: sitePagePluginCreatorPackageJsonDevDependenciesInputObject | null;
}

export interface sitePagePluginCreatorPackageJsonDevDependenciesInputObject {
  name: sitePagePluginCreatorPackageJsonDevDependenciesNameQueryString | null;
  version: sitePagePluginCreatorPackageJsonDevDependenciesVersionQueryString | null;
}

export interface sitePagePluginCreatorPackageJsonDevDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonDevDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonPeerDependenciesQueryList {
  elemMatch: sitePagePluginCreatorPackageJsonPeerDependenciesInputObject | null;
}

export interface sitePagePluginCreatorPackageJsonPeerDependenciesInputObject {
  name: sitePagePluginCreatorPackageJsonPeerDependenciesNameQueryString | null;
  version: sitePagePluginCreatorPackageJsonPeerDependenciesVersionQueryString | null;
}

export interface sitePagePluginCreatorPackageJsonPeerDependenciesNameQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonPeerDependenciesVersionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorPackageJsonKeywordsQueryList {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorParentQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorInternalInputObject {
  contentDigest: sitePagePluginCreatorInternalContentDigestQueryString | null;
  type: sitePagePluginCreatorInternalTypeQueryString | null;
  owner: sitePagePluginCreatorInternalOwnerQueryString | null;
}

export interface sitePagePluginCreatorInternalContentDigestQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorInternalTypeQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorInternalOwnerQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePagePluginCreatorIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageComponentPathQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageInternalInputObject_2 {
  type: sitePageInternalTypeQueryString_2 | null;
  contentDigest: sitePageInternalContentDigestQueryString_2 | null;
  description: sitePageInternalDescriptionQueryString | null;
  owner: sitePageInternalOwnerQueryString_2 | null;
}

export interface sitePageInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageInternalDescriptionQueryString {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePageInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginResolveQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsInputObject_2 {
  plugins: sitePluginPluginOptionsPluginsQueryList_2 | null;
  trackingId: sitePluginPluginOptionsTrackingIdQueryString_2 | null;
  head: sitePluginPluginOptionsHeadQueryBoolean_2 | null;
  anonymize: sitePluginPluginOptionsAnonymizeQueryBoolean_2 | null;
  respectDNT: sitePluginPluginOptionsRespectDntQueryBoolean_2 | null;
  baseDir: sitePluginPluginOptionsBaseDirQueryString_2 | null;
  user: sitePluginPluginOptionsUserQueryString_2 | null;
  repository: sitePluginPluginOptionsRepositoryQueryString_2 | null;
  token: sitePluginPluginOptionsTokenQueryString_2 | null;
  rootURL: sitePluginPluginOptionsRootUrlQueryString_2 | null;
  name: sitePluginPluginOptionsNameQueryString_2 | null;
  path: sitePluginPluginOptionsPathQueryString_2 | null;
  maxWidth: sitePluginPluginOptionsMaxWidthQueryInteger_2 | null;
  backgroundColor: sitePluginPluginOptionsBackgroundColorQueryString_2 | null;
  includePaths: sitePluginPluginOptionsIncludePathsQueryList_2 | null;
  sourceMaps: sitePluginPluginOptionsSourceMapsQueryBoolean_2 | null;
  pathCheck: sitePluginPluginOptionsPathCheckQueryBoolean_2 | null;
}

export interface sitePluginPluginOptionsPluginsQueryList_2 {
  elemMatch: sitePluginPluginOptionsPluginsInputObject_2 | null;
}

export interface sitePluginPluginOptionsPluginsInputObject_2 {
  resolve: sitePluginPluginOptionsPluginsResolveQueryString_2 | null;
  id: sitePluginPluginOptionsPluginsIdQueryString_2 | null;
  name: sitePluginPluginOptionsPluginsNameQueryString_2 | null;
  version: sitePluginPluginOptionsPluginsVersionQueryString_2 | null;
  pluginOptions: sitePluginPluginOptionsPluginsPluginOptionsInputObject_2 | null;
  browserAPIs: sitePluginPluginOptionsPluginsBrowserApIsQueryList_2 | null;
  ssrAPIs: sitePluginPluginOptionsPluginsSsrApIsQueryList_2 | null;
  pluginFilepath: sitePluginPluginOptionsPluginsPluginFilepathQueryString_2 | null;
}

export interface sitePluginPluginOptionsPluginsResolveQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsPluginsIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsPluginsNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsPluginsVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsPluginsPluginOptionsInputObject_2 {
  maxWidth: sitePluginPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger_2 | null;
  backgroundColor: sitePluginPluginOptionsPluginsPluginOptionsBackgroundColorQueryString_2 | null;
}

export interface sitePluginPluginOptionsPluginsPluginOptionsMaxWidthQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface sitePluginPluginOptionsPluginsPluginOptionsBackgroundColorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsPluginsBrowserApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsPluginsSsrApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsPluginsPluginFilepathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsTrackingIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsHeadQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePluginPluginOptionsAnonymizeQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePluginPluginOptionsRespectDntQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePluginPluginOptionsBaseDirQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsUserQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsRepositoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsTokenQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsRootUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsMaxWidthQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface sitePluginPluginOptionsBackgroundColorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsIncludePathsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginOptionsSourceMapsQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePluginPluginOptionsPathCheckQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface sitePluginNodeApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginBrowserApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginSsrApIsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPluginFilepathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonInputObject_2 {
  name: sitePluginPackageJsonNameQueryString_2 | null;
  description: sitePluginPackageJsonDescriptionQueryString_2 | null;
  version: sitePluginPackageJsonVersionQueryString_2 | null;
  main: sitePluginPackageJsonMainQueryString_2 | null;
  author: sitePluginPackageJsonAuthorQueryString_2 | null;
  license: sitePluginPackageJsonLicenseQueryString_2 | null;
  dependencies: sitePluginPackageJsonDependenciesQueryList_2 | null;
  devDependencies: sitePluginPackageJsonDevDependenciesQueryList_2 | null;
  peerDependencies: sitePluginPackageJsonPeerDependenciesQueryList_2 | null;
  keywords: sitePluginPackageJsonKeywordsQueryList_2 | null;
}

export interface sitePluginPackageJsonNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonMainQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonAuthorQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonLicenseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonDependenciesQueryList_2 {
  elemMatch: sitePluginPackageJsonDependenciesInputObject_2 | null;
}

export interface sitePluginPackageJsonDependenciesInputObject_2 {
  name: sitePluginPackageJsonDependenciesNameQueryString_2 | null;
  version: sitePluginPackageJsonDependenciesVersionQueryString_2 | null;
}

export interface sitePluginPackageJsonDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonDevDependenciesQueryList_2 {
  elemMatch: sitePluginPackageJsonDevDependenciesInputObject_2 | null;
}

export interface sitePluginPackageJsonDevDependenciesInputObject_2 {
  name: sitePluginPackageJsonDevDependenciesNameQueryString_2 | null;
  version: sitePluginPackageJsonDevDependenciesVersionQueryString_2 | null;
}

export interface sitePluginPackageJsonDevDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonDevDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonPeerDependenciesQueryList_2 {
  elemMatch: sitePluginPackageJsonPeerDependenciesInputObject_2 | null;
}

export interface sitePluginPackageJsonPeerDependenciesInputObject_2 {
  name: sitePluginPackageJsonPeerDependenciesNameQueryString_2 | null;
  version: sitePluginPackageJsonPeerDependenciesVersionQueryString_2 | null;
}

export interface sitePluginPackageJsonPeerDependenciesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonPeerDependenciesVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginPackageJsonKeywordsQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginInternalInputObject_2 {
  contentDigest: sitePluginInternalContentDigestQueryString_2 | null;
  type: sitePluginInternalTypeQueryString_2 | null;
  owner: sitePluginInternalOwnerQueryString_2 | null;
}

export interface sitePluginInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePluginInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface siteSiteMetadataInputObject_2 {
  title: siteSiteMetadataTitleQueryString_2 | null;
}

export interface siteSiteMetadataTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePortQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface siteHostQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface sitePolyfillQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface siteBuildTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface siteIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface siteInternalInputObject_2 {
  contentDigest: siteInternalContentDigestQueryString_2 | null;
  type: siteInternalTypeQueryString_2 | null;
  owner: siteInternalOwnerQueryString_2 | null;
}

export interface siteInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface siteInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface siteInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface Site extends Node {
  id: string;
  parent: Node | null;
  children: Array<Node> | null;
  siteMetadata: siteMetadata_2 | null;
  port: Date | null;
  host: string | null;
  polyfill: boolean | null;
  buildTime: Date | null;
  internal: internal_22 | null;
}

export interface PortSiteArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface BuildTimeSiteArgs {
  formatString: string | null;
  fromNow: boolean | null;
  difference: string | null;
  locale: string | null;
}

export interface siteMetadata_2 {
  title: string | null;
}

export interface internal_22 {
  contentDigest: string | null;
  type: string | null;
  owner: string | null;
}

export interface typeDocComponentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocCommentInputObject_2 {
  shortText: typeDocCommentShortTextQueryString_2 | null;
  tags: typeDocCommentTagsQueryList_2 | null;
}

export interface typeDocCommentShortTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocCommentTagsQueryList_2 {
  elemMatch: typeDocCommentTagsInputObject_2 | null;
}

export interface typeDocCommentTagsInputObject_2 {
  tag: typeDocCommentTagsTagQueryString_2 | null;
  text: typeDocCommentTagsTextQueryString_2 | null;
}

export interface typeDocCommentTagsTagQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocCommentTagsTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesQueryList_2 {
  elemMatch: typeDocPropertiesInputObject_2 | null;
}

export interface typeDocPropertiesInputObject_2 {
  name: typeDocPropertiesNameQueryString_2 | null;
  availableValues: typeDocPropertiesAvailableValuesQueryList_2 | null;
  flags: typeDocPropertiesFlagsInputObject_2 | null;
  comment: typeDocPropertiesCommentInputObject_2 | null;
  breakpointCompatible: typeDocPropertiesBreakpointCompatibleQueryBoolean_2 | null;
  type: typeDocPropertiesTypeQueryString_2 | null;
  sourceSrc: typeDocPropertiesSourceSrcQueryString_2 | null;
}

export interface typeDocPropertiesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesAvailableValuesQueryList_2 {
  elemMatch: typeDocPropertiesAvailableValuesInputObject_2 | null;
}

export interface typeDocPropertiesAvailableValuesInputObject_2 {
  name: typeDocPropertiesAvailableValuesNameQueryString_2 | null;
  sourceSrc: typeDocPropertiesAvailableValuesSourceSrcQueryString_2 | null;
  values: typeDocPropertiesAvailableValuesValuesQueryList_2 | null;
  properties: typeDocPropertiesAvailableValuesPropertiesQueryList_2 | null;
}

export interface typeDocPropertiesAvailableValuesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesAvailableValuesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesAvailableValuesValuesQueryList_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesAvailableValuesPropertiesQueryList_2 {
  elemMatch: typeDocPropertiesAvailableValuesPropertiesInputObject_2 | null;
}

export interface typeDocPropertiesAvailableValuesPropertiesInputObject_2 {
  name: typeDocPropertiesAvailableValuesPropertiesNameQueryString_2 | null;
  value: typeDocPropertiesAvailableValuesPropertiesValueQueryString_2 | null;
  isOptional: typeDocPropertiesAvailableValuesPropertiesIsOptionalQueryBoolean_2 | null;
  sourceSrc: typeDocPropertiesAvailableValuesPropertiesSourceSrcQueryString_2 | null;
}

export interface typeDocPropertiesAvailableValuesPropertiesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesAvailableValuesPropertiesValueQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesAvailableValuesPropertiesIsOptionalQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface typeDocPropertiesAvailableValuesPropertiesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesFlagsInputObject_2 {
  isExported: typeDocPropertiesFlagsIsExportedQueryBoolean_2 | null;
  isOptional: typeDocPropertiesFlagsIsOptionalQueryBoolean_2 | null;
}

export interface typeDocPropertiesFlagsIsExportedQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface typeDocPropertiesFlagsIsOptionalQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface typeDocPropertiesCommentInputObject_2 {
  tags: typeDocPropertiesCommentTagsQueryList_2 | null;
  shortText: typeDocPropertiesCommentShortTextQueryString_2 | null;
  text: typeDocPropertiesCommentTextQueryString_2 | null;
}

export interface typeDocPropertiesCommentTagsQueryList_2 {
  elemMatch: typeDocPropertiesCommentTagsInputObject_2 | null;
}

export interface typeDocPropertiesCommentTagsInputObject_2 {
  tag: typeDocPropertiesCommentTagsTagQueryString_2 | null;
  text: typeDocPropertiesCommentTagsTextQueryString_2 | null;
  param: typeDocPropertiesCommentTagsParamQueryString_2 | null;
}

export interface typeDocPropertiesCommentTagsTagQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesCommentTagsTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesCommentTagsParamQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesCommentShortTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesCommentTextQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesBreakpointCompatibleQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface typeDocPropertiesTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocPropertiesSourceSrcQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocInternalInputObject_2 {
  type: typeDocInternalTypeQueryString_2 | null;
  contentDigest: typeDocInternalContentDigestQueryString_2 | null;
  owner: typeDocInternalOwnerQueryString_2 | null;
}

export interface typeDocInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface typeDocInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataInputObject_2 {
  project: projectUsageReportFileDataProjectInputObject_2 | null;
  coreUIVersion: projectUsageReportFileDataCoreUiVersionQueryString_2 | null;
  commitHash: projectUsageReportFileDataCommitHashQueryString_2 | null;
  commitTimestamp: projectUsageReportFileDataCommitTimestampQueryString_2 | null;
  components: projectUsageReportFileDataComponentsQueryList_2 | null;
  totalComponentReferences: projectUsageReportFileDataTotalComponentReferencesQueryInteger_2 | null;
}

export interface projectUsageReportFileDataProjectInputObject_2 {
  name: projectUsageReportFileDataProjectNameQueryString_2 | null;
  repoHTTP: projectUsageReportFileDataProjectRepoHttpQueryString_2 | null;
  repoSSH: projectUsageReportFileDataProjectRepoSshQueryString_2 | null;
  description: projectUsageReportFileDataProjectDescriptionQueryString_2 | null;
  ownerType: projectUsageReportFileDataProjectOwnerTypeQueryString_2 | null;
}

export interface projectUsageReportFileDataProjectNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataProjectRepoHttpQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataProjectRepoSshQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataProjectDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataProjectOwnerTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataCoreUiVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataCommitHashQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataCommitTimestampQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataComponentsQueryList_2 {
  elemMatch: projectUsageReportFileDataComponentsInputObject_2 | null;
}

export interface projectUsageReportFileDataComponentsInputObject_2 {
  name: projectUsageReportFileDataComponentsNameQueryString_2 | null;
  totalComponentUsages: projectUsageReportFileDataComponentsTotalComponentUsagesQueryInteger_2 | null;
  filesUsingComponent: projectUsageReportFileDataComponentsFilesUsingComponentQueryInteger_2 | null;
  usages: projectUsageReportFileDataComponentsUsagesQueryList_2 | null;
}

export interface projectUsageReportFileDataComponentsNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataComponentsTotalComponentUsagesQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface projectUsageReportFileDataComponentsFilesUsingComponentQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface projectUsageReportFileDataComponentsUsagesQueryList_2 {
  elemMatch: projectUsageReportFileDataComponentsUsagesInputObject_2 | null;
}

export interface projectUsageReportFileDataComponentsUsagesInputObject_2 {
  name: projectUsageReportFileDataComponentsUsagesNameQueryString_2 | null;
  file: projectUsageReportFileDataComponentsUsagesFileQueryString_2 | null;
  line: projectUsageReportFileDataComponentsUsagesLineQueryInteger_2 | null;
  attributes: projectUsageReportFileDataComponentsUsagesAttributesQueryList_2 | null;
  githubUrl: projectUsageReportFileDataComponentsUsagesGithubUrlQueryString_2 | null;
}

export interface projectUsageReportFileDataComponentsUsagesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataComponentsUsagesFileQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataComponentsUsagesLineQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface projectUsageReportFileDataComponentsUsagesAttributesQueryList_2 {
  elemMatch: projectUsageReportFileDataComponentsUsagesAttributesInputObject_2 | null;
}

export interface projectUsageReportFileDataComponentsUsagesAttributesInputObject_2 {
  name: projectUsageReportFileDataComponentsUsagesAttributesNameQueryString_2 | null;
  value: projectUsageReportFileDataComponentsUsagesAttributesValueQueryString_2 | null;
}

export interface projectUsageReportFileDataComponentsUsagesAttributesNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataComponentsUsagesAttributesValueQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataComponentsUsagesGithubUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileDataTotalComponentReferencesQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface projectUsageReportFileInternalInputObject_2 {
  type: projectUsageReportFileInternalTypeQueryString_2 | null;
  contentDigest: projectUsageReportFileInternalContentDigestQueryString_2 | null;
  owner: projectUsageReportFileInternalOwnerQueryString_2 | null;
}

export interface projectUsageReportFileInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface projectUsageReportFileInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataInputObject_2 {
  url: githubVersionReleaseDataUrlQueryString_2 | null;
  assetsUrl: githubVersionReleaseDataAssetsUrlQueryString_2 | null;
  htmlUrl: githubVersionReleaseDataHtmlUrlQueryString_2 | null;
  id: githubVersionReleaseDataIdQueryInteger_2 | null;
  nodeId: githubVersionReleaseDataNodeIdQueryString_2 | null;
  tagName: githubVersionReleaseDataTagNameQueryString_2 | null;
  targetCommitish: githubVersionReleaseDataTargetCommitishQueryString_2 | null;
  name: githubVersionReleaseDataNameQueryString_2 | null;
  draft: githubVersionReleaseDataDraftQueryBoolean_2 | null;
  author: githubVersionReleaseDataAuthorInputObject_2 | null;
  prerelease: githubVersionReleaseDataPrereleaseQueryBoolean_2 | null;
  createdAt: githubVersionReleaseDataCreatedAtQueryString_2 | null;
  publishedAt: githubVersionReleaseDataPublishedAtQueryString_2 | null;
  tarballUrl: githubVersionReleaseDataTarballUrlQueryString_2 | null;
  zipballUrl: githubVersionReleaseDataZipballUrlQueryString_2 | null;
  body: githubVersionReleaseDataBodyQueryString_2 | null;
}

export interface githubVersionReleaseDataUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAssetsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface githubVersionReleaseDataNodeIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataTagNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataTargetCommitishQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataDraftQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubVersionReleaseDataAuthorInputObject_2 {
  login: githubVersionReleaseDataAuthorLoginQueryString_2 | null;
  id: githubVersionReleaseDataAuthorIdQueryInteger_2 | null;
  nodeId: githubVersionReleaseDataAuthorNodeIdQueryString_2 | null;
  avatarUrl: githubVersionReleaseDataAuthorAvatarUrlQueryString_2 | null;
  gravatarId: githubVersionReleaseDataAuthorGravatarIdQueryString_2 | null;
  url: githubVersionReleaseDataAuthorUrlQueryString_2 | null;
  htmlUrl: githubVersionReleaseDataAuthorHtmlUrlQueryString_2 | null;
  followersUrl: githubVersionReleaseDataAuthorFollowersUrlQueryString_2 | null;
  subscriptionsUrl: githubVersionReleaseDataAuthorSubscriptionsUrlQueryString_2 | null;
  organizationsUrl: githubVersionReleaseDataAuthorOrganizationsUrlQueryString_2 | null;
  reposUrl: githubVersionReleaseDataAuthorReposUrlQueryString_2 | null;
  receivedEventsUrl: githubVersionReleaseDataAuthorReceivedEventsUrlQueryString_2 | null;
  type: githubVersionReleaseDataAuthorTypeQueryString_2 | null;
  siteAdmin: githubVersionReleaseDataAuthorSiteAdminQueryBoolean_2 | null;
  ldapDn: githubVersionReleaseDataAuthorLdapDnQueryString_2 | null;
}

export interface githubVersionReleaseDataAuthorLoginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface githubVersionReleaseDataAuthorNodeIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorAvatarUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorGravatarIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorFollowersUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorSubscriptionsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorOrganizationsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorReposUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorReceivedEventsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataAuthorSiteAdminQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubVersionReleaseDataAuthorLdapDnQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataPrereleaseQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubVersionReleaseDataCreatedAtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataPublishedAtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataTarballUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataZipballUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseDataBodyQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseInternalInputObject_2 {
  type: githubVersionReleaseInternalTypeQueryString_2 | null;
  contentDigest: githubVersionReleaseInternalContentDigestQueryString_2 | null;
  owner: githubVersionReleaseInternalOwnerQueryString_2 | null;
}

export interface githubVersionReleaseInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubVersionReleaseInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsComponentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsQueryList_2 {
  elemMatch: githubCommitsItemsInputObject_2 | null;
}

export interface githubCommitsItemsInputObject_2 {
  sha: githubCommitsItemsShaQueryString_2 | null;
  nodeId: githubCommitsItemsNodeIdQueryString_2 | null;
  commit: githubCommitsItemsCommitInputObject_2 | null;
  url: githubCommitsItemsUrlQueryString_2 | null;
  htmlUrl: githubCommitsItemsHtmlUrlQueryString_2 | null;
  commentsUrl: githubCommitsItemsCommentsUrlQueryString_2 | null;
  author: githubCommitsItemsAuthorInputObject_2 | null;
  committer: githubCommitsItemsCommitterInputObject_2 | null;
  parents: githubCommitsItemsParentsQueryList_2 | null;
}

export interface githubCommitsItemsShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsNodeIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitInputObject_2 {
  author: githubCommitsItemsCommitAuthorInputObject_2 | null;
  committer: githubCommitsItemsCommitCommitterInputObject_2 | null;
  message: githubCommitsItemsCommitMessageQueryString_2 | null;
  tree: githubCommitsItemsCommitTreeInputObject_2 | null;
  url: githubCommitsItemsCommitUrlQueryString_2 | null;
  commentCount: githubCommitsItemsCommitCommentCountQueryInteger_2 | null;
  verification: githubCommitsItemsCommitVerificationInputObject_2 | null;
}

export interface githubCommitsItemsCommitAuthorInputObject_2 {
  name: githubCommitsItemsCommitAuthorNameQueryString_2 | null;
  email: githubCommitsItemsCommitAuthorEmailQueryString_2 | null;
  date: githubCommitsItemsCommitAuthorDateQueryString_2 | null;
}

export interface githubCommitsItemsCommitAuthorNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitAuthorEmailQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitAuthorDateQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitCommitterInputObject_2 {
  name: githubCommitsItemsCommitCommitterNameQueryString_2 | null;
  email: githubCommitsItemsCommitCommitterEmailQueryString_2 | null;
  date: githubCommitsItemsCommitCommitterDateQueryString_2 | null;
}

export interface githubCommitsItemsCommitCommitterNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitCommitterEmailQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitCommitterDateQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitMessageQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitTreeInputObject_2 {
  sha: githubCommitsItemsCommitTreeShaQueryString_2 | null;
  url: githubCommitsItemsCommitTreeUrlQueryString_2 | null;
}

export interface githubCommitsItemsCommitTreeShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitTreeUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitCommentCountQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface githubCommitsItemsCommitVerificationInputObject_2 {
  verified: githubCommitsItemsCommitVerificationVerifiedQueryBoolean_2 | null;
  reason: githubCommitsItemsCommitVerificationReasonQueryString_2 | null;
  signature: githubCommitsItemsCommitVerificationSignatureQueryString_2 | null;
  payload: githubCommitsItemsCommitVerificationPayloadQueryString_2 | null;
}

export interface githubCommitsItemsCommitVerificationVerifiedQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubCommitsItemsCommitVerificationReasonQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitVerificationSignatureQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitVerificationPayloadQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommentsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorInputObject_2 {
  login: githubCommitsItemsAuthorLoginQueryString_2 | null;
  id: githubCommitsItemsAuthorIdQueryInteger_2 | null;
  nodeId: githubCommitsItemsAuthorNodeIdQueryString_2 | null;
  avatarUrl: githubCommitsItemsAuthorAvatarUrlQueryString_2 | null;
  gravatarId: githubCommitsItemsAuthorGravatarIdQueryString_2 | null;
  url: githubCommitsItemsAuthorUrlQueryString_2 | null;
  htmlUrl: githubCommitsItemsAuthorHtmlUrlQueryString_2 | null;
  followersUrl: githubCommitsItemsAuthorFollowersUrlQueryString_2 | null;
  subscriptionsUrl: githubCommitsItemsAuthorSubscriptionsUrlQueryString_2 | null;
  organizationsUrl: githubCommitsItemsAuthorOrganizationsUrlQueryString_2 | null;
  reposUrl: githubCommitsItemsAuthorReposUrlQueryString_2 | null;
  receivedEventsUrl: githubCommitsItemsAuthorReceivedEventsUrlQueryString_2 | null;
  type: githubCommitsItemsAuthorTypeQueryString_2 | null;
  siteAdmin: githubCommitsItemsAuthorSiteAdminQueryBoolean_2 | null;
  ldapDn: githubCommitsItemsAuthorLdapDnQueryString_2 | null;
}

export interface githubCommitsItemsAuthorLoginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface githubCommitsItemsAuthorNodeIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorAvatarUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorGravatarIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorFollowersUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorSubscriptionsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorOrganizationsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorReposUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorReceivedEventsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsAuthorSiteAdminQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubCommitsItemsAuthorLdapDnQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterInputObject_2 {
  login: githubCommitsItemsCommitterLoginQueryString_2 | null;
  id: githubCommitsItemsCommitterIdQueryInteger_2 | null;
  nodeId: githubCommitsItemsCommitterNodeIdQueryString_2 | null;
  avatarUrl: githubCommitsItemsCommitterAvatarUrlQueryString_2 | null;
  gravatarId: githubCommitsItemsCommitterGravatarIdQueryString_2 | null;
  url: githubCommitsItemsCommitterUrlQueryString_2 | null;
  htmlUrl: githubCommitsItemsCommitterHtmlUrlQueryString_2 | null;
  followersUrl: githubCommitsItemsCommitterFollowersUrlQueryString_2 | null;
  subscriptionsUrl: githubCommitsItemsCommitterSubscriptionsUrlQueryString_2 | null;
  organizationsUrl: githubCommitsItemsCommitterOrganizationsUrlQueryString_2 | null;
  reposUrl: githubCommitsItemsCommitterReposUrlQueryString_2 | null;
  receivedEventsUrl: githubCommitsItemsCommitterReceivedEventsUrlQueryString_2 | null;
  type: githubCommitsItemsCommitterTypeQueryString_2 | null;
  siteAdmin: githubCommitsItemsCommitterSiteAdminQueryBoolean_2 | null;
  ldapDn: githubCommitsItemsCommitterLdapDnQueryString_2 | null;
}

export interface githubCommitsItemsCommitterLoginQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterIdQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface githubCommitsItemsCommitterNodeIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterAvatarUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterGravatarIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterFollowersUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterSubscriptionsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterOrganizationsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterReposUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterReceivedEventsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsCommitterSiteAdminQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface githubCommitsItemsCommitterLdapDnQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsParentsQueryList_2 {
  elemMatch: githubCommitsItemsParentsInputObject_2 | null;
}

export interface githubCommitsItemsParentsInputObject_2 {
  sha: githubCommitsItemsParentsShaQueryString_2 | null;
  url: githubCommitsItemsParentsUrlQueryString_2 | null;
  htmlUrl: githubCommitsItemsParentsHtmlUrlQueryString_2 | null;
}

export interface githubCommitsItemsParentsShaQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsParentsUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsItemsParentsHtmlUrlQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsInternalInputObject_2 {
  type: githubCommitsInternalTypeQueryString_2 | null;
  contentDigest: githubCommitsInternalContentDigestQueryString_2 | null;
  owner: githubCommitsInternalOwnerQueryString_2 | null;
}

export interface githubCommitsInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface githubCommitsInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface consumerProjectVersionsFileIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface consumerProjectVersionsFileCurrentProjectVersionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface consumerProjectVersionsFileInternalInputObject_2 {
  type: consumerProjectVersionsFileInternalTypeQueryString_2 | null;
  contentDigest: consumerProjectVersionsFileInternalContentDigestQueryString_2 | null;
  owner: consumerProjectVersionsFileInternalOwnerQueryString_2 | null;
}

export interface consumerProjectVersionsFileInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface consumerProjectVersionsFileInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface consumerProjectVersionsFileInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryInternalInputObject_2 {
  contentDigest: directoryInternalContentDigestQueryString_2 | null;
  type: directoryInternalTypeQueryString_2 | null;
  description: directoryInternalDescriptionQueryString_2 | null;
  owner: directoryInternalOwnerQueryString_2 | null;
}

export interface directoryInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryInternalDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directorySourceInstanceNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryRelativePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryExtensionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directorySizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryPrettySizeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryModifiedTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryAccessTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryChangeTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryBirthTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryRootQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryDirQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryBaseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryExtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryRelativeDirectoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryDevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryModeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryNlinkQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryUidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryGidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryRdevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryBlksizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryInoQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryBlocksQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryAtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryMtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryCtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryBirthtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface directoryAtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryMtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryCtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface directoryBirthtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalInputObject_2 {
  contentDigest: fileInternalContentDigestQueryString_2 | null;
  mediaType: fileInternalMediaTypeQueryString_2 | null;
  type: fileInternalTypeQueryString_2 | null;
  description: fileInternalDescriptionQueryString_2 | null;
  owner: fileInternalOwnerQueryString_2 | null;
  fieldOwners: fileInternalFieldOwnersInputObject_2 | null;
}

export interface fileInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalMediaTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalFieldOwnersInputObject_2 {
  segments: fileInternalFieldOwnersSegmentsQueryString_2 | null;
  title: fileInternalFieldOwnersTitleQueryString_2 | null;
  slug: fileInternalFieldOwnersSlugQueryString_2 | null;
  path: fileInternalFieldOwnersPathQueryString_2 | null;
  tab: fileInternalFieldOwnersTabQueryString_2 | null;
  tabPath: fileInternalFieldOwnersTabPathQueryString_2 | null;
}

export interface fileInternalFieldOwnersSegmentsQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalFieldOwnersTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalFieldOwnersSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalFieldOwnersPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalFieldOwnersTabQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileInternalFieldOwnersTabPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileSourceInstanceNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileRelativePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileExtensionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileSizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface filePrettySizeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileModifiedTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileAccessTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileChangeTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileBirthTimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileRootQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileDirQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileBaseQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileExtQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileNameQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileRelativeDirectoryQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileDevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileModeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileNlinkQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileUidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileGidQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileRdevQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileBlksizeQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileInoQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileBlocksQueryInteger_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileAtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileMtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileCtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileBirthtimeMsQueryFloat_2 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface fileAtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileMtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileCtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileBirthtimeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileFieldsInputObject_2 {
  segments: fileFieldsSegmentsQueryList_2 | null;
  title: fileFieldsTitleQueryString_2 | null;
  slug: fileFieldsSlugQueryString_2 | null;
  path: fileFieldsPathQueryString_2 | null;
  tab: fileFieldsTabInputObject_2 | null;
  tabPath: fileFieldsTabPathQueryString_2 | null;
}

export interface fileFieldsSegmentsQueryList_2 {
  elemMatch: fileFieldsSegmentsInputObject_2 | null;
}

export interface fileFieldsSegmentsInputObject_2 {
  slug: fileFieldsSegmentsSlugQueryString_2 | null;
  title: fileFieldsSegmentsTitleQueryString_2 | null;
}

export interface fileFieldsSegmentsSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileFieldsSegmentsTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileFieldsTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileFieldsSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileFieldsPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileFieldsTabInputObject_2 {
  slug: fileFieldsTabSlugQueryString_2 | null;
  title: fileFieldsTabTitleQueryString_2 | null;
}

export interface fileFieldsTabSlugQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileFieldsTabTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface fileFieldsTabPathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface publicUrlQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkInternalInputObject_2 {
  content: markdownRemarkInternalContentQueryString_2 | null;
  type: markdownRemarkInternalTypeQueryString_2 | null;
  contentDigest: markdownRemarkInternalContentDigestQueryString_2 | null;
  owner: markdownRemarkInternalOwnerQueryString_2 | null;
}

export interface markdownRemarkInternalContentQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkInternalTypeQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkInternalContentDigestQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkInternalOwnerQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkFrontmatterInputObject_2 {
  title: markdownRemarkFrontmatterTitleQueryString_2 | null;
  redirect: markdownRemarkFrontmatterRedirectQueryString_2 | null;
  _PARENT: markdownRemarkFrontmatterParentQueryString_3 | null;
  parent: markdownRemarkFrontmatterParentQueryString_4 | null;
  description: markdownRemarkFrontmatterDescriptionQueryString_2 | null;
  component: markdownRemarkFrontmatterComponentInputObject_2 | null;
}

export interface markdownRemarkFrontmatterTitleQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkFrontmatterRedirectQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkFrontmatterParentQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkFrontmatterParentQueryString_4 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkFrontmatterDescriptionQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkFrontmatterComponentInputObject_2 {
  id: markdownRemarkFrontmatterComponentIdQueryString_2 | null;
  disablePlayground: markdownRemarkFrontmatterComponentDisablePlaygroundQueryBoolean_2 | null;
}

export interface markdownRemarkFrontmatterComponentIdQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkFrontmatterComponentDisablePlaygroundQueryBoolean_2 {
  eq: boolean | null;
  ne: boolean | null;
  in: Array<boolean> | null;
  nin: Array<boolean> | null;
}

export interface excerptQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkRawMarkdownBodyQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface markdownRemarkFileAbsolutePathQueryString_2 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface htmlQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface headingsQueryList_3 {
  elemMatch: headingsListElemTypeName_3 | null;
}

export interface headingsListElemTypeName_3 {
  value: headingsListElemValueQueryString_3 | null;
  depth: headingsListElemDepthQueryInt_3 | null;
}

export interface headingsListElemValueQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface headingsListElemDepthQueryInt_3 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface timeToReadQueryInt_3 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface tableOfContentsQueryString_3 {
  eq: string | null;
  ne: string | null;
  regex: string | null;
  glob: string | null;
  in: Array<string> | null;
  nin: Array<string> | null;
}

export interface wordCountTypeName_3 {
  paragraphs: wordCountParagraphsQueryInt_3 | null;
  sentences: wordCountSentencesQueryInt_3 | null;
  words: wordCountWordsQueryInt_3 | null;
}

export interface wordCountParagraphsQueryInt_3 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface wordCountSentencesQueryInt_3 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}

export interface wordCountWordsQueryInt_3 {
  eq: number | null;
  ne: number | null;
  gt: number | null;
  gte: number | null;
  lt: number | null;
  lte: number | null;
  in: Array<number> | null;
  nin: Array<number> | null;
}
