import * as React from "react";
import * as favicon from "./favicon.png";

interface Props {
  htmlAttributes: React.HTMLAttributes<HTMLElement>;
  bodyAttributes: React.HTMLAttributes<HTMLBodyElement>;
  body: string;
  headComponents: React.ReactNode;
  preBodyComponents: React.ReactNode;
  postBodyComponents: React.ReactNode;
}

export default class HTML extends React.Component<Props> {
  public render() {
    return (
      <html className="tw-root--hover" {...this.props.htmlAttributes}>
        <head>
          <meta charSet="utf-8" />
          <meta httpEquiv="x-ua-compatible" content="ie=edge" />
          <meta
            name="viewport"
            content="width=device-width, initial-scale=1, shrink-to-fit=no"
          />
          <link rel="shortcut icon" type="image/png" href={favicon} />
          {this.props.headComponents}
        </head>
        <body {...this.props.bodyAttributes}>
          {this.props.preBodyComponents}
          <div
            key={`body`}
            id="___gatsby"
            dangerouslySetInnerHTML={{ __html: this.props.body }}
          />
          {this.props.postBodyComponents}
        </body>
      </html>
    );
  }
}
