"use strict";

const baseUrl = "twitch.tv";
let response = {
  status: "302",
  statusDescription: "Found",
  headers: {
    location: [
      {
        key: "Location",
        value: `https://${baseUrl}/index.html`,
      },
    ],
    ["cache-control"]: [
      {
        key: "Cache-Control",
        value: "no-cache, no-store, private",
      },
    ],
  },
};

exports.originRequestHandler = (event, ctx, callback) => {
  const request = event.Records[0].cf.request;
  const headers = request.headers;
  let isAuth = "";

  // Simulate e2-http service check for a particular cookie/header
  // TODO case insensitive
  try {
    isAuth = request.headers.isauth[0].value || "";
  } catch (e) {
    console.error(e);
  }

  console.info("headers/isAuth", headers, isAuth);

  if (isAuth === "admin") {
    // let them do as they please
    callback(null, request);
    return;
  }

  if (isAuth === "yes") {
    response.headers.location[0].value = `https://${baseUrl}/index.html`;
    request.uri = "/index.html";
    callback(null, request);
    return;
  }

  console.log("redirecting to 404");
  response.headers.location[0].value = `https://${baseUrl}/404.html`;
  callback(null, response);
};
