import * as React from "react";
import {
  Color,
  Column,
  CoreLink,
  CoreText,
  FontSize,
  Grid,
  Layout,
  ResponsiveWrapper,
  SVG,
  SVGAsset,
  SVGType,
  TextType,
} from "twitch-core-ui";
import { renderLink } from "../utils/render-link";
import "./styles.scss";

const ErrorPage = () => {
  return (
    <Layout className="error-page" padding={5}>
      <ResponsiveWrapper centered>
        <Grid>
          <Column
            cols={{ default: 12, sm: 8, md: 5 }}
            offset={{ default: 0, sm: 1 }}
          >
            <Layout padding={{ top: 5 }} margin={{ bottom: 4 }}>
              <SVG
                type={SVGType.Alt2}
                asset={SVGAsset.DeadGlitch}
                width={80}
                height={80}
              />
            </Layout>
            <Layout margin={{ bottom: 2 }}>
              <CoreText className="error-page__heading" type={TextType.H1} bold>
                Page Not Found
              </CoreText>
            </Layout>
            <CoreText fontSize={FontSize.Size4} color={Color.Alt}>
              The page you were looking for could not be found. You can go back
              to the{" "}
              <CoreLink linkTo="/" renderLink={renderLink}>
                front page
              </CoreLink>
            </CoreText>
          </Column>
        </Grid>
      </ResponsiveWrapper>
    </Layout>
  );
};

export default ErrorPage;
