import * as classnames from "classnames";
import * as React from "react";
import { Helmet } from "react-helmet";
import { AuthenticateCallout } from "src/components/authenticate-callout";
import {
  AlignItems,
  Background,
  BorderRadius,
  Color,
  Column,
  CoreImage,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Grid,
  GridGutterSize,
  Layout,
  Overflow,
  Position,
  ResponsiveWrapper,
  StyledLayout,
  SVGAsset,
  TextType,
  Title,
  TitleSize,
  VerticalNavigation,
  VerticalNavigationItem,
} from "twitch-core-ui";
import { renderLink } from "../utils/render-link";

import dropImage from "static/assets/homePage/DropsSmall.png";
import e2Image from "static/assets/homePage/E2Small.png";

interface JSXProps {
  children?: React.ReactNode;
}

type Props = JSXProps;

const SideBar = () => (
  <StyledLayout
    className="sidebar-menu"
    display={Display.Flex}
    fontSize={FontSize.Size5}
    background={Background.Alt}
    fullHeight
  >
    <Layout
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      fullWidth
      fullHeight
    >
      {/* Table of links */}
      <Layout overflow={Overflow.Auto}>
        <VerticalNavigation>
          <VerticalNavigationItem selected iconAsset={SVGAsset.Home}>
            Home
          </VerticalNavigationItem>
          <VerticalNavigationItem
            linkTo="/enhanced-experiences"
            renderLink={renderLink}
            iconAsset={SVGAsset.NavCreative}
          >
            Enhanced Experiences
          </VerticalNavigationItem>
          <VerticalNavigationItem
            linkTo="/drops"
            renderLink={renderLink}
            iconAsset={SVGAsset.Drops}
          >
            Drops
          </VerticalNavigationItem>
        </VerticalNavigation>
      </Layout>
    </Layout>
  </StyledLayout>
);

const PageHeading = () => (
  <Layout
    display={Display.Flex}
    alignItems={AlignItems.Center}
    padding={{ bottom: 2 }}
  >
    <Layout flexGrow={1} display={Display.Flex} alignItems={AlignItems.Center}>
      <Title size={TitleSize.ExtraLarge} type={TextType.H1}>
        Home
      </Title>
    </Layout>
  </Layout>
);

const PageWrapper = ({ children }: Props) => {
  const classes: ClassValue = {
    layout: true,
    "layout--has-sidebar-menu": true,
  };
  return (
    <Layout padding={4} display={Display.Flex}>
      <Helmet>
        <title>Home</title>
      </Helmet>
      <Layout fullHeight className={classnames(classes)}>
        <Layout position={Position.Fixed} fullHeight attachTop attachLeft>
          <SideBar />
        </Layout>
      </Layout>
      <Layout>
        <ResponsiveWrapper>
          <PageHeading />
          <Grid gutterSize={GridGutterSize.Large}>
            <Column cols={{ default: 12, lg: 9, xl: 9, xxl: 8 }}>
              <Layout>{children}</Layout>
            </Column>
          </Grid>
        </ResponsiveWrapper>
      </Layout>
    </Layout>
  );
};

const PageBodyContent = () => (
  <Layout>
    <Layout margin={{ bottom: 2 }}>
      <CoreText color={Color.Alt2} fontSize={FontSize.Size5}>
        Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
        tempor incididunt ut labore et dolore magna aliqua.
      </CoreText>
    </Layout>
    <StyledLayout margin={{ bottom: 4 }} borderBottom padding={{ bottom: 3 }}>
      <AuthenticateCallout />
    </StyledLayout>
    <Layout margin={{ bottom: 4 }}>
      <Title size={TitleSize.Large}>Getting Started</Title>
    </Layout>
    <Layout margin={{ bottom: 4 }}>
      <Grid>
        <Column cols={6}>
          {renderStartingSection(
            e2Image,
            "Enhanced Experience Icon",
            "Enhanced Experience",
            "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris nisi nisi, varius nec.",
          )}
        </Column>
        <Column cols={6}>
          {renderStartingSection(
            dropImage,
            "Drops Icon",
            "Drops",
            "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris nisi nisi, varius nec. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris nisi nisi, varius nec. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris nisi nisi, varius nec.",
          )}
        </Column>
      </Grid>
    </Layout>
    <CoreText fontSize={FontSize.Size5}>
      Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
      tempor incididunt ut labore et dolore magna aliqua.
    </CoreText>
  </Layout>
);

const renderStartingSection = (
  img: string,
  imgAlt: string,
  title: string,
  description: string,
) => {
  return (
    <StyledLayout
      display={Display.Flex}
      elevation={3}
      border
      borderRadius={BorderRadius.Large}
      padding={2}
      fullHeight
    >
      <Layout>
        <CoreImage
          className="landing-page__callout-image"
          alt={imgAlt}
          src={img}
        />
      </Layout>
      <Layout margin={{ left: 1 }}>
        <Title size={TitleSize.ExtraSmall}>{title}</Title>
        <Layout margin={{ top: 0.5 }}>
          <CoreText color={Color.Alt2}>{description}</CoreText>
        </Layout>
      </Layout>
    </StyledLayout>
  );
};

export default () => (
  <PageWrapper>
    <PageBodyContent />
  </PageWrapper>
);
