import * as visit from "unist-util-visit";
import { isRelativeUrl, prefixHtmlAssets, withPathPrefix } from "./utils";

module.exports = async ({ markdownAST, basePath }: any) => {
  // Ensure relative images include `pathPrefix`
  visit(markdownAST, [`image`], (node: any) => {
    if (isRelativeUrl(node.url)) {
      node.url = withPathPrefix(node.url, basePath);
    }
  });

  // Ensure HTML marked-up images with relative urls include `pathPrefix`
  visit(markdownAST, [`html`], (node: any) => {
    node.value = prefixHtmlAssets(node.value, basePath);
  });

  return markdownAST;
};

// Code referenced from:
// https://github.com/gatsbyjs/gatsby/blob/master/packages/gatsby-transformer-remark/src/extend-node-type.js
