export interface GatsySourceGithubArguments {
  user: string;
  repository: string;
  token: string;
  rootURL: string;
  cwd: string;
  pattern: string;
  baseDir: string;
}

export interface GithubRepo {
  commits: GithubCommits;
  releases: any;
}

export interface GithubCommits {
  fetch: (args: { path: string; query?: string }) => Promise<GithubCommitItem>;
}

export interface GithubCommitItem {
  sha?: string;
  commit?: GithubCommitItem;
  url?: string;
  htmlUrl?: string;
  message?: string;
  commentCount?: number;
  commentsUrl?: string;
  committer?: GithubCommitAuthor;
  author?: GithubCommitAuthor;
  items?: GithubCommitItem[];
  parents?: GithubCommitItem[];
  tree?: GithubCommitItem;
  verification?: {};
}

export interface GithubCommitAuthor {
  id?: number;
  login?: string;
  date?: string; // ISO date string
  name?: string;
  email?: string;
  avatarUrl?: string;
  gravatarId?: string;
  url?: string;
  htmlUrl?: string;
  followersUrl?: string;
  subscriptionsUrl?: string;
  organizationsUrl?: string;
  reposUrl?: string;
  receivedEventsUrl?: string;
  type?: string;
  siteAdmin?: boolean;
  ldapDn?: string;
}

export interface GithubCommitVerification {
  verified?: boolean;
  reason?: string;
  signature?: null;
  payload?: null;
}

export const emptyGithubCommitItem: GithubCommitItem = {
  sha: "",
  commit: {
    author: {
      name: "",
      email: "",
      date: new Date().toISOString(),
    },
    committer: {
      name: "",
      email: "",
      date: new Date().toISOString(),
    },
    message: "",
    tree: {
      sha: "",
      url: "",
    },
    url: "",
    commentCount: 0,
    verification: {
      verified: false,
      reason: "",
      signature: null,
      payload: null,
    },
  },
  url: "",
  htmlUrl: "",
  message: "",
  commentsUrl: "",
  author: {
    login: "",
    id: 123,
    avatarUrl: "",
    gravatarId: "",
    url: "",
    htmlUrl: "",
    followersUrl: "",
    subscriptionsUrl: "",
    organizationsUrl: "",
    reposUrl: "",
    receivedEventsUrl: "",
    type: "",
    siteAdmin: false,
    ldapDn: "",
  },
  committer: {
    login: "",
    id: 123,
    avatarUrl: "",
    gravatarId: "",
    url: "",
    htmlUrl: "",
    followersUrl: "",
    subscriptionsUrl: "",
    organizationsUrl: "",
    reposUrl: "",
    receivedEventsUrl: "",
    type: "",
    siteAdmin: false,
    ldapDn: "",
  },
  parents: [
    {
      sha: "",
      url: "",
      htmlUrl: "",
    },
  ],
};

export const emptyGithubVersionRelease = {
  tagName: "",
  htmlUrl: "",
  publishedAt: "2019-06-03T22:00:40.000Z", // must be a valid timestamp or may cause local dev errors!
  body: "",
};
