import * as crypto from "crypto";

// tslint:disable-next-line no-require-imports no-var-requires
const currentCorePackage = require("twitch-core-ui/package.json");

exports.sourceNodes = ({ actions }: any) => {
  const { createNode } = actions;

  createNode({
    id: `consumerProjectVersions`,
    currentProjectVersion: currentCorePackage.version,
    parent: null,
    children: [],
    internal: {
      type: "consumerProjectVersionsFile",
      contentDigest: crypto
        .createHash("md5")
        .update(JSON.stringify(currentCorePackage.version))
        .digest("hex"),
    },
  });

  return;
};
