import * as crypto from "crypto";

export enum NodeType {
  GithubCommits = "GithubCommits",
  GithubRelease = "GithubVersionRelease",
  TypeDoc = "TypeDoc",
}

/**
 * Returns an object that appends the data to be saved as fields in the node,
 * along with the with the keys required for creating the node.
 */
export const getProcessedNode = (
  type: NodeType,
  id: string | null,
  data: any,
) => {
  return {
    ...data,

    // Required fields.
    id: id || `${type} (empty)`,
    parent: null,
    children: [],
    internal: {
      type: `${type}`,
      contentDigest: crypto
        .createHash("md5")
        .update(JSON.stringify(data))
        .digest("hex"),
    },
  };
};
