import { LocationContext } from "@reach/router";
import { graphql } from "gatsby";
import * as React from "react";
import { Column, Grid, GridGutterSize, Layout } from "twitch-core-ui";
import { Markdown } from "../components/markdown";
import { PageWrapper } from "../components/page-wrapper";
import { TableOfContents } from "../components/table-of-contents";
import { File, FileConnection, SitePage, TypeDoc } from "../graphql-types";
import "./styles.scss";

interface PublicProps {
  data: {
    indexPage: SitePage;
    indexFile: File;
    tabs: FileConnection;
    activeTab: File;
    component?: TypeDoc;
  };
}

type Props = PublicProps & LocationContext;

export default class PageTemplate extends React.Component<Props, {}> {
  public render() {
    return (
      <div>
        <PageWrapper
          page={this.props.data.indexPage}
          file={this.props.data.indexFile}
          tabs={this.props.data.tabs}
          component={this.props.data.component}
          location={this.props.location}
          navigate={this.props.navigate}
        >
          {this.renderMarkdownPageContent()}
        </PageWrapper>
      </div>
    );
  }

  private renderMarkdownPageContent = () => {
    return (
      this.props.data.activeTab.childMarkdownRemark &&
      this.props.data.activeTab.childMarkdownRemark.html && (
        <Grid gutterSize={GridGutterSize.Large}>
          <Column cols={{ default: 12, lg: 8, xl: 7, xxl: 6 }}>
            <Layout>
              <Markdown
                source={this.props.data.activeTab.childMarkdownRemark.html}
              />
            </Layout>
          </Column>
          <Column
            offset={{ default: 0, xl: 1 }}
            cols={{ default: 12, lg: 4, xl: 3 }}
          >
            <Layout
              padding={{ y: 2 }}
              className="default-page__table-of-contents"
            >
              {this.props.data.activeTab.childMarkdownRemark &&
                this.props.data.activeTab.childMarkdownRemark.headings && (
                  <TableOfContents
                    headings={
                      this.props.data.activeTab.childMarkdownRemark.headings
                    }
                    basePath={this.props.location.pathname}
                  />
                )}
            </Layout>
          </Column>
        </Grid>
      )
    );
  };
}

export const pageQuery = graphql`
  query DefaultPageContent($pagePath: String!, $path: String, $tab: String) {
    ...defaultPage
    activeTab: file(
      fields: { path: { eq: $pagePath }, tab: { slug: { eq: $tab } } }
    ) {
      relativePath
      fields {
        tabPath
        tab {
          title
          slug
        }
      }
      childMarkdownRemark {
        html
        headings {
          value
          depth
        }
      }
    }
  }
`;
