// tslint:disable jsdoc-format

/*
query MyQuery {
  file(relativePath: {eq: "1-user-interface/3-guidelines/2-accessibility/index.md"}) {
    id
    childMarkdownRemark {
      id
      frontmatter {
        title
        redirect
        component {
          id
          disablePlayground
        }
        description
      }
      html
    }
  }
}
*/

export const fileAccessibility = {
  data: {
    file: {
      id: "fd1db580-ca01-5bdf-8e6a-93750b7e711c",
      childMarkdownRemark: {
        id: "51747fe3-113b-526a-9e29-fbb0b4ce4762",
        frontmatter: {
          title: "",
          redirect: null,
          component: null,
          description:
            "Twitch should be accessible to anyone, anywhere. We strive to provide a clean, balanced look to better serve those with disabilities. Carefully consider font sizes, contrast, translations, and ergonomic UI when making decisions.",
        },
        html:
          '<h2 id="why-is-this-important"><a href="#why-is-this-important" aria-label="why is this important permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Why is this important?</h2>\n<p>15% of the world\'s population lives with some form of disability, and 1 in 5 American adults have at least one kind of disability. Of those living with a form of disability; 9.4% are vision, 10.6% are cognitive, and 15.3% are associated with hearing.</p>\n<h2 id="lets-build-inclusive-experiences"><a href="#lets-build-inclusive-experiences" aria-label="lets build inclusive experiences permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Let\'s Build Inclusive Experiences</h2>\n<h3 id="all-the-right-pieces"><a href="#all-the-right-pieces" aria-label="all the right pieces permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>All the Right Pieces</h3>\n<p>Choose from interdependent components of Core UI to assure accessibility for all. Implementing common components across Twitch means that we can constantly improve the accessibility, usability, and aesthetic quality of UI in a single consumable, versioned, dependency. Themes are designed around our palettes and accessibility guidelines to accommodate our users.</p>\n<p><img src="/assets/ultraviolet/guidelines-accessibility-core-ui.png" alt="Twitch Light and Dark Theme Preview"></p>\n<h3 id="alternative-text-for-images"><a href="#alternative-text-for-images" aria-label="alternative text for images permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Alternative Text for Images</h3>\n<p>All images must have an alt attribute. Images that accompany or replace text associated with an action, such as icons in links or buttons or a logo that links to the home page, should have alt="" because it\'s alternative text will be the content of that link or button.</p>\n<p>All other images must have alternative text. This text should be an accurate representation of the content of the image. It should be concise and not redundant. It also should not use the phrases: "image of ...", "picture of ...", etc. WebAIM has a <a href="http://webaim.org/techniques/alttext/">great article on how to structure alternative text</a>.</p>\n<p>Any image that isn\'t used as a supplement to an action – link or button – must have an effective alt tag.</p>\n<div>\n      <pre data-language="jsx"><code data-language="jsx">&lt;img\n  alt=&quot;Dragon breathing fire in video game cinematics.&quot;\n  src=&quot;/assets/principles/Accessibility-Dragon.jpg&quot;\n/&gt;</code></pre>\n    </div>\n<h3 id="color-choice"><a href="#color-choice" aria-label="color choice permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Color Choice</h3>\n<h4 id="contrast"><a href="#contrast" aria-label="contrast permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Contrast</h4>\n<p>People with visual and cognitive disabilities may have difficulty reading text that does not contrast strongly against it\'s background. Differences in display technology can compound this issue by not rendering shades with full integrity. The Contrast Checker in Colors will define which SASS color variables are accessible used on any given background.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  mediaSrc: &quot;/assets/principles/Accessibility-Contrast--Do.svg&quot;\n- type: &quot;dont&quot;\n  mediaSrc: &quot;/assets/principles/Accessibility-Contrast--Dont.svg&quot;</code></pre>\n    </div>\n<h4 id="communicating-meaning"><a href="#communicating-meaning" aria-label="communicating meaning permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Communicating Meaning</h4>\n<p>For users who have difficulty distinguishing between certain colors – color blindness – it is important to consider alternative or accompanying methods of communicating interface states.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  mediaSrc: &quot;/assets/ultraviolet/guidelines-accessibility-communicate-meaning-do.png&quot;\n  body: When communicating meaning with color, use an accompanying element, such as a label or icon, to enforce the message.\n- type: &quot;dont&quot;\n  mediaSrc: &quot;/assets/ultraviolet/guidelines-accessibility-communicate-meaning-dont.png&quot;\n  body: &quot;Use only color to communicate a state because color blind users may not be able to interpret the meaning.&quot;</code></pre>\n    </div>\n<h3 id="clearly-caption-audio-in-video"><a href="#clearly-caption-audio-in-video" aria-label="clearly caption audio in video permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Clearly Caption Audio in Video</h3>\n<p>Use subtitles for voiceover audio and to accompany animations. They also help non-native English speakers understand the video and make it possible to search for content.</p>\n<h3 id="plan-for-your-platform"><a href="#plan-for-your-platform" aria-label="plan for your platform permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Plan for Your Platform</h3>\n<p>Include specialized coverage for mobile and web or print projects. Follow platform guidelines to quickly develop a product using existing elements, allowing you focus on its features without having to create everything from scratch.</p>\n<h2 id="resources"><a href="#resources" aria-label="resources permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Resources</h2>\n<h3 id="reading"><a href="#reading" aria-label="reading permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Reading</h3>\n<ul>\n<li><a href="https://material.io/guidelines/usability/accessibility.html">Material Guidelines</a></li>\n<li><a href="https://code.facebook.com/accessibility">Facebook Accessibility Guidelines</a></li>\n<li><a href="https://teachaccess.github.io/tutorial/">HIKE</a></li>\n<li><a href="http://webaim.org/">WebAIM</a></li>\n</ul>\n<h3 id="tools"><a href="#tools" aria-label="tools permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Tools</h3>\n<ul>\n<li><a href="http://khan.github.io/tota11y/">tota11y</a></li>\n<li><a href="https://michelf.ca/projects/sim-daltonism/">Color Blindness Simulator</a></li>\n<li><a href="https://github.com/getflourish/Sketch-Color-Contrast-Analyser">Color Contrast Analyser for Sketch</a></li>\n<li><a href="https://chrome.google.com/webstore/detail/accessibility-developer-t/fpkknkljclfencbdbgkenhalefipecmb?hl=e">Accessibility Developer Tools</a></li>\n</ul>',
      },
    },
  },
};
