// tslint:disable jsdoc-format

/*
query MyQuery {
  file(relativePath: {eq: "2-mobile/1-getting-started/index.md"}) {
    id
    childMarkdownRemark {
      id
      frontmatter {
        title
        redirect
        component {
          id
          disablePlayground
        }
        description
      }
      html
    }
  }
}
*/

export const fileGettingStarted = {
  data: {
    file: {
      id: "8e812ddd-d07b-55a2-a16b-47cd133f45a2",
      childMarkdownRemark: {
        id: "529639a4-0778-50b6-b9d2-a33c4c623930",
        frontmatter: {
          title: "Getting Started",
          redirect: null,
          component: null,
          description:
            "Twitch Mobile users expect a lot from our app - and you. In return for the love and support of their favorite content creators, we promise a focused experience that adapts to context of use, lowers navigation overhead, and provides engaging, shared real-time experiences by putting their needs first.",
        },
        html:
          '<p><img src="/assets/ui/images/getting-started-hero.png" alt="Getting Started"></p>\n<h2 id="mobile-first"><a href="#mobile-first" aria-label="mobile first permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Mobile First</h2>\n<p>Twitch is a Mobile First company. The approach is exactly as it sounds. Embracing this challenge requires placing handheld devices at the forefront of customer development strategy, planning, and implementation.</p>\n<p>If you think a problem is worth solving for people on web, it is most certainly a problem worth solving for our mobile users. Start there first, and work your way up.</p>\n<h4 id="a-mobile-first-philosophy-taps-current-growth-trends-and-prepares-you-for-the-future"><a href="#a-mobile-first-philosophy-taps-current-growth-trends-and-prepares-you-for-the-future" aria-label="a mobile first philosophy taps current growth trends and prepares you for the future permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>A Mobile First philosophy taps current growth trends and prepares you for the future.</h4>\n<p>It’s where our user are, and its where our newest users are going. The Twitch mobile apps have a yearly growth rate that is outpacing web by 3x, with 46% of our user-base (DUA) on mobile.</p>\n<h4 id="a-mobile-first-philosophy-forces-you-to-prioritize-only-whats-most-important"><a href="#a-mobile-first-philosophy-forces-you-to-prioritize-only-whats-most-important" aria-label="a mobile first philosophy forces you to prioritize only whats most important permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>A Mobile First philosophy forces you to prioritize only what’s most important.</h4>\n<p>Building a world-class mobile product means effectively understanding our customers and the business. When your focus is Mobile First, it forces you to ruthlessly prioritize features and presentation that get straight to the point.</p>\n<h4 id="embracing-a-mobile-first-philosophy-is-less-costly-and-more-time-efficient"><a href="#embracing-a-mobile-first-philosophy-is-less-costly-and-more-time-efficient" aria-label="embracing a mobile first philosophy is less costly and more time efficient permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Embracing a Mobile First philosophy is less costly and more time efficient.</h4>\n<p>Mobile design, as the hardest, should be done first. If it satisfies customer needs there, it translates better to all other clients without having to retrofit or rethink your approach. The reward is saving design and development costs.</p>\n<h2 id="tenets"><a href="#tenets" aria-label="tenets permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Tenets</h2>\n<div>\n      <pre data-language="yml block-columns"><code data-language="yml block-columns">- cols: 4\n  body: |\n    ![Getting Started](/assets/ui/images/illo1.png)\n- cols: 8\n  body: |\n    #### Mobile Twitch is the only Twitch many of our users will ever know.\n\n    The client needs to stand alone. We shouldn’t create tiered experiences based solely on the device a user owns. If you want to understand them you should regularly limit yourself and your team to only use Twitch on mobile.</code></pre>\n    </div>\n<div>\n      <pre data-language="yml block-columns"><code data-language="yml block-columns">- cols: 4\n  body: |\n    ![Getting Started](/assets/ui/images/illo2.png)\n- cols: 8\n  body: |\n    #### Imagined for the mobile user.\n\n    User problems are device agnostic. A user problem doesn’t disappear just because they are on a smaller screen. Just because a need exists on mobile, it doesn’t mean the solution is a clone of that feature on another client. All features shipped to mobile should be built explicitly for mobile.</code></pre>\n    </div>\n<div>\n      <pre data-language="yml block-columns"><code data-language="yml block-columns">- cols: 4\n  body: |\n    ![Getting Started](/assets/ui/images/illo3.png)\n- cols: 8\n  body: |\n    #### Put the hits at the top.\n\n    Screen size means the amount of content or options we present a user on any given page are much smaller. We don’t make the user scroll forever to do something: our aim should be to place the most wanted actions or content at the top. If we realize we don’t know what the most wanted thing is, we invest in finding out.</code></pre>\n    </div>\n<p><a href="https://wiki.twitch.com/display/ENG/Mobile+Native+Clients">Mobile Native Clients</a><br>\n<a href="https://wiki.twitch.com/display/ENG/Mobile+Web">Mobile Web</a></p>',
      },
    },
  },
};
