// tslint:disable jsdoc-format

/*
query MyQuery {
  file(relativePath: {eq: "1-user-interface/5-patterns/transition-group/index.md"}) {
    id
    childMarkdownRemark {
      id
      frontmatter {
        title
        redirect
        component {
          id
          disablePlayground
        }
        description
      }
      html
    }
  }
}
*/

export const fileTransitionGroup = {
  data: {
    file: {
      id: "dd63be98-8fbd-59a6-920f-1c6052b16725",
      childMarkdownRemark: {
        id: "1b01c538-c600-507c-8b15-7945e9c6cec6",
        frontmatter: {
          title: "",
          redirect: null,
          component: {
            id: "components/transition-group",
            disablePlayground: true,
          },
          description: null,
        },
        html:
          '<h2 id="goals"><a href="#goals" aria-label="goals permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Goals</h2>\n<div>\n      <pre data-language="yml block-columns"><code data-language="yml block-columns">- cols: 6\n  body: |\n    *TransitionGroup is best used when*\n\n    * Elements in the group are similar, such as a list, cards, etc.\n    * Elements are manually or passively rearranged or repopulated.\n- cols: 6\n  body: |\n    *Avoid using TransitionGroup when*\n\n    * Attempting to load a transition at an initial page load.</code></pre>\n    </div>\n<hr>\n<h2 id="usage"><a href="#usage" aria-label="usage permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Usage</h2>\n<p><code>TransitionGroup</code> is a useful tool to help users process change in the UI, especially when the UI involves a list similar elements. This particular movement may involve the addition, subtraction, or shift of a UI element where it affects many of the other similar elements around it. In practice, this might signify a reordering of channels by concurrent viewers or the additional presence of a channel that just went live. Other potential uses can include removing, adding, or reordering cards. The examples seen on here are meant to be design and usage inspiration.</p>\n<p>Basic code usage looks like this:</p>\n<div>\n      <pre data-language="jsx hide-preview"><code data-language="jsx hide-preview">&lt;TransitionGroup&gt;\n  {[\n    /*items*/\n  ].map((item: any) =&gt; (\n    &lt;div key={item.key}&gt;Some Child&lt;/div&gt;\n  ))}\n&lt;/TransitionGroup&gt;</code></pre>\n    </div>\n<p>One potential use case for <code>TransitionGroup</code> is an active leaderboard. Here we see how changes in rankings affect the position applied to individual entries. While a user may choose to manually trigger a change by Cheering, the background updates may still take place.</p>\n<div>\n      <pre data-language="yml block-code"><code data-language="yml block-code">path: user-interface/patterns/transition-group/examples/bits-cheering-leaderboard\nprops:\n  hideCode: true\n  plainContainer: true\n  urlToSourceCode: https://git-aws.internal.justin.tv/core-ui/core-ui-docs/tree/master/src/code-examples/user-interface/patterns/transition-group/examples/bits-cheering-leaderboard</code></pre>\n    </div>\n<p>For accessibility, background updates in similar cases should apply a minimum theshold of <code>5 seconds</code> between intervals, while the recommended is <code>10 seconds</code> or more. As transitions should help users process UI changes, it should not hinder users in understanding what is happening by updating too rapidly. Please refer to the <a href="/user-interface/principles/animation#purpose">animation principles</a> for more information on how transitions can help users process UI changes.</p>\n<h3 id="tag-picker"><a href="#tag-picker" aria-label="tag picker permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Tag Picker</h3>\n<p><code>TransitionGroup</code> can also be used to convey a change in a list of user specified tags; in the example below, the list of tags will have a transition applied when it changes.</p>\n<div>\n      <pre data-language="yml block-code"><code data-language="yml block-code">path: user-interface/patterns/transition-group/examples/tags-picker\nprops:\n  hideCode: true\n  plainContainer: true\n  urlToSourceCode: https://git-aws.internal.justin.tv/core-ui/core-ui-docs/tree/master/src/code-examples/user-interface/patterns/transition-group/examples/tags-picker</code></pre>\n    </div>\n<h3 id="carousel"><a href="#carousel" aria-label="carousel permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Carousel</h3>\n<p>The example below illustrates how <code>TransitionGroup</code> might be applied in a horizontal layout such as a carousel. The manipulation of any list element will utilize <code>TransitionGroup</code> to communicate changes in the UI. This particular example showcases how box art might reorder, replaced, or removed.</p>\n<div>\n      <pre data-language="yml block-code"><code data-language="yml block-code">path: user-interface/patterns/transition-group/examples/simple-carousel\nprops:\n  hideCode: true\n  plainContainer: true\n  urlToSourceCode: https://git-aws.internal.justin.tv/core-ui/core-ui-docs/tree/master/src/code-examples/user-interface/patterns/transition-group/examples/simple-carousel</code></pre>\n    </div>\n<h3 id="tower-layout"><a href="#tower-layout" aria-label="tower layout permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Tower Layout</h3>\n<p>You can specify a <code>&#x3C;Tower></code> as the container component for your child items. All the same transition options can be applied. The example below shows one possible use case to expand/collapse rows.</p>\n<div>\n      <pre data-language="jsx hide-preview"><code data-language="jsx hide-preview">&lt;TransitionGroup component={&lt;Tower /&gt;} /&gt;</code></pre>\n    </div>\n<div>\n      <pre data-language="yml block-code"><code data-language="yml block-code">path: user-interface/patterns/transition-group/examples/transition-group-tower\nprops:\n  hideCode: true\n  plainContainer: true\n  urlToSourceCode: https://git-aws.internal.justin.tv/core-ui/core-ui-docs/tree/master/src/code-examples/user-interface/patterns/transition-group/examples/transition-group-tower</code></pre>\n    </div>\n<h3 id="menus"><a href="#menus" aria-label="menus permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Menus</h3>\n<p>The example below shows how we can transition between sections of a menu in order to illustrate the relationship between sections as the user navigates between them.</p>\n<div>\n      <pre data-language="yml block-code"><code data-language="yml block-code">path: user-interface/patterns/transition-group/examples/nested-menu\nprops:\n  hideCode: true\n  plainContainer: false\n  urlToSourceCode: https://git-aws.internal.justin.tv/core-ui/core-ui-docs/tree/master/src/code-examples/user-interface/patterns/transition-group/examples/nested-menu</code></pre>\n    </div>\n<h2 id="testing"><a href="#testing" aria-label="testing permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Testing</h2>\n<p>When writing automated unit tests, it may become necessary to assert that children of <code>TransitionGroup</code> are added or removed over time. You can simulate a CSS transition end event in order to get <code>TransitionGroup</code> to run appropriate callbacks and update the child list after enter/exit transitions take place:</p>\n<div>\n      <pre data-language="ts"><code data-language="ts">wrapper.find(Transition).forEach(child =&gt; {\n  child.simulate(&quot;transitionEnd&quot;);\n});\nwrapper.update();</code></pre>\n    </div>\n<hr>\n<p><strong>Related</strong></p>\n<ul>\n<li><a href="/user-interface/principles/animation">Animation Principles</a></li>\n<li><a href="/user-interface/patterns/transition">Transition</a></li>\n<li><a href="/user-interface/primitives/placeholder">Placeholder</a></li>\n</ul>',
      },
    },
  },
};
