// tslint:disable jsdoc-format

/*
query MyQuery {
  file(relativePath: {eq: "1-user-interface/3-guidelines/5-writing-for-products/index.md"}) {
    id
    childMarkdownRemark {
      id
      frontmatter {
        title
        redirect
        component {
          id
          disablePlayground
        }
        description
      }
      html
    }
  }
}
*/

export const fileWritingForProducts = {
  data: {
    file: {
      id: "9c8d8ff0-f877-5c74-bbf5-f2b7c333dc99",
      childMarkdownRemark: {
        id: "359dd071-a937-589e-9c2e-0fcee58a20a5",
        frontmatter: {
          title: "Writing for Products",
          redirect: null,
          component: null,
          description:
            "These writing standards will help you understand how to think strategically about the language in your products and apps. They’ll give you clear, tactical suggestions designed to help you use language to craft better experiences.",
        },
        html:
          '<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-intro-1.png&quot;</code></pre>\n    </div>\n<h2 id="goals"><a href="#goals" aria-label="goals permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Goals</h2>\n<p>With every product, we aim to:</p>\n<ul>\n<li>Use language that informs and encourages users to understand and use Twitch.</li>\n<li>Treat users with respect; be considerate and inclusive.</li>\n<li>Educate users instead of talking at or marketing to them, providing opportunities to learn more and explore.</li>\n<li>Communicate features in a guided, friendly, and helpful way.</li>\n<li>Be mindful of Twitch’s place in our users’ lives, avoiding dramatic storytelling and bold claims.</li>\n</ul>\n<p>In order to achieve those goals, our language is:</p>\n<ul>\n<li>Delivering maximum impact and information in minimum words.</li>\n<li>Clear, simple, and direct, aiming to be easily understood by all reading levels.</li>\n<li>Useful to serve a specific purpose, informing and assisting our users.</li>\n<li>Friendly and relatable regardless of background and accessibility factors.</li>\n<li>Appropriate and perpetual, written to suit the situation and remain relevant for years to come.</li>\n</ul>\n<h2 id="content-structure"><a href="#content-structure" aria-label="content structure permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Content Structure</h2>\n<p>Writing should always be direct and clear, using language that will be understood by all users and clearly localized.</p>\n<h4 id="start-with-the-result"><a href="#start-with-the-result" aria-label="start with the result permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Start with the result</h4>\n<p>When an action triggers something, state what it will do and then explain how to make it happen.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    Update your settings with the toggles below.\n\n- type: &quot;dont&quot;\n  body: |\n    Use the toggles below to update your settings.</code></pre>\n    </div>\n<h4 id="watch-out-for-wordiness"><a href="#watch-out-for-wordiness" aria-label="watch out for wordiness permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Watch out for wordiness</h4>\n<p>Only provide vital information to keep text mobile - and localization-friendly and easy for users to parse.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    Follow your favorite streamers to be notified of their activity.\n\n- type: &quot;dont&quot;\n  body: |\n    If you’d like to be notified about new content and updates from the streamers you enjoy the most on Twitch, be sure to give their channels a quick follow.</code></pre>\n    </div>\n<h4 id="keep-phrasing-consistent"><a href="#keep-phrasing-consistent" aria-label="keep phrasing consistent permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Keep phrasing consistent</h4>\n<p>If a similar action in another product is using specific phrases, remain consistent with them. Certain CTAs may ignore this and use button actions with custom flavor for fun.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    Save changes.\n\n- type: &quot;dont&quot;\n  body: |\n    Update, Replace, Save work, End, Complete, Close.</code></pre>\n    </div>\n<h4 id="remove-contractions-and-be-positive"><a href="#remove-contractions-and-be-positive" aria-label="remove contractions and be positive permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Remove contractions and be positive</h4>\n<p>Whenever possible, avoid using contractions (can’t, won’t, don’t, etc.). Instead, try to write in the affirmative (do, does, is, will). Certain contractions (it’s, you’re, that’s, etc.) are fine when used sparingly to be friendly, but keep localization in mind and weigh them against other effective options.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    Only moderators can chat in this room.\n\n- type: &quot;dont&quot;\n  body: |\n    You can’t chat in this room if you don’t have moderator privileges.</code></pre>\n    </div>\n<h4 id="kill-most-modifiers"><a href="#kill-most-modifiers" aria-label="kill most modifiers permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Kill most modifiers</h4>\n<p>If adverbs, adjectives, and way too many extra excessive words are being used to convey something, replace them with a single stronger word to tighten up your message.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    Rapid, intense, multitudes, brilliant.\n\n- type: &quot;dont&quot;\n  body: |\n    Very fast, super exciting, many things, extremely bright.</code></pre>\n    </div>\n<h4 id="serial-comma-is-king"><a href="#serial-comma-is-king" aria-label="serial comma is king permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Serial comma is king</h4>\n<p>It is illegal to not use a serial (Oxford) comma. If caught, the grammar cops will find out and come wag their fingers at you. Language is downright confusing without them—no matter what your internet sources claim—and especially difficult for anyone using English as a second language. <em>This is the one liberal AP guideline that has a hard ruling for Twitch products to provide consistent clarity.</em></p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    Follow, subscribe, and share content from your favorite channels.\n\n- type: &quot;dont&quot;\n  body: |\n    Follow, subscribe and share content from your favorite channels.</code></pre>\n    </div>\n<h2 id="writing-for-components"><a href="#writing-for-components" aria-label="writing for components permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Writing for Components</h2>\n<p>Copy is always made to suit the intended design. Care is given to ensure the shortest, simplest verbiage is worked into tight spaces for localization-friendly strings. Trimming copy to the shortest acceptable length is more desirable than adding more fluff for flair simply due to limitations of mobile space and flavor sometimes being lost in context in other locales.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-components-4.png&quot;</code></pre>\n    </div>\n<p>The below guides are good rules-of-thumb, but do not take them as gospel. Copy editors and technical writers are trained in delivering the most effective ways to communicate information and place punctuation, so it’s not expected for everyone to be able to work this out themselves. These are also the current treatments for our live products and do not include efforts in progress to make broad changes to our products.</p>\n<h3 id="punctuation-and-spacing"><a href="#punctuation-and-spacing" aria-label="punctuation and spacing permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Punctuation and Spacing</h3>\n<p>Use AP guidelines for punctuation as a quick reference if you’re ever in a bind. Otherwise, here are some useful tips for effective punctuation usage in components.</p>\n<h4 id="periods"><a href="#periods" aria-label="periods permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Periods</h4>\n<p>Include a period at the end of a complete sentence.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-periods-5.png&quot;</code></pre>\n    </div>\n<p>Do not use periods at the ends of labels for buttons, tags, independent links (i.e. helper text) outside of sentences, headings, or the primary (usually bold) text on modals.</p>\n<h4 id="exclamation-points"><a href="#exclamation-points" aria-label="exclamation points permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Exclamation points</h4>\n<p>Keep use to a <em>bare minimum</em>. If you find yourself using more than one within two clicks on a modal or a single screen, consider using more effective phrasing to convey excitement without forcing it on a user.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  mediaSrc: &quot;/assets/ui/images/writing/writing-exclaimation-do-6.png&quot;</code></pre>\n    </div>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;dont&quot;\n  mediaSrc: &quot;/assets/ui/images/writing/writing-exclaimation-dont-6.png&quot;</code></pre>\n    </div>\n<h4 id="quotation-marks"><a href="#quotation-marks" aria-label="quotation marks permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Quotation marks</h4>\n<p>Single quotes should not be used in any product strings unless explicitly giving context for code.</p>\n<p>Always use double quotes to directly refer to specific content. Avoid overuse of double quotes.</p>\n<p>Use them to emphasize the name of something for clarity:</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    Click “Go Back” to start over.\n\n- type: &quot;dont&quot;\n  body: |\n    Click below to “start over.”</code></pre>\n    </div>\n<p>Also use double quotes for <em>uncommonly known</em> phrases, phrases specific to a particular product, or to define a term you are introducing. If the phrase is understandable without the quotes, they are not needed.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    Check out this amazing “Play of the Game!”\n\n- type: &quot;dont&quot;\n  body: |\n    Check out these amazing “speedruns!”</code></pre>\n    </div>\n<h4 id="apostrophes"><a href="#apostrophes" aria-label="apostrophes permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Apostrophes</h4>\n<p>Use normally for possessive forms of words not ending in -s. For possessive and plural possessive forms with words ending in -s, lose the s after the apostrophe.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    Check on your Drops’ status in the Inventory.\n\n- type: &quot;dont&quot;\n  body: |\n    Check on your Drops’s status in the Inventory.</code></pre>\n    </div>\n<h4 id="parentheses"><a href="#parentheses" aria-label="parentheses permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Parentheses</h4>\n<p>Use only when absolutely necessary. If the sentence can be used without parentheses, do not use them.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    Watch Twitch on the web or use our mobile and desktop apps.\n\n- type: &quot;dont&quot;\n  body: |\n    There are many ways to view Twitch (website, apps, etc.) no matter which device you use.</code></pre>\n    </div>\n<p>Parentheses are used when a reader does not want to outright declare information as factual or useful, like mentioning it as an aside. If it’s written in parentheses, try to find a better way to clearly express the information, such as by utilizing commas.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    You receive a “Subscribe” button on your channel after being accepted into one of our programs (Partner or Affiliate).\n\n- type: &quot;dont&quot;\n  body: |\n    There are two ways to receive a “Subscribe” button on your channel (after being accepted into one of our programs, Partner or Affiliate).</code></pre>\n    </div>\n<p>Sometimes parentheses can still be useful, typically when defining a term alluded to in context. Try to immediately answer the “what is that?” question a user may have if they’re relatively new to Twitch or the topic at hand. If a colon can be used in its place for better clarity and emphasis, use one instead.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    You receive a “Subscribe” button on your channel after being accepted into one of our programs (Partner or Affiliate).\n\n- type: &quot;dont&quot;\n  body: |\n    You receive a “Subscribe” button on your channel after being accepted into one of our programs.</code></pre>\n    </div>\n<h4 id="ampersands"><a href="#ampersands" aria-label="ampersands permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Ampersands</h4>\n<p>Most effective when used in heading-type text to save characters. Avoid using them in body and descriptive text.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-ampersands-7.png&quot;</code></pre>\n    </div>\n<h4 id="dashes"><a href="#dashes" aria-label="dashes permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Dashes</h4>\n<p>Em (—) and en (–) dashes do not require any spacing around them at any time. This is a style choice to save string space on mobile devices. If you need to add a dash to break up information in a string, you will use one of these. Em dashes are used for a longer, dramatic pause for more emphasis, while en dashes simply create structural breaks in language around phrases and similar.</p>\n<p>The en dash is also used for date ranges without any spacing around it.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-dashes-8.png&quot;</code></pre>\n    </div>\n<p>A hyphen should not be used between words aside from normal hyphenation,spacing never required.</p>\n<h4 id="slashes"><a href="#slashes" aria-label="slashes permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Slashes</h4>\n<p>Don’t use ‘em. If a slash is being used in place of an “and” or “or,” just use the “and” or “or” in its place.</p>\n<div>\n      <pre data-language="yml block-guidelines"><code data-language="yml block-guidelines">- type: &quot;do&quot;\n  body: |\n    You get a sub button as a Partner or Affiliate.\n\n- type: &quot;dont&quot;\n  body: |\n    You get a sub button as a Partner/Affiliate.</code></pre>\n    </div>\n<h4 id="ellipses"><a href="#ellipses" aria-label="ellipses permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Ellipses</h4>\n<p>Use on rare occasions. Truncating strings or showing countdowns by seconds when posting @everyone in chat on mobile are great uses of ellipses. Only use the ellipsis (…) symbol—not three periods. Periods create spacing bloat; an ellipsis is inherently compact and perfect for product strings.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-ellipses-9.png&quot;</code></pre>\n    </div>\n<h3 id="capitalization-and-string-length"><a href="#capitalization-and-string-length" aria-label="capitalization and string length permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Capitalization and String Length</h3>\n<p>These are the most common UI questions, and they are strongly dependent on overall design hierarchy and aesthetic—not just treated similarly between components. What applies to a web page may not apply to a modal or even the front page.</p>\n<p>Cheat sheet (applies to 9/10 instances):</p>\n<ul>\n<li>If it’s a primary or secondary CTA, title case it.</li>\n<li>It it’s an incomplete sentence you can interact with, title case it.</li>\n<li>If it’s referring to the proper name of a page or feature, title case it.</li>\n<li>Deliver maximum impact and information in minimum words.</li>\n</ul>\n<h4 id="general-terminology"><a href="#general-terminology" aria-label="general terminology permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>General terminology</h4>\n<p>There is a huge variance of capitalization rules around our products, other companies’ products, and the industry at large. <em>Do not assume</em> that because a word is the name of a product or feature that it needs to be capitalized. Luckily, there’s a helpful terminology guide below just waiting for you to absorb it like the hungry knowledge sponge you are.</p>\n<h4 id="buttons-tabs-tags-and-links"><a href="#buttons-tabs-tags-and-links" aria-label="buttons tabs tags and links permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Buttons, tabs, tags, and links</h4>\n<p>Bordered buttons, tabs, and anything resembling them in page design will always receive title case. They also never have a period placed at the end. Exclamation points and question marks should be rare and used only when essential. If you want text to excite users, write exciting text instead of forcing excitement with dull text and an exclamation point. Text should be as concise as possible.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-buttons-tabs-10.png&quot;</code></pre>\n    </div>\n<p>Borderless links <em>sometimes</em> receive title case. This text is short, technical, and used to a perform specific action in lieu of a button, typically written as a phrase or incomplete sentence. This is an exception to the helper text capitalization rule because these links serve a specific purpose and are not just offering supplemental information. <em>If a link is serving as an abstract menu or direct action, it probably needs title case.</em></p>\n<h4 id="lists"><a href="#lists" aria-label="lists permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Lists</h4>\n<p>Default dropdown text and all primary and secondary (nested) list items receive title case. Any lengthy text that describes <em>a list</em> item does not receive title case. Text should be as concise as possible for all list items.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-lists-11.png&quot;</code></pre>\n    </div>\n<h4 id="helper-text"><a href="#helper-text" aria-label="helper text permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Helper Text</h4>\n<p>This refers to any helpful text in a component that describes a primary action or visual. This text does not execute a command and typically delivers information to the user or directs them to it: it <em>helps</em> users understand Twitch. One example of helper text is hover text on links or images.</p>\n<blockquote>\n<p><strong>Core UI note:</strong> <em>Icons with simple iconography that are understood without hover text, like “X” to dismiss alerts, do not typically receive hover text. Try to limit this to improve accessibility for vision-impaired users who browse the site with reader assistants.</em></p>\n</blockquote>\n<p>If link text is borderless, wordy like a complete sentence, and used for information or redirection to documentation instead of to execute a command, it does not receive title case. It also typically does not have a period at the end despite its length and formatting as a complete sentence. Lengthy hover text does not receive title case.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-helper-text-12.png&quot;</code></pre>\n    </div>\n<h4 id="headings-and-subheadings"><a href="#headings-and-subheadings" aria-label="headings and subheadings permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Headings and subheadings</h4>\n<p>Headings are anything treated as a titled container for content. This is in reference to the information architecture within a page or product, not necessarily a text style (H1, H2, etc.) applied to product strings. They should be simple and concise, use title case, and will not have ending punctuation unless they require a question mark, colon, exclamation point, or similar.</p>\n<p>Subheadings may receive title case if there is more than one on a page and/or they are incomplete sentences dividing additional content, such as subheadings for page sections within documentation. If the subheading is a normal sentence or paragraph, use sentence case.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-headlines-13.png&quot;</code></pre>\n    </div>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-headlines-14.png&quot;</code></pre>\n    </div>\n<p>The Twitch.tv front page shelves do not receive title case because they are introductions to content, not titles for shelves (a “Live Channels” naming pattern would have received title case).</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-headlines-15.png&quot;</code></pre>\n    </div>\n<h4 id="form-text-fields"><a href="#form-text-fields" aria-label="form text fields permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Form text fields</h4>\n<p>Use sentence case in most instances. Use text that would describe to a vision-impaired user what this input field is used for; keep it short and direct. Begin text with the end result of this action whenever possible with words like Add, Search, and Enter. Add title case to any features that should be capitalized.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing--form-fields-16.png&quot;</code></pre>\n    </div>\n<h4 id="error-messages"><a href="#error-messages" aria-label="error messages permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Error messages</h4>\n<p>Keep them short and direct for common errors. Do not overwhelm the user with too much specificity aside from troubleshooting or other helpful suggestions (“Try again later”).</p>\n<blockquote>\n<p>Unable to connect. Please relaunch the app and try again.</p>\n</blockquote>\n<h4 id="file-extensions-and-abbreviations"><a href="#file-extensions-and-abbreviations" aria-label="file extensions and abbreviations permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>File extensions and abbreviations</h4>\n<p>Capitalize <em>standalone</em> file extensions and abbreviations. Include a leading period when appropriate. Here are some examples:</p>\n<ul>\n<li>OBS</li>\n<li>API</li>\n<li>DLC</li>\n<li>MOBA</li>\n<li>.JPG</li>\n</ul>\n<p>Capitalize websites and other complete names with extensions as specified per product, noting that certain domains use custom capitalization rules for their brand that may differ from their formal name. It is best practice to look up the brands themselves to see how they treat their own text in similar use. Here are some examples:</p>\n<ul>\n<li>Twitch.tv</li>\n<li>BlizzCon.com</li>\n<li>OBSProject.com</li>\n<li>avatar.jpg</li>\n</ul>\n<p>Abbreviations must remain consistent across our products. These are intended to be mobile-friendly and generally adhere to AP style. Here are some examples:</p>\n<ul>\n<li>etc. (for lists containing two or more examples; do not use “etc” or “et cetera”)</li>\n</ul>\n<blockquote>\n<p>Do not harass, heckle, harm, etc.</p>\n</blockquote>\n<ul>\n<li>et al (use sparingly; means “and so on” to list one item of many)</li>\n</ul>\n<blockquote>\n<p>You can learn more about urgent site status updates on Twitter et al.</p>\n</blockquote>\n<ul>\n<li>ex. (means “example” for a single contextual example)</li>\n</ul>\n<blockquote>\n<p>Don’t forget to add your hours on a stream schedule panel (ex. 2-5 p.m. PT).</p>\n</blockquote>\n<ul>\n<li>i.e., (means “that is” and provides a single in-context, complete example)</li>\n</ul>\n<blockquote>\n<p>Enter your business email address (i.e., where you want to receive important communications from us).</p>\n</blockquote>\n<ul>\n<li>e.g., (use sparingly; means “for example” and lists the examples afterward with serial commas)</li>\n</ul>\n<blockquote>\n<p>Box art added for many new games (e.g., Fork Knife, Ogrewatch, Wizard Poker).</p>\n</blockquote>\n<ul>\n<li>vs. (do not use “vs” and only use “versus” in longer writing formats like full paragraphs)</li>\n</ul>\n<h3 id="number-style"><a href="#number-style" aria-label="number style permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Number Style</h3>\n<p>Numbering is typically done in AP style with the exception of large figures to keep them mobile-friendly.</p>\n<h4 id="date-and-time"><a href="#date-and-time" aria-label="date and time permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Date and time</h4>\n<p>En dashes are used between ranges.</p>\n<blockquote>\n<p>[Start date]–[end date]</p>\n</blockquote>\n<blockquote>\n<p>Month [starting day]–[ending day]</p>\n</blockquote>\n<p>Abbreviate the month in three-letter style as needed due to product constraints, keeping it consistent.</p>\n<blockquote>\n<p>Apr. 21, 2019</p>\n</blockquote>\n<p>Time uses lowercase a.m. and p.m. with hours given on a 12-hour clock, denoting time zone in caps where applicable.</p>\n<blockquote>\n<p>XX:XXa.m. PDT</p>\n</blockquote>\n<h4 id="quantities"><a href="#quantities" aria-label="quantities permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Quantities</h4>\n<p>Write out numbers in letter style when the number is equal to or less than ten in casual speech. Write them out when a number represents certain quantities.</p>\n<blockquote>\n<p>You are <strong>three</strong> clicks away from getting started!</p>\n</blockquote>\n<h4 id="units"><a href="#units" aria-label="units permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Units</h4>\n<p>If the product string is using a number to represent a <em>unit</em> (time or otherwise), write in normal numerals.</p>\n<blockquote>\n<p>You receive <strong>one</strong> free monthly subscription to use on a channel of your choice every <strong>30 days</strong> with Twitch Prime.</p>\n</blockquote>\n<blockquote>\n<p>Resets in <strong>6</strong> days</p>\n</blockquote>\n<h4 id="large-figures"><a href="#large-figures" aria-label="large figures permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Large figures</h4>\n<p>Abbreviate larger numeric figures equal to or over 1,000,000. Abbreviate anything equal to or greater than 1,000 when there isn’t much space or to reduce obstruction of the element beneath it.</p>\n<p>If there is a lot of space, like when writing a sentence or heading, use the full word to represent the quantity. Since these numbers represent figures over 1,000, a number is used before the quantity.</p>\n<blockquote>\n<p>Over <strong>1 million</strong> subs!</p>\n</blockquote>\n<p>If there isn’t much space or you want to reduce obstruction as much as possible, like text over video in cards, use letter notation (K, M, B) and give rounded numbers to the first place after the decimal. Capitalization of words before and after the number follows normal title case rules for the string.</p>\n<blockquote>\n<p>8.7K viewers</p>\n</blockquote>\n<h2 id="terminology"><a href="#terminology" aria-label="terminology permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Terminology</h2>\n<p>Nine times out of ten, a quick Google search will bring up exactly what you need to know about any technical terms. Always use a reliable source as guidance over a third-party website, i.e. Facebook’s own documentation for Facebook feature capitalization standards.</p>\n<div>\n      <pre data-language="yml block-media"><code data-language="yml block-media">mediaSrc: &quot;/assets/ui/images/writing/writing-terminology-17.png&quot;</code></pre>\n    </div>\n<p>This guide is broad but not exhaustive, so please use the tools available to you before making an assumption about spelling and use of technical terms. Project Managers should have a vocabulary guide for their products available for reference.</p>\n<p>Remember one cardinal rule: <em>if you do not understand a term, chances are our users won’t understand it either</em>. Consider using simple, common language instead of industry-standard terms whenever you encounter this issue.</p>\n<h3 id="twitch"><a href="#twitch" aria-label="twitch permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Twitch</h3>\n<p><strong>Addon</strong></p>\n<ul>\n<li><em>Note: “Add on” is unrelated to the term. Addons</em> <strong><em>add on</em></strong> <em>special UI elements.</em> <strong><em>Do not</em></strong> <em>use the hyphenated form</em> “<strong><em>add-on.</em></strong>”</li>\n<li>Plural form: addons</li>\n<li>Adjectival form: addon</li>\n<li>Possessive form: addon’s</li>\n<li>Plural possessive form: addons’</li>\n</ul>\n<p><strong>Affiliate</strong></p>\n<ul>\n<li>Plural form: Affiliates</li>\n<li>Adjectival form: Affiliate</li>\n<li>Possessive form: Affiliate’s</li>\n<li>Plural possessive form: Affiliates’</li>\n</ul>\n<p><strong>AutoMod</strong></p>\n<ul>\n<li>Plural form: AutoMods</li>\n<li>Verb forms: AutoModded, AutoModding</li>\n<li>Adjectival form: AutoMod</li>\n<li>Possessive form: AutoMod’s</li>\n<li>Plural possessive form: AutoMods’</li>\n</ul>\n<p><strong>Autohost</strong></p>\n<ul>\n<li>Plural form: autohosts</li>\n<li>Adjectival form: autohost</li>\n<li>Possessive form: autohost’s</li>\n<li>Plural possessive form: autohosts’</li>\n</ul>\n<p><strong>Bit</strong></p>\n<ul>\n<li>Plural form: Bits</li>\n<li>Adjectival form: Bits</li>\n<li>Possessive form: Bits’</li>\n<li>Plural possessive form: Bits’</li>\n</ul>\n<p><strong>Bounty</strong></p>\n<ul>\n<li>Plural form: Bounties</li>\n<li>Adjectival form: Bounty</li>\n<li>Possessive form: Bounty’s</li>\n<li>Plural possessive form: Bounties’</li>\n</ul>\n<p><strong>Broadcaster</strong></p>\n<ul>\n<li><em>Note: Most formal and uncommon form of</em> <strong><em>streamer</em></strong>. <em>Use largely for error codes and troubleshooting.</em> <strong><em>Broadcast</em></strong> <em>followers similar styling and use.</em></li>\n<li>Plural form: broadcasters</li>\n<li>Noun forms: broadcaster</li>\n<li>Adjectival form: broadcaster</li>\n<li>Possessive form: broadcaster’s</li>\n<li>Plural possessive form: broadcasters’</li>\n</ul>\n<p><strong>Category</strong></p>\n<ul>\n<li>Plural form: Categories</li>\n<li>Adjectival form: Category</li>\n<li>Possessive form: Category’s</li>\n<li>Plural possessive form: Categories’</li>\n</ul>\n<p><strong>Channel</strong></p>\n<ul>\n<li>Plural form: channel</li>\n<li>Adjectival form: channel</li>\n<li>Possessive form: channel’s</li>\n<li>Plural possessive form: channels’</li>\n</ul>\n<p><strong>Cheer</strong></p>\n<ul>\n<li>Plural form: Cheers</li>\n<li>Verb form: Cheering, Cheered</li>\n<li>Adjectival form: Cheer</li>\n<li>Possessive form: Cheer’s</li>\n<li>Plural possessive form: Cheers’</li>\n</ul>\n<p><strong>Cheermote</strong></p>\n<ul>\n<li>Plural form: Cheermotes</li>\n<li>Adjectival form: Cheermote</li>\n<li>Possessive form: Cheermote’s</li>\n<li>Plural possessive form: Cheermotes’</li>\n</ul>\n<p><strong>Clip</strong></p>\n<ul>\n<li>Plural form: Clips</li>\n<li>Adjectival form: Clip</li>\n<li>Possessive form: Clip’s</li>\n<li>Possessive form: Clip’s</li>\n</ul>\n<p><strong>Collection</strong></p>\n<ul>\n<li>Plural form: Collections</li>\n<li>Adjectival form: Collection</li>\n<li>Possessive form: Collection’s</li>\n<li>Plural possessive form: Collections’</li>\n</ul>\n<p><strong>Content creator</strong></p>\n<ul>\n<li><em>Note: This is a generalized form of</em> <strong><em>streamer</em></strong>. Streamers are content creators, but not all content creators are streamers if they solely blog or upload pre-recorded videos.</li>\n<li>Noun forms: content creator, content creation</li>\n<li>Plural form: content creators</li>\n<li>Adjectival form: content creator</li>\n<li>Possessive form: content creator’s</li>\n<li>Plural possessive form: content creators’</li>\n</ul>\n<p><strong>Dashboard</strong></p>\n<ul>\n<li>Plural form: dashboards</li>\n<li>Adjectival form: dashboard</li>\n<li>Possessive form: dashboard’s</li>\n<li>Plural possessive form: dashboards’</li>\n</ul>\n<p><strong>Drop</strong></p>\n<ul>\n<li><em>Note: The proper name of the feature is “Drops.”</em></li>\n<li>Plural form: Drops</li>\n<li>Adjectival form: Drop</li>\n<li>Possessive form: Drop’s</li>\n<li>Plural possessive form: Drops’</li>\n</ul>\n<p><strong>Emote</strong></p>\n<ul>\n<li>Plural form: emotes</li>\n<li>Adjectival form: emote</li>\n<li>Possessive form: emote’s</li>\n<li>Plural possessive form: emotes’</li>\n</ul>\n<p><strong>Esports</strong></p>\n<ul>\n<li><em>Note:</em> <strong><em>Never</em></strong> <em>hyphenate (“e-sports”).</em> <strong><em>Never</em></strong> <em>capitalize the S (“eSports”).</em> <em><a href="https://twitter.com/apstylebook/status/849696651111309312?lang=en">The only exception</a></em> <em>is if a</em> <strong><em>formal name</em></strong> <em>uses one of these alternate forms as part of an</em> <strong><em>official brand</em></strong>.</li>\n<li>Plural form: esports</li>\n<li>Adjectival form: esports</li>\n<li>Possessive form: esports’</li>\n<li>Plural possessive form: esports’</li>\n</ul>\n<p><strong>Events</strong></p>\n<ul>\n<li>Plural possessive form: esports’</li>\n<li>Adjectival form: event</li>\n<li>Possessive form: event’s</li>\n<li>Plural possessive form: events’</li>\n</ul>\n<p><strong>Extensions</strong></p>\n<ul>\n<li>Plural form: extensions</li>\n<li>Adjectival form: extension</li>\n<li>Possessive form: extension’s</li>\n<li>Plural possessive form: extensions’</li>\n</ul>\n<p><strong>Follow</strong></p>\n<ul>\n<li>Plural form: follows</li>\n<li>Noun form: follower</li>\n<li>Verb forms: following, followed</li>\n<li>Adjectival form: follow</li>\n<li>Possessive form: follow’s</li>\n<li>Plural possessive form: follows’</li>\n</ul>\n<p><strong>Friend</strong></p>\n<ul>\n<li>Plural form: friends</li>\n<li>Verb form: friended, friending</li>\n<li>Adjectival form: friend</li>\n<li>Possessive form: friend’s</li>\n<li>Plural possessive form: friends’</li>\n</ul>\n<p><strong>Games Library</strong></p>\n<ul>\n<li><em>Note: This is found under the</em> <strong><em>My Games</em></strong> <em>tab in the desktop app.</em></li>\n<li>Plural form: Games Libraries</li>\n<li>Adjectival form: Games Library</li>\n<li>Possessive form: Games Library’s</li>\n<li>Plural possessive form: Games Libraries’</li>\n</ul>\n<p><strong>Gift sub</strong></p>\n<ul>\n<li><em>Note: For clarity, include “sub” with this term when possible. “Gift a subscription” and “gift a sub” are acceptable. The proper name of the feature is “Gifting.”</em>.</li>\n<li>Verb form: gifted, gifting</li>\n<li>Plural form: gifts</li>\n<li>Adjectival form: gift</li>\n<li>Possessive form: gift’s</li>\n<li>Plural possessive form: gifts’</li>\n</ul>\n<p><strong>Host</strong></p>\n<ul>\n<li>Plural form: hosts</li>\n<li>Verb forms: hosting, hosted</li>\n<li>Adjectival form: host</li>\n<li>Possessive form: host’s</li>\n<li>Plural possessive form: hosts’</li>\n</ul>\n<p><strong>Loot</strong></p>\n<ul>\n<li>Plural form: Loot</li>\n<li>Adjectival form: Loot</li>\n<li>Possessive form: Loot’s</li>\n<li>Plural possessive form: Loots’</li>\n</ul>\n<p><strong>Mod/moderator</strong></p>\n<ul>\n<li><em>Note: “Moderator” is reserved for the most formal references, like within settings, to avoid confusion with addon mods.</em></li>\n<li>Plural form: mods, moderators</li>\n<li>Adjectival form: mod, moderator</li>\n<li>Possessive form: mod’s, moderator’s</li>\n<li>Plural possessive form: mods’, moderators’</li>\n</ul>\n<p><strong>Mods (see Addons)</strong></p>\n<ul>\n<li>Plural form: mods</li>\n<li>Noun forms: mod (product), modder (creator)</li>\n<li>Verb forms: modded, modding</li>\n<li>Adjectival form: mod</li>\n<li>Possessive form: mod’s</li>\n<li>Plural possessive form: mods’</li>\n</ul>\n<p><strong>My Games</strong></p>\n<ul>\n<li>Plural form: My Games</li>\n<li>Adjectival form: My Games</li>\n<li>Possessive form: My Games’</li>\n<li>Plural possessive form: My Games’</li>\n</ul>\n<p><strong>Panels</strong></p>\n<ul>\n<li>Plural form: panels</li>\n<li>Adjectival form: panel</li>\n<li>Possessive form: panel’s</li>\n<li>Plural possessive form: panels’</li>\n</ul>\n<p><strong>Partner</strong></p>\n<ul>\n<li>Plural form: Partners</li>\n<li>Adjectival form: Partner</li>\n<li>Possessive form: Partner’s</li>\n<li>Plural possessive form: Partners’</li>\n</ul>\n<p><strong>Slow mode</strong></p>\n<ul>\n<li>Plural form: slow modes</li>\n<li>Adjectival form: slow mode</li>\n<li>Possessive form: slow mode’s</li>\n<li>Plural possessive form: slow modes’</li>\n</ul>\n<p><strong>Streamers</strong></p>\n<ul>\n<li>Plural form: streamers</li>\n<li>Adjectival form: streamer</li>\n<li>Possessive form: streamer’s</li>\n<li>Plural possessive form: streamers’</li>\n</ul>\n<p><strong>Subscription</strong></p>\n<ul>\n<li>Plural form: subscriptions</li>\n<li>Noun forms: subscription (product), subscriber (user)</li>\n<li>Verb forms: subscribing, subscribed</li>\n<li>Adjectival form: subscription</li>\n<li>Possessive form: subscription’s</li>\n<li>Plural possessive form: subscriptions’</li>\n</ul>\n<p><strong>Tag</strong></p>\n<ul>\n<li>Plural form: tags</li>\n<li>Adjectival form: tagged</li>\n<li>Verb forms: tagged, tagging</li>\n<li>Possessive form: tag’s</li>\n<li>Plural possessive form: tags’</li>\n</ul>\n<p><strong>Theater Mode</strong></p>\n<ul>\n<li><em>Note: Do not use “Theatre Mode” European spelling for enUS/default loc.</em></li>\n<li>Plural form: Theater Modes</li>\n<li>Adjectival form: Theater Mode</li>\n<li>Possessive form: Theater Mode’s</li>\n<li>Plural possessive form: Theater Modes’</li>\n</ul>\n<p><strong>Twitch Prime</strong></p>\n<ul>\n<li><em>Note: A subscription offered with this service is a “Prime sub.” “Twitch Prime” should not use a plural form, instead giving pluralization to the Prime product or offer (“free Twitch Prime games”).</em></li>\n<li>Adjectival form: Twitch Prime</li>\n<li>Possessive form: Twitch Prime’s</li>\n</ul>\n<p><strong>Video Producer</strong></p>\n<ul>\n<li>Plural form: video producers</li>\n<li>Noun forms: video producer, video production</li>\n<li>Verb forms: produced videos, producing videos</li>\n<li>Adjectival form: video producer</li>\n<li>Possessive form: video producer’s</li>\n<li>Plural possessive form: video producers’</li>\n</ul>\n<p><strong>Videos - ref to videos and Videos page</strong></p>\n<ul>\n<li>*Note: The formal name for the feature is “Videos.”</li>\n<li>Plural form: videos</li>\n<li>Adjectival form: video</li>\n<li>Possessive form: video’s</li>\n<li>Plural possessive form: videos’</li>\n</ul>\n<h3 id="other-products"><a href="#other-products" aria-label="other products permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>Other Products</h3>\n<p><strong>Like (Facebook)</strong></p>\n<ul>\n<li><em>Note: this is only for the formal feature name. You show you like content with Likes.</em></li>\n<li>Plural form: Likes</li>\n<li>Verb forms: Liked, Liking</li>\n<li>Adjectival form: Liked (i.e. “Liked Pages”)</li>\n<li>Possessive form: Like’s</li>\n<li>Plural possessive form: Likes’</li>\n</ul>\n<p><strong>Pin (Pinterest)</strong></p>\n<ul>\n<li>Plural form: Pins</li>\n<li>Verb forms: Pinned, Pinning</li>\n<li>Adjectival form: Pinned (i.e. “Pinned content”)</li>\n<li>Possessive form: Pin’s</li>\n<li>Plural possessive form: Pins’</li>\n</ul>\n<p><strong>Tweet, Retweet (Twitter)</strong></p>\n<ul>\n<li>Plural form: Tweets, Retweets</li>\n<li>Adjectival form: Tweeted (i.e. “Tweeted content”)</li>\n<li>Possessive form: host’s</li>\n<li>Plural possessive form: hosts’</li>\n</ul>\n<h3 id="general"><a href="#general" aria-label="general permalink" class="anchor"><svg aria-hidden="true" focusable="false" height="16" version="1.1" viewBox="0 0 16 16" width="16"><path fill-rule="evenodd" d="M4 9h1v1H4c-1.5 0-3-1.69-3-3.5S2.55 3 4 3h4c1.45 0 3 1.69 3 3.5 0 1.41-.91 2.72-2 3.25V8.59c.58-.45 1-1.27 1-2.09C10 5.22 8.98 4 8 4H4c-.98 0-2 1.22-2 2.5S3 9 4 9zm9-3h-1v1h1c1 0 2 1.22 2 2.5S13.98 12 13 12H9c-.98 0-2-1.22-2-2.5 0-.83.42-1.64 1-2.09V6.25c-1.09.53-2 1.84-2 3.25C6 11.31 7.55 13 9 13h4c1.45 0 3-1.69 3-3.5S14.5 6 13 6z"></path></svg></a>General</h3>\n<p><strong>Back end</strong></p>\n<ul>\n<li>Plural form: back ends</li>\n<li>Noun form: back end</li>\n<li>Adjectival form: back-end</li>\n<li>Possessive form: back end’s</li>\n<li>Plural possessive form: back ends’</li>\n</ul>\n<p><strong>Beta</strong></p>\n<ul>\n<li>Plural form: betas</li>\n<li>Adjectival form: beta</li>\n<li>Possessive form: beta’s</li>\n<li>Plural possessive form: betas’</li>\n</ul>\n<p><strong>Double click</strong></p>\n<ul>\n<li>Plural form: double clicks</li>\n<li>Adjectival form: double-click</li>\n<li>Possessive form: double click’s</li>\n<li>Plural possessive form: double clicks’</li>\n</ul>\n<p><strong>Dropdown</strong></p>\n<ul>\n<li>Plural form: dropdowns</li>\n<li>Noun form: dropdown (menu)</li>\n<li>Adjectival form: drop-down (content)</li>\n<li>Verb form: drop down (action)</li>\n<li>Possessive form: dropdown’s</li>\n<li>Plural possessive form: dropdowns’</li>\n</ul>\n<p><strong>E-commerce</strong></p>\n<ul>\n<li><em>Note: There is no plural form. Instead, the noun it describes receives pluralization (“e-commerce websites”).</em></li>\n<li>Adjectival form: e-commerce</li>\n<li>Capitalization: E-commerce</li>\n<li>Possessive form: e-commerce’s</li>\n</ul>\n<p><strong>Email</strong></p>\n<ul>\n<li>Plural form: emails</li>\n<li>Capitalization: Email</li>\n<li>Adjectival form: email</li>\n<li>Possessive form: email’s</li>\n<li>Plural possessive form: emails’</li>\n</ul>\n<p><strong>Emoji</strong></p>\n<ul>\n<li><em>Note: This term’s origin is Japanese. Similar Japanese-derived terms also do not receive special pluralization.</em></li>\n<li>Plural form: emoji</li>\n<li>Adjectival form: emoji</li>\n<li>Possessive form: emoji’s</li>\n<li>Plural possessive form: emoji’s</li>\n</ul>\n<p><strong>Front end (noun), front-end (adjective)</strong></p>\n<ul>\n<li>Plural form: front ends</li>\n<li>Noun form: front end</li>\n<li>Adjectival form: front-end</li>\n<li>Possessive form: front end’s</li>\n<li>Plural possessive form: front ends’</li>\n</ul>\n<p><strong>Fullscreen</strong></p>\n<ul>\n<li><em>Note: There is no plural form. Instead, the noun it describes receives pluralization (“fullscreen videos”).</em></li>\n<li>Verb forms: fullscreened, fullscreening</li>\n<li>Adjectival form: fullscreen</li>\n<li>Possessive form: fullscreen’s</li>\n</ul>\n<p><strong>Hashtag</strong></p>\n<ul>\n<li><em>Note: A tag is a tag. A hashtag is specific to a tag preceded by a hash (“#”). Don’t abuse “hashtag” or the grammar police will intervene.</em></li>\n<li>Plural form: hashtags</li>\n<li>Adjectival form: hashtagged (content)</li>\n<li>Verb forms: hashtagged, hashtagging</li>\n<li>Possessive form: hashtag’s</li>\n<li>Plural possessive form: hashtags’</li>\n</ul>\n<p><strong>Internet</strong></p>\n<ul>\n<li><em>Note: There is no plural form. Instead, the noun it describes receives pluralization (“internet connections”).</em></li>\n<li>Adjectival form: internet</li>\n<li>Possessive form: internet’s</li>\n</ul>\n<p><strong>Login/log in</strong></p>\n<ul>\n<li><em>Note: The trick to remembering this is you log in with your login credentials.</em></li>\n<li>Plural form: logins</li>\n<li>Noun form: login (credentials)</li>\n<li>Adjectival form: login (elements)</li>\n<li>Verb form: log in (action)</li>\n<li>Possessive form: login’s</li>\n<li>Plural possessive form: logins’</li>\n</ul>\n<p><strong>Okay</strong></p>\n<ul>\n<li><em>Note: Do not use “OK” or “ok.” This term seldom operates alone; the object it is paired with will be further modified as needed (“clicking okay,” “okay button”).</em></li>\n<li>Adjectival form: okay</li>\n<li>Capitalization: Okay</li>\n<li>Noun form: okay</li>\n</ul>\n<p><strong>Opt-in</strong></p>\n<ul>\n<li>Plural form: opt-ins</li>\n<li>Noun form: opt-in (election)</li>\n<li>Adjectival form: opt-in (format)</li>\n<li>Verb form: opt in (action)</li>\n<li>Possessive form: opt-in’s</li>\n<li>Plural possessive form: opt-ins’</li>\n</ul>\n<p><strong>Pop-up</strong></p>\n<ul>\n<li>Plural form: pop-ups</li>\n<li>Noun form: pop-up (window)</li>\n<li>Adjectival form: pop-up (elements)</li>\n<li>Verb form: pop up (action)</li>\n<li>Possessive form: pop-up’s</li>\n<li>Plural possessive form: pop-ups’</li>\n</ul>\n<p><strong>Sign-up</strong></p>\n<ul>\n<li>Plural form: sign-ups</li>\n<li>Noun form: sign-up (election)</li>\n<li>Adjectival form: sign-up (format)</li>\n<li>Verb form: sign up (action)</li>\n<li>Possessive form: sign-up’s</li>\n<li>Plural possessive form: sign-ups’</li>\n</ul>\n<p><strong>Sync</strong></p>\n<ul>\n<li><em>Note: “Friend Sync” is a feature that syncs your friends from other services.</em></li>\n<li>Plural form: syncs</li>\n<li>Adjectival form: sync</li>\n<li>Verb forms: synced, syncing</li>\n<li>Possessive form: sync’s</li>\n<li>Plural possessive form: syncs’</li>\n</ul>\n<p><strong>Username</strong></p>\n<ul>\n<li><em>Note: Listed for spelling; do not use a space.</em></li>\n</ul>\n<p><strong>URL</strong></p>\n<ul>\n<li><em>Note: Listed for spelling; always use all caps.</em></li>\n</ul>\n<p><strong>Website, web</strong></p>\n<ul>\n<li><em>Note: Listed for spelling; always lowercase these terms.</em></li>\n</ul>\n<p><strong>Wi-Fi</strong></p>\n<ul>\n<li><em>Note: Listed for spelling; always capitalize and hyphenate as shown.</em></li>\n</ul>',
      },
    },
  },
};
