// tslint:disable-next-line: prettier
import type { Reporter } from "tachyon-spade-reporter";
import { AppReporter } from "./appReporter";
import type { AllEvents } from "./events";

/* This constructor should be called once in the browser, and be used for any spade event logging */
export const constructReporter = async (): Promise<Reporter<AllEvents>> => {
  const spadeUri = await getSpadeUri();
  const opts = {
    platform: window?.navigator?.platform || "web",
    app_version: window?.navigator?.appVersion || "",
    language: window?.navigator?.language || "",
    organization_id: "",
    is_e2_whitelisted: false,
  };
  return new AppReporter({ spadeUri, debug: true, staticProps: opts });
};

export const reportPageview = (properties: { location: string }) => {
  reportEvent({
    event: "pageview",
    properties,
  });
};

const reportEvent = (event: AllEvents) => {
  (window as any).spadeReporter?.reportEvent(event);
};

const getSpadeUri = async (): Promise<string> => {
  // Spade URI is rotating. See https://wiki.twitch.com/display/DI/Spade+URI
  const SPADE_URI_RESOURCE = "http://science-output.s3.amazonaws.com/spade-uri";
  const FALLBACK_SPADE_URI = "https://spade.twitch.tv";
  let response;
  try {
    // TODO: use actuator service to fetch spade URI
    //       see: https://twitch.slack.com/archives/C91RTN4KG/p1593462170276100
    const payload: RequestInit = {
      method: "GET",
    };
    response = await fetch(SPADE_URI_RESOURCE, payload);
  } catch (e) {
    console.error("Error in fetching spade URI:", e);
    return FALLBACK_SPADE_URI;
  }
  const spadeUri = String(response.body);
  const expression = /[-a-zA-Z0-9@:%._\+~#=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()@:%_\+.~#?&//=]*)?/gi;
  const urlRegex = new RegExp(expression);

  if (!spadeUri.match(urlRegex)) {
    console.error("no match", spadeUri);
    return FALLBACK_SPADE_URI;
  }
  return spadeUri;
};
