import { getDisplayTitle } from "./display-titles";

describe("display-title utils", () => {
  it("renders a custom title if set in the frontmatter", () => {
    const file: any = {
      childMarkdownRemark: {
        frontmatter: {
          title: "Custom Title",
          component: {
            id: "components/channel-status-indicator",
          },
        },
      },
      fields: {
        title: "Channel Status Indicator",
      },
    };

    expect(getDisplayTitle(file)).toBe("Custom Title");
  });

  it("renders a title with no spaces if component is set", () => {
    const file: any = {
      childMarkdownRemark: {
        frontmatter: {
          component: {
            id: "components/channel-status-indicator",
          },
        },
      },
      fields: {
        title: "Channel Status Indicator",
      },
    };

    expect(getDisplayTitle(file)).toBe("ChannelStatusIndicator");
  });

  it("renders the default title if nothing else is specified", () => {
    const file: any = {
      fields: {
        title: "Channel Status Indicator",
      },
    };

    expect(getDisplayTitle(file)).toBe("Channel Status Indicator");
  });
});
