import * as Remark from "remark";
import * as RemarkHtml from "remark-html";
import { CoreLinkProps } from "twitch-core-ui";

export const parseMarkdownFromString = (source: string) => {
  let markdown = "";

  Remark()
    .data("settings", {
      commonmark: true,
      pedantic: true,
    })
    .use(RemarkHtml)
    .process(source, (err: any, file: any) => {
      if (err) {
        console.error(err);
      }

      markdown = file.contents;
    });

  return markdown;
};

interface ExtractedLinkMatch {
  props: CoreLinkProps;
  index: number;
}

interface ExtractedLinks {
  text: string;
  links: ExtractedLinkMatch[];
}

/**
 * Extracts markdown links from a string
 *
 * @param source
 */
export const extractMarkdownLinksFromString = (
  source: string,
  limit: number = -1,
): ExtractedLinks => {
  const regexForMarkdownLinks = /(?:__|[*#])|\[(.*?)\]\((.*?)\)/g;

  let links: ExtractedLinkMatch[] = [];
  let match = regexForMarkdownLinks.exec(source);
  let text = source;

  while (match && (limit < 0 || links.length < limit)) {
    links.push({
      index: match.index,
      props: {
        children: match[1],
        linkTo: match[2],
      },
    });
    text = text.replace(match[0], "");
    match = regexForMarkdownLinks.exec(source);
  }

  return {
    text: text.trim(),
    links,
  };
};
