import { Link } from "gatsby";
import * as React from "react";
import { CoreInteractiveProps } from "twitch-core-ui";

export const renderLink = (props: CoreInteractiveProps) => {
  if (!props.linkTo || typeof props.linkTo !== "string") {
    throw "Gatsby uses @reach/router which only accepts a string for the linkTo prop.";
  }

  /**
   * Gatsby requires an <a> tag to handle external or file download links
   *
   * See https://www.gatsbyjs.org/docs/gatsby-link/#reminder-use-link-only-for-internal-links
   */
  const endsWithFileExtension = /\.[0-9a-z]+$/i.test(props.linkTo);
  if (endsWithFileExtension) {
    return (
      <a
        href={props.linkTo}
        className={props.className}
        download={props.download}
        ref={props.refHandler}
        target={props.targetBlank ? "_blank" : undefined}
        onClick={props.onClick}
        onDoubleClick={props.onDoubleClick}
        onContextMenu={props.onContextMenu}
        onMouseEnter={props.onMouseEnter}
        onMouseLeave={props.onMouseLeave}
        role={props.role}
        tabIndex={props.tabIndex}
      >
        {props.children}
      </a>
    );
  }

  return (
    // @ts-ignore
    <Link
      className={props.className}
      to={props.linkTo}
      tabIndex={props.tabIndex}
      onClick={props.onClick}
      onMouseEnter={
        props.onMouseEnter as React.MouseEventHandler<HTMLAnchorElement>
      }
      onMouseLeave={
        props.onMouseLeave as React.MouseEventHandler<HTMLAnchorElement>
      }
    >
      {props.children}
    </Link>
  );
};
