import { FileEdge } from "../graphql-types";

export function sortByRelativePath(array: FileEdge[]) {
  array.sort((a, b) => {
    if (a.node && a.node.relativePath && b.node && b.node.relativePath) {
      if (
        a.node.relativePath.replace(/-/g, "") <
        b.node.relativePath.replace(/-/g, "")
      ) {
        return -1;
      }
      if (
        a.node.relativePath.replace(/-/g, "") >
        b.node.relativePath.replace(/-/g, "")
      ) {
        return 1;
      }
    }
    return 0;
  });
  return array;
}
