module.exports.getSegementsFromPath = path => {
  let segments = [];

  path
    .replace(/.md$/, "")
    .split("/")
    .map(s => {
      let slug = formatSlug(s);
      segments.push({
        slug,
        title: tabSlugToTitle(slug),
      });
    });
  return segments;
};

module.exports.getPagePath = (path, tab) => {
  if (tab && tab !== "index") {
    return path + "/" + tab;
  } else {
    return path;
  }
};

/**
 * COPY/PASTED FROM:
 *     src/utils/display-titles.ts
 *
 * TODO:
 *     Import this typescript helper once this file is actually converted to Typescript
 */
function getDisplayTitle(file) {
  if (
    file.childMarkdownRemark &&
    file.childMarkdownRemark.frontmatter &&
    file.childMarkdownRemark.frontmatter.title
  ) {
    return file.childMarkdownRemark.frontmatter.title;
  }

  if (
    file.childMarkdownRemark &&
    file.childMarkdownRemark.frontmatter &&
    file.childMarkdownRemark.frontmatter.component &&
    file.childMarkdownRemark.frontmatter.component.id &&
    file.fields &&
    file.fields.title
  ) {
    return file.fields.title.replace(/\s/g, "");
  }

  if (file.fields && file.fields.title) {
    return file.fields.title;
  }

  return "";
}

function tabSlugToTitle(slug) {
  return slug === "index" ? "Overview" : formatTitle(slug);
}

/**
 * Returns a slug with the number prefix and extension removed from the
 * segment. (ie. `formatSlug('1-usage.md')` returns `brand`).
 *
 * @param {string} segment
 */
function formatSlug(segment) {
  return segment.replace(/^\d+-\s*/, "").replace(/\..*$/, "");
}

/**
 * Returns a pretty with title uppercase letters and spaces from a slug.
 *
 * @param {string} slug
 */
function formatTitle(slug) {
  return slug.replace(/-/g, " ").replace(/\w\S*/g, function(txt) {
    return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
  });
}

// Export for tests.
module.exports.formatSlug = formatSlug;
module.exports.formatTitle = formatTitle;
module.exports.tabSlugToTitle = tabSlugToTitle;
module.exports.getDisplayTitle = getDisplayTitle;
