const gatsbyHelpers = require("./gatsby-helpers");

describe("gatsby helpers", () => {
  it("formatSlug renders a slug", () => {
    expect(gatsbyHelpers.formatSlug("1-usage.md")).toEqual("usage");
    expect(gatsbyHelpers.formatSlug("index.md")).toEqual("index");
    expect(gatsbyHelpers.formatSlug("1-user-interface")).toEqual(
      "user-interface",
    );
  });

  it("formatTitle renders a title formatted string from a slug", () => {
    expect(gatsbyHelpers.formatTitle("user-interface")).toEqual(
      "User Interface",
    );
    expect(gatsbyHelpers.formatTitle("brand")).toEqual("Brand");
  });

  it("getPagepath renders a page path to the index page when the tab is index", () => {
    expect(
      gatsbyHelpers.getPagePath(
        "/user-interface/components/animation",
        "index",
      ),
    ).toEqual("/user-interface/components/animation");
  });

  it("getPagepath renders a page path to the tab page when tab is not index", () => {
    expect(
      gatsbyHelpers.getPagePath(
        "/user-interface/components/animation",
        "properties",
      ),
    ).toEqual("/user-interface/components/animation/properties");
  });

  it("getSegmentsFromPath returns an array of URL segments", () => {
    const path = "2-user-interface/5-components/aspect/usage.md";

    const expected = [
      {
        title: "User Interface",
        slug: "user-interface",
      },
      {
        title: "Components",
        slug: "components",
      },
      {
        title: "Aspect",
        slug: "aspect",
      },
      {
        title: "Usage",
        slug: "usage",
      },
    ];

    expect(gatsbyHelpers.getSegementsFromPath(path)).toEqual(expected);
  });

  it("getSegmentsFromPath replaces the title index with Overview", () => {
    const path = "aspect/index.md";

    const expected = [
      {
        title: "Aspect",
        slug: "aspect",
      },
      {
        title: "Overview",
        slug: "index",
      },
    ];

    expect(gatsbyHelpers.getSegementsFromPath(path)).toEqual(expected);
  });
});
