import * as ec2 from '@aws-cdk/aws-ec2';
import * as servicediscovery from '@aws-cdk/aws-servicediscovery';
import * as cdk from '@aws-cdk/core';

import { CommonProps } from './common-props';
import * as utils from './utils';

interface CloudmapStackProps extends CommonProps {
  domainName: string;
  vpc: ec2.Vpc;
}

export class CloudmapStack extends cdk.Stack {
  public readonly namespace: servicediscovery.INamespace;

  constructor(scope: cdk.Construct, props: CloudmapStackProps) {
    super(scope, `${props.envName}Namespace${utils.titleCase(props.domainName)}`, props);
    cdk.Tag.add(this, 'environment', props.envName.toLowerCase());
    this.namespace = new servicediscovery.PrivateDnsNamespace(this, 'Namespace', { name: 'eml', vpc: props.vpc });
  }
}
