import * as ec2 from '@aws-cdk/aws-ec2';
import * as cdk from '@aws-cdk/core';

export interface CommonProps extends cdk.StackProps {
  envName: string;
  externalDomainName?: string;
  internalDomainName: string;
  logLevel: string;
}

export interface TaskScalingProps {
  cpu: number;
  memoryLimitMiB: number;
  taskCount: number;
}

export interface Ec2ScalingProps extends TaskScalingProps {
  instanceType: ec2.InstanceType;
  asgCapacity: number; // number of AutoScalingGroup instances to host the tasks
  minHealthyPercent?: number; // percentage of min active tasks during a deployment. Default 100%.
  maxHealthyPercent?: number; // percentage of max active tasks during a deployment. Default 200%.
}

export interface GreeterScalingProps extends TaskScalingProps {
  authMethods: string[];
}

export interface SourceScalingProps extends Ec2ScalingProps {
  rateLimitCount: string;
  rateLimitPeriod: string;
}
