import * as ec2 from '@aws-cdk/aws-ec2';
import * as route53 from '@aws-cdk/aws-route53';
import * as cdk from '@aws-cdk/core';

export class InterfaceVpcEndpointTarget implements route53.IAliasRecordTarget {
  constructor(readonly endpoint: ec2.InterfaceVpcEndpoint) {}

  // select the first DNS entry an extract host zone + dns name from it
  public bind(): route53.AliasRecordTargetConfig {
    const parts = cdk.Fn.split(':', cdk.Fn.select(0, this.endpoint.vpcEndpointDnsEntries));
    return {
      hostedZoneId: cdk.Fn.select(0, parts),
      dnsName: cdk.Fn.select(1, parts),
    };
  }
}
