import * as awslogs from '@aws-cdk/aws-logs';
import * as cdk from '@aws-cdk/core';
import { CommonProps } from './common-props';

export class LogGroupStack extends cdk.Stack {
  public readonly logGroup: awslogs.LogGroup;

  constructor(scope: cdk.Construct, serviceName: string, props: CommonProps) {
    super(scope, `${props.envName}${serviceName}LogGroup`, props);
    cdk.Tag.add(this, 'service', serviceName.toLowerCase());
    cdk.Tag.add(this, 'environment', props.envName.toLowerCase());

    this.logGroup = new awslogs.LogGroup(this, 'Logs', {
      retention: awslogs.RetentionDays.SIX_MONTHS,
    });
  }
}
