import * as ecr from '@aws-cdk/aws-ecr';
import * as cdk from '@aws-cdk/core';

import { CommonProps } from './common-props';

// Must be created and seeded with "latest" containers before the service stacks are created.
export class RepositoryStack extends cdk.Stack {
  public readonly repo: ecr.IRepository;

  constructor(scope: cdk.Construct, serviceName: string, props: CommonProps) {
    super(scope, `${props.envName}${serviceName}Repository`, props);
    cdk.Tag.add(this, 'service', serviceName.toLowerCase());
    cdk.Tag.add(this, 'environment', props.envName.toLowerCase());

    const repo = new ecr.Repository(this, `${serviceName}Repository`, {
      removalPolicy: cdk.RemovalPolicy.DESTROY,
    });
    repo.addLifecycleRule({ maxImageCount: 10 });
    this.repo = repo;
  }
}
