import { Bucket, IBucket } from '@aws-cdk/aws-s3';
import { Construct, Stack } from '@aws-cdk/core';

import { CommonProps } from './common-props';

interface S3BucketStackProps extends CommonProps {
  bucketName: string;
}

export class S3BucketStack extends Stack {
  public bucket: IBucket;

  constructor(scope: Construct, id: string, props: S3BucketStackProps) {
    super(scope, `${props.envName}${id}`, props);

    this.bucket = new Bucket(this, 'S3Bucket', {
      bucketName: props.bucketName,
    });
  }
}
