import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';

import { CommonProps } from './common-props';

export class SecretsStack extends cdk.Stack {
  public readonly greeterClient: secretsmanager.ISecret;
  public readonly greeterHost: secretsmanager.ISecret;
  public readonly greeterPeer: secretsmanager.ISecret;
  public readonly pathfinderClient: secretsmanager.ISecret;
  public readonly pathfinderHost: secretsmanager.ISecret;
  public readonly pathfinderPeer: secretsmanager.ISecret;

  constructor(scope: cdk.Construct, props: CommonProps) {
    super(scope, `${props.envName}Secrets`, props);
    cdk.Tag.add(this, 'environment', props.envName.toLowerCase());

    this.greeterClient = new secretsmanager.Secret(this, 'GreeterClientAuth', {
      secretName: 'greeter-client-auth',
    });
    this.greeterHost = new secretsmanager.Secret(this, 'GreeterHostAuth', { secretName: 'greeter-host-auth' });
    this.greeterPeer = new secretsmanager.Secret(this, 'GreeterPeerAuth', { secretName: 'greeter-peer-auth' });
    this.pathfinderClient = new secretsmanager.Secret(this, 'PathfinderClientAuth', {
      secretName: 'pathfinder-client-auth',
    });
    this.pathfinderHost = new secretsmanager.Secret(this, 'PathfinderHostAuth', {
      secretName: 'pathfinder-host-auth',
    });
    this.pathfinderPeer = new secretsmanager.Secret(this, 'PathfinderPeerAuth', {
      secretName: 'pathfinder-peer-auth',
    });
  }
}
