import * as ec2 from '@aws-cdk/aws-ec2';
import * as cdk from '@aws-cdk/core';

import { CommonProps } from './common-props';

export class VpcStack extends cdk.Stack {
  public readonly vpc: ec2.Vpc;

  constructor(scope: cdk.Construct, props: CommonProps) {
    super(scope, `${props.envName}Vpc`, props);
    cdk.Tag.add(this, 'environment', props.envName.toLowerCase());

    this.vpc = new ec2.Vpc(this, 'Vpc', { maxAzs: 3 });
  }
}
