import * as route53 from '@aws-cdk/aws-route53';
import * as cdk from '@aws-cdk/core';

import { CommonProps } from './common-props';

// Route 53 zones for the prod account.
export class ZonesStack extends cdk.Stack {
  public readonly internalZone: route53.IHostedZone;
  public readonly publicZone?: route53.IHostedZone;

  constructor(scope: cdk.Construct, props: CommonProps) {
    super(scope, `${props.envName}Zones`, props);
    cdk.Tag.add(this, 'environment', props.envName.toLowerCase());

    this.internalZone = route53.HostedZone.fromLookup(this, 'InternalZone', {
      domainName: props.internalDomainName,
    });
    if (props.externalDomainName) {
      this.publicZone = route53.HostedZone.fromLookup(this, 'PublicZone', {
        domainName: props.externalDomainName,
      });
    }
  }
}
