import { AddressBuilderImpl } from './address/address_builder_impl';
import { AddressBuilder } from './address_builder';
import { AddressScope } from './address_scope';
import * as errors from './errors';

export interface Address extends AddressScope {
  readonly namespace: string;
  readonly version: number;
  filter(param: string): string | undefined;
}

export class Address {
  public static forNamespace(namespace: string): AddressBuilder {
    return new AddressBuilderImpl().withNamespace(namespace);
  }

  public static parse(key: string): Address {
    const vIndex = key.indexOf('@');
    if (vIndex < 2) {
      throw errors.MissingVersion;
    }

    const fIndex = key.indexOf('?');
    const version = parseInt(fIndex === -1 ? key.substr(vIndex + 1) : key.slice(vIndex + 1, fIndex), 10);
    if (version < 1) {
      throw errors.IllegalVersion;
    }

    const builder = Address.forNamespace(key.slice(0, vIndex)).withVersion(version);
    if (fIndex === -1) {
      return builder.build();
    }

    const segments = key.substr(fIndex + 1).split('&');
    for (const seg of segments) {
      const eIndex = seg.indexOf('=');
      if (eIndex === -1) {
        throw errors.IllegalFilter;
      }
      builder.withFilter(seg.slice(0, eIndex), seg.substr(eIndex + 1));
    }
    return builder.build();
  }
}
