import { Address } from '../address';
import { AnyAddress } from './any_address';

export class SimpleAddress implements Address {
  constructor(readonly namespace: string, readonly version: number) {}
  public get key(): string { return `${this.namespace}@${this.version}`; }
  public get cardinality(): number { return 1; }
  public get parents() { return [AnyAddress]; }
  public filter() { return undefined; }
  public includes(addr: Address) {
    return addr.namespace === this.namespace && addr.version === this.version;
  }
}
