import { Address } from '../address';
import { AddressScope } from '../address_scope';
import { SimpleAddress } from './simple_address';

export class SingleFilterAddress implements Address {
  public readonly parents: AddressScope[];
  public readonly key: string;
  constructor(
    readonly namespace: string,
    readonly version: number,
    private readonly param: string,
    private readonly value: string,
  ) {
    this.parents = [new SimpleAddress(namespace, version)];
    this.key = `${this.namespace}@${this.version}?${this.param}=${this.value}`;
  }
  public get cardinality(): number { return 2; }
  public filter(param: string) {
    return param === this.param ? this.value : undefined;
  }
  public includes(addr: Address) {
    return addr.namespace === this.namespace &&
      addr.version === this.version &&
      addr.filter(this.param) === this.value;
  }
}
