import { Address } from './address';

// An AddressScope defines a boundary for related addresses; it is used to
// resolve inter-address filtering relationships and answer the requestion of
// whether a particular service can serve an address.
//
// The key field is used for equality checking addresses as an exact match
// which allows efficient grouping of memberships.
export interface AddressScope {
  readonly key: string;
  readonly parents: AddressScope[];
  readonly cardinality: number;
  includes(addr: Address): boolean; // scopes
}
