
// note: long term this is meant to convert a program code to a human readable
// error, and could potentially be integrated with an i18n product.
export function get(errCode: string): Error {
  if (errCode.startsWith('err_')) {
    return Error(errCode.substr(4));
  }
  return Error(errCode);
}

export const MissingNamespaceCode = 'err_missing_namespace';
export const MissingNamespace = get(MissingNamespaceCode);
export const MissingVersionCode = 'err_missing_version';
export const MissingVersion = get(MissingVersionCode);
export const IllegalFilterCode = 'err_illegal_filter';
export const IllegalFilter = get(IllegalFilterCode);
export const IllegalNamespaceCode = 'err_illegal_namespace';
export const IllegalNamespace = get(IllegalNamespaceCode);
export const IllegalVersionCode = 'err_illegal_version';
export const IllegalVersion = get(IllegalVersionCode);
export const UseBuilderCode = 'err_use_builder';
export const UseBuilder = get(UseBuilderCode);
