import { AuthSource } from './auth_data';
import { LogFunction } from './log_function';
import { Registry } from './registry';
import { Discovery } from './registry/discovery';
import { Remote } from './registry/remote';

export function Register(address: string, auth: AuthSource, log: LogFunction): Registry {
  return new Remote(new Discovery(address, auth, log), log);
}

export { Address } from './address';
export { AuthData, AuthSource } from './auth_data';
export { LogFunction, LogLevel, SetLevel } from './log_function';
export { Listener } from './listener';
export { Position } from './position';
export { Registry } from './registry';
export { Reader } from './reader';
export { Segment } from './segment';
export { Source } from './source';
export { Writer } from './writer';
