import { Address } from './address';
import { Position } from './position';
import { Segment } from './segment';
import { Source } from './source';

export interface Listener {
  currentPosition(addr: Address): Position | undefined;
  onDataLost(addr: Address, src: Source, at: Segment): void;
  onDataReceived(addr: Address, src: Source, at: Segment, data: ArrayBuffer): void;
  onStreamClosed(addr: Address, err?: Error): void;
}
