export enum LogLevel { Debug = 'debug', Info = 'info', Warning = 'warning', Error = 'error' }
export type LogFunction = (level: LogLevel, ...params: any) => void;
export type LogLevelFunction = () => LogLevel;

function isLogLevelFunction(level: LogLevel | LogLevelFunction): level is LogLevelFunction {
  return typeof level === 'function';
}

export function SetLevel(level: LogLevel | LogLevelFunction, src: (...params: any) => void): LogFunction {
  let func: LogLevelFunction;
  if (isLogLevelFunction(level)) {
    func = level;
  } else {
    func = () => level as LogLevel;
  }
  return (msgLevel: LogLevel, ...params: any) => {
    const comp = func();
    if (comp > msgLevel) {
      return;
    }
    params.unshift(msgLevel);
    src(...params);
  };
}
