import { Address } from '../address';
import { Position } from '../position';
import { Binding } from './binding';
import { DeferredWrite } from './deferred_write';
import { ResponseHandler } from './response_handler';

export class DeferredClose implements DeferredWrite {
    public readonly result = new ResponseHandler<boolean>();

    public execute(address: Address, binding: Binding): Promise<boolean | Position> {
        this.result.bind(binding.release(address));
        return this.result.promise;
    }
 }
