import { Address } from '../address';
import { Position } from '../position';
import { Binding } from './binding';
import { DeferredWrite } from './deferred_write';
import { ResponseHandler } from './response_handler';

export class DeferredMessage implements DeferredWrite {
  public readonly content: ArrayBuffer;
  public readonly result = new ResponseHandler<Position>();
  constructor(src: ArrayBuffer, readonly isDelta: boolean) {
    // copy content so that src can be updated safely
    this.content = src.slice(0);
  }

  public execute(address: Address, binding: Binding): Promise<boolean | Position> {
    this.result.bind(binding.send(address, this.content, this.isDelta));
    return this.result.promise;
  }
}
