import { Address } from '../address';
import { AnyAddress } from '../address/any_address';
import { AddressScope } from '../address_scope';
import { AuthData } from '../auth_data';

const methodReservation = 1;
const methodValidation = 2;

export class DiscoveryResult {
  public static fromHttpResult(result: any): DiscoveryResult {
    const scopes = new Set<AddressScope>();
    if (!result.scopes) {
      scopes.add(AnyAddress);
    } else {
      for (const scope of result.scopes) {
        if (scope === '*') {
          scopes.add(AnyAddress);
        } else {
          scopes.add(Address.parse(scope));
        }
      }
    }
    return new DiscoveryResult(result.host_address, methodReservation, result.access_code, scopes);
  }

  public static fromAuthData(hostAddress: string, data: AuthData) {
    const scopes = new Set<AddressScope>();
    scopes.add(AnyAddress);
    return new DiscoveryResult(hostAddress, methodValidation, `extjwt::${data.clientId}::${data.token}`, scopes);
  }

  constructor(
    readonly hostUrl: string,
    readonly method: number,
    readonly accessCode: string,
    readonly scopes: Set<AddressScope>) {}
}
